/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.StreamSupport;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.storage.RoadGraphState;
import net.oxcodsnet.roadarchitect.storage.components.Node;
import net.oxcodsnet.roadarchitect.util.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StructureLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect" + StructureLocator.class.getSimpleName()));
    private static final DynamicCommandExceptionType INVALID_STRUCTURE_EXCEPTION = new DynamicCommandExceptionType(id -> Component.translatable((String)"commands.locate.structure.invalid", (Object[])new Object[]{id}));

    private StructureLocator() {
    }

    public static List<Pair<BlockPos, String>> scanGridAsync(ServerLevel world, BlockPos origin, int overallRadius, int scanRadius, List<String> structureSelectors) {
        List<Pair<BlockPos, String>> list = StructureLocator.performGridScan(world, origin, overallRadius, scanRadius, structureSelectors);
        StructureLocator.schedulePersistence(world, list);
        return list;
    }

    private static List<Pair<BlockPos, String>> performGridScan(ServerLevel world, BlockPos origin, int overallRadius, int scanRadius, List<String> structureSelectors) {
        int step = scanRadius * 2 + 1;
        int originChunkX = origin.getX() >> 4;
        int originChunkZ = origin.getZ() >> 4;
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        List<Pair<BlockPos, String>> allFound = Collections.synchronizedList(new ArrayList());
        for (int dx = -overallRadius; dx <= overallRadius; dx += step) {
            for (int dz = -overallRadius; dz <= overallRadius; dz += step) {
                int chunkX = originChunkX + dx;
                int chunkZ = originChunkZ + dz;
                StructureLocator.scanCell(world, origin, chunkX, chunkZ, scanRadius, structureSelectors, seen, allFound);
            }
        }
        return allFound;
    }

    private static void scanCell(ServerLevel world, BlockPos origin, int chunkX, int chunkZ, int scanRadius, List<String> structureSelectors, Set<BlockPos> seen, List<Pair<BlockPos, String>> out) {
        BlockPos.MutableBlockPos scanOrigin = new BlockPos.MutableBlockPos((chunkX << 4) + 8, origin.getY(), (chunkZ << 4) + 8);
        List<Pair<BlockPos, String>> local = StructureLocator.findStructures(world, scanOrigin.immutable(), scanRadius, structureSelectors);
        BlockPos.MutableBlockPos tmp = new BlockPos.MutableBlockPos();
        for (Pair<BlockPos, String> pair : local) {
            BlockPos p = (BlockPos)pair.getFirst();
            int y = CacheManager.getHeight(world, p.getX(), p.getZ());
            tmp.set(p.getX(), y, p.getZ());
            BlockPos key = tmp.immutable();
            if (!seen.add(key)) continue;
            out.add((Pair<BlockPos, String>)Pair.of((Object)key, (Object)((String)pair.getSecond())));
        }
    }

    private static List<Pair<BlockPos, String>> findStructures(ServerLevel world, BlockPos origin, int radius, List<String> structureSelectors) {
        ArrayList<Pair<BlockPos, String>> foundPositions = new ArrayList<Pair<BlockPos, String>>();
        Registry registry = world.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        for (String selector : structureSelectors) {
            try {
                ResourceOrTagKeyArgument argType = new ResourceOrTagKeyArgument(Registries.STRUCTURE);
                ResourceOrTagKeyArgument.Result predicate = argType.parse(new StringReader(selector));
                HolderSet<Structure> structList = StructureLocator.getStructureList((ResourceOrTagKeyArgument.Result<Structure>)predicate, (Registry<Structure>)registry).orElseThrow(() -> INVALID_STRUCTURE_EXCEPTION.create((Object)selector));
                Pair located = world.getChunkSource().getGenerator().findNearestMapStructure(world, structList, origin, radius, true);
                if (located == null) continue;
                ResourceLocation id = registry.getKey((Object)((Structure)((Holder)located.getSecond()).value()));
                foundPositions.add((Pair<BlockPos, String>)Pair.of((Object)((BlockPos)located.getFirst()), (Object)String.valueOf(id)));
            }
            catch (CommandSyntaxException ex) {
                LOGGER.error("Selector '{}' failed: {}", (Object)selector, (Object)ex.getMessage());
            }
        }
        return foundPositions;
    }

    private static void schedulePersistence(ServerLevel world, List<Pair<BlockPos, String>> found) {
        RoadGraphState graph = RoadGraphState.get(world, RoadArchitect.CONFIG.maxConnectionDistance());
        for (Pair<BlockPos, String> pair : found) {
            Node node = graph.addNodeWithEdges((BlockPos)pair.getFirst(), (String)pair.getSecond());
            LOGGER.debug("Added node {} at {}", (Object)node.id(), (Object)node.pos());
        }
        graph.setDirty();
    }

    private static Optional<? extends HolderSet<Structure>> getStructureList(ResourceOrTagKeyArgument.Result<Structure> predicate, Registry<Structure> registry) {
        return (Optional)predicate.unwrap().map(key -> registry.get(key.location()).map(xva$0 -> HolderSet.direct((Holder[])new Holder[]{xva$0})), tag -> {
            List entries = StreamSupport.stream(registry.getTagOrEmpty(tag).spliterator(), false).toList();
            return Optional.of(HolderSet.direct(entries));
        });
    }
}

