/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.worldgen;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.phys.Vec3;
import net.oxcodsnet.roadarchitect.storage.PathStorage;
import net.oxcodsnet.roadarchitect.storage.RoadBuilderStorage;
import net.oxcodsnet.roadarchitect.worldgen.RoadFeatureConfig;
import net.oxcodsnet.roadarchitect.worldgen.style.RoadStyle;
import net.oxcodsnet.roadarchitect.worldgen.style.RoadStyles;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.BuoyDecoration;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.Decoration;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.FenceDecoration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoadFeature
extends Feature<RoadFeatureConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect/RoadFeature");
    private static final BuoyDecoration BUOY = new BuoyDecoration();
    private static final int BUOY_INTERVAL = 18;
    private static final int[][] OFFSETS_8 = new int[][]{{-1, -1}, {0, -1}, {1, -1}, {-1, 0}, {1, 0}, {-1, 1}, {0, 1}, {1, 1}};

    public RoadFeature(Codec<RoadFeatureConfig> codec) {
        super(codec);
    }

    private static void buildRoadStripe(WorldGenLevel world, List<BlockPos> pts, int halfWidth, RandomSource random) {
        for (int i = 0; i < pts.size(); ++i) {
            BlockPos p = pts.get(i);
            if (!RoadFeature.isNotWaterBlock(world, p)) continue;
            int prevIdx = Math.max(0, i - 2);
            int nextIdx = Math.min(pts.size() - 1, i + 2);
            Vec3 dir = new Vec3((double)(pts.get(nextIdx).getX() - pts.get(prevIdx).getX()), 0.0, (double)(pts.get(nextIdx).getZ() - pts.get(prevIdx).getZ())).normalize();
            double nx = dir.x;
            double nz = dir.z;
            boolean diagonal = Math.abs(nx) > 0.001 && Math.abs(nz) > 0.001;
            for (int dx = -halfWidth; dx <= halfWidth; ++dx) {
                for (int dz = -halfWidth; dz <= halfWidth; ++dz) {
                    boolean inside;
                    double dist = Math.abs((double)dx * nz - (double)dz * nx);
                    boolean bl = inside = dist <= (double)halfWidth + 0.01 || diagonal && Math.max(Math.abs(dx), Math.abs(dz)) <= halfWidth;
                    if (!inside) continue;
                    BlockPos roadPos = p.offset(dx, 0, dz);
                    if (!RoadFeature.isNotWaterBlock(world, p) || RoadFeature.isWaterSegment(world, roadPos)) continue;
                    Holder biome = world.getBiome(roadPos);
                    RoadStyle style = RoadStyles.forBiome((Holder<Biome>)biome);
                    BlockState roadState = style.palette().pick(random);
                    RoadFeature.placeRoad(world, roadPos, roadState);
                }
            }
            if (random.nextInt(15) != 0) continue;
            RoadFeature.decorateSide(world, p, nx, nz, halfWidth, random);
        }
    }

    private static void decorateSide(WorldGenLevel world, BlockPos center, double nx, double nz, int halfWidth, RandomSource random) {
        int side = random.nextBoolean() ? 1 : -1;
        int sx = (int)Math.round(-nz * (double)side);
        int sz = (int)Math.round(nx * (double)side);
        int fx = (int)Math.round(nx);
        int fz = (int)Math.round(nz);
        Holder biome = world.getBiome(center);
        RoadStyle style = RoadStyles.forBiome((Holder<Biome>)biome);
        int length = 1 + random.nextInt(3);
        Decoration deco = style.decoration();
        if (deco instanceof FenceDecoration) {
            FenceDecoration fence = (FenceDecoration)deco;
            ArrayList<BlockPos> stripe = new ArrayList<BlockPos>();
            for (int j = 0; j < length; ++j) {
                stripe.add(center.offset(sx * (halfWidth + 1) + fx * j, 0, sz * (halfWidth + 1) + fz * j));
            }
            fence.placeFenceStripe(world, stripe);
        } else {
            for (int j = 0; j < length; ++j) {
                deco.place(world, center.offset(sx * (halfWidth + 1) + fx * j, 0, sz * (halfWidth + 1) + fz * j), random);
            }
        }
    }

    private static void placeRoad(WorldGenLevel world, BlockPos pos, BlockState stateRoad) {
        world.setBlock(pos, stateRoad, 1);
    }

    private static boolean isWaterSegment(WorldGenLevel world, BlockPos pos) {
        if (RoadFeature.isNotWaterBlock(world, pos)) {
            return false;
        }
        for (int[] d : OFFSETS_8) {
            BlockPos neighbor = pos.offset(d[0], 0, d[1]);
            if (!RoadFeature.isNotWaterBlock(world, neighbor)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNotWaterBlock(WorldGenLevel world, BlockPos pos) {
        return !world.getBlockState(pos).getFluidState().is(FluidTags.WATER);
    }

    public boolean place(FeaturePlaceContext<RoadFeatureConfig> ctx) {
        ServerLevel serverWorld = ctx.level().getLevel();
        if (serverWorld == null) {
            return false;
        }
        WorldGenLevel world = ctx.level();
        ChunkPos chunk = new ChunkPos(ctx.origin());
        RoadBuilderStorage builder = RoadBuilderStorage.get(serverWorld);
        PathStorage paths = PathStorage.get(serverWorld);
        ArrayList<RoadBuilderStorage.SegmentEntry> queue = new ArrayList<RoadBuilderStorage.SegmentEntry>(builder.getSegments(chunk));
        if (queue.isEmpty()) {
            return false;
        }
        int halfWidth = Math.max(0, ((RoadFeatureConfig)ctx.config()).orthWidth() / 2);
        RandomSource random = world.getRandom();
        boolean placedAny = false;
        for (RoadBuilderStorage.SegmentEntry entry : queue) {
            String[] ids = entry.pathKey().split("\\|", 2);
            if (ids.length != 2) {
                LOGGER.warn("Malformed path key '{}'; skipping", (Object)entry.pathKey());
                builder.removeSegment(chunk, entry);
                continue;
            }
            List<BlockPos> pts = paths.getPath(ids[0], ids[1]);
            if (pts.isEmpty()) {
                builder.removeSegment(chunk, entry);
                continue;
            }
            int from = Math.max(0, entry.start());
            int to = Math.min(pts.size(), entry.end());
            ArrayList<BlockPos> landPts = new ArrayList<BlockPos>();
            BlockPos lastBuoyPos = null;
            for (int i = from; i < to; ++i) {
                BlockPos p = pts.get(i);
                if (RoadFeature.isNotWaterBlock(world, p)) {
                    lastBuoyPos = null;
                    landPts.add(p);
                    continue;
                }
                if (!RoadFeature.isWaterSegment(world, p)) continue;
                boolean farEnough = false;
                if (lastBuoyPos == null) {
                    farEnough = true;
                } else {
                    long dz;
                    long dx = p.getX() - lastBuoyPos.getX();
                    long dist2 = dx * dx + (dz = (long)(p.getZ() - lastBuoyPos.getZ())) * dz;
                    boolean bl = farEnough = dist2 >= 324L;
                }
                if (!farEnough) continue;
                BUOY.place(world, p, random);
                lastBuoyPos = p;
            }
            RoadFeature.buildRoadStripe(world, landPts, halfWidth, random);
            builder.removeSegment(chunk, entry);
            placedAny = true;
        }
        return placedAny;
    }
}

