/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.worldgen;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.oxcodsnet.roadarchitect.worldgen.RoadFeature;
import net.oxcodsnet.roadarchitect.worldgen.RoadFeatureConfig;

public final class RoadFeatureRegistry {
    public static final RoadFeature ROAD_FEATURE = new RoadFeature(RoadFeatureConfig.CODEC);
    public static final ResourceKey<Feature<?>> ROAD_FEATURE_KEY = ResourceKey.create((ResourceKey)Registries.FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"roadarchitect", (String)"road"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> ROAD_CONFIGURED_FEATURE_KEY = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"roadarchitect", (String)"road"));
    public static final ResourceKey<PlacedFeature> ROAD_PLACED_FEATURE_KEY = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"roadarchitect", (String)"road"));

    private RoadFeatureRegistry() {
    }

    public static void bootstrapConfigured(BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
        ctx.register(ROAD_CONFIGURED_FEATURE_KEY, (Object)new ConfiguredFeature((Feature)ROAD_FEATURE, (FeatureConfiguration)new RoadFeatureConfig(3, 1)));
    }

    public static void bootstrapPlaced(BootstrapContext<PlacedFeature> ctx) {
        HolderGetter lookup = ctx.lookup(Registries.CONFIGURED_FEATURE);
        ctx.register(ROAD_PLACED_FEATURE_KEY, (Object)new PlacedFeature((Holder)lookup.getOrThrow(ROAD_CONFIGURED_FEATURE_KEY), List.of(InSquarePlacement.spread())));
    }
}

