/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import net.minecraft.class_1959;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.oxcodsnet.roadarchitect.storage.ColumnRecord;
import net.oxcodsnet.roadarchitect.storage.DimensionPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RegionColumnStore {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RoadArchitect/RegionColumnStore");
    private static final String LIST_KEY = "columns";
    private static final String VERSION_KEY = "version";
    private static final int FORMAT_VERSION = 1;
    private final Path regionDir;
    private final class_7225.class_7226<class_1959> biomeRegistry;
    private final boolean persistHeights;
    private final boolean persistStabilities;
    private final boolean persistBiomes;
    private final int regionSizeChunks;
    private final Cache<Long, RegionData> regions;
    private final long budgetBytes;

    RegionColumnStore(class_3218 world, boolean persistHeights, boolean persistStabilities, boolean persistBiomes, int regionSizeChunks, long persistedBudgetBytes) {
        this.regionDir = DimensionPaths.resolveCacheDirectory(world);
        this.biomeRegistry = world.method_30349().method_30530(class_7924.field_41236);
        this.persistHeights = persistHeights;
        this.persistStabilities = persistStabilities;
        this.persistBiomes = persistBiomes;
        this.regionSizeChunks = Math.max(4, regionSizeChunks);
        long maxWeight = this.budgetBytes = Math.max(persistedBudgetBytes, 0x2000000L);
        this.regions = Caffeine.newBuilder().maximumWeight(maxWeight).weigher((key, value) -> value.weightBytes()).removalListener(this::onRegionRemoval).build();
    }

    ColumnRecord read(long columnKey) {
        RegionData region = (RegionData)this.regions.get((Object)this.regionKey(columnKey), this::loadRegion);
        return region.get(columnKey);
    }

    void write(long columnKey, ColumnRecord record) {
        long regionKey = this.regionKey(columnKey);
        RegionData region = (RegionData)this.regions.get((Object)regionKey, this::loadRegion);
        ColumnRecord persisted = this.filterPersisted(record);
        region.put(columnKey, persisted);
    }

    void flush() {
        this.regions.asMap().forEach(this::flushRegion);
    }

    long weightBytes() {
        return this.regions.policy().eviction().map(eviction -> eviction.weightedSize().orElse(0L)).orElseGet(() -> Math.max(1L, this.regions.estimatedSize()) * 512L);
    }

    private void onRegionRemoval(Long key, RegionData value, RemovalCause cause) {
        if (key == null || value == null) {
            return;
        }
        this.flushRegion(key, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RegionData loadRegion(long regionKey) {
        Path path = this.regionPath(regionKey);
        RegionData data = new RegionData();
        if (!Files.exists(path, new LinkOption[0])) {
            return data;
        }
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            class_2487 tag = class_2507.method_10629((InputStream)in, (class_2505)class_2505.method_53898());
            if (tag == null) {
                RegionData regionData = data;
                return regionData;
            }
            class_2499 list = tag.method_10554(LIST_KEY, 10);
            for (int i = 0; i < list.size(); ++i) {
                ColumnRecord record;
                class_2960 id;
                class_2487 entry = list.method_10602(i);
                long columnKey = entry.method_10537("k");
                Integer height = this.persistHeights && entry.method_10573("h", 3) ? Integer.valueOf(entry.method_10550("h")) : null;
                Double stability = this.persistStabilities && entry.method_10573("s", 6) ? Double.valueOf(entry.method_10574("s")) : null;
                class_6880 biome = null;
                if (this.persistBiomes && entry.method_10573("b", 8) && (id = class_2960.method_12829((String)entry.method_10558("b"))) != null) {
                    class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)id);
                    biome = this.biomeRegistry.method_46746(key).orElse(null);
                }
                if ((record = new ColumnRecord(height, stability, biome)).isEmpty()) continue;
                data.putLoaded(columnKey, record);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load cached region {}", (Object)path, (Object)e);
        }
        data.markClean();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushRegion(long regionKey, RegionData region) {
        Long2ObjectMap<ColumnRecord> snapshot = region.snapshotIfDirty();
        if (snapshot == null) {
            return;
        }
        Path path = this.regionPath(regionKey);
        if (snapshot.isEmpty()) {
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to delete empty cache region {}", (Object)path, (Object)e);
            }
            finally {
                region.markClean();
            }
            return;
        }
        class_2487 root = new class_2487();
        root.method_10569(VERSION_KEY, 1);
        class_2499 list = new class_2499();
        for (Long2ObjectMap.Entry entry : snapshot.long2ObjectEntrySet()) {
            ColumnRecord record = (ColumnRecord)entry.getValue();
            if (record == null || record.isEmpty()) continue;
            class_2487 columnTag = new class_2487();
            columnTag.method_10544("k", entry.getLongKey());
            if (this.persistHeights && record.hasHeight()) {
                columnTag.method_10569("h", record.height().intValue());
            }
            if (this.persistStabilities && record.hasStability()) {
                columnTag.method_10549("s", record.stability().doubleValue());
            }
            if (this.persistBiomes && record.hasBiome()) {
                record.biome().method_40230().map(class_5321::method_29177).ifPresent(id -> columnTag.method_10582("b", id.toString()));
            }
            list.add((Object)columnTag);
        }
        root.method_10566(LIST_KEY, (class_2520)list);
        Path tmp = path.resolveSibling(path.getFileName().toString() + ".tmp");
        try (OutputStream out = Files.newOutputStream(tmp, new OpenOption[0]);){
            class_2507.method_10634((class_2487)root, (OutputStream)out);
            Files.move(tmp, path, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write cache region {}", (Object)path, (Object)e);
            try {
                Files.deleteIfExists(tmp);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        region.markClean();
    }

    private ColumnRecord filterPersisted(ColumnRecord record) {
        class_6880<class_1959> biome;
        if (record == null || record.isEmpty()) {
            return ColumnRecord.EMPTY;
        }
        Integer height = this.persistHeights && record.hasHeight() ? record.height() : null;
        Double stability = this.persistStabilities && record.hasStability() ? record.stability() : null;
        class_6880<class_1959> class_68802 = biome = this.persistBiomes && record.hasBiome() ? record.biome() : null;
        if (Objects.equals(height, record.height()) && Objects.equals(stability, record.stability()) && Objects.equals(biome, record.biome())) {
            return record;
        }
        return new ColumnRecord(height, stability, biome);
    }

    private long regionKey(long columnKey) {
        int blockX = (int)(columnKey >> 32);
        int blockZ = (int)columnKey;
        int chunkX = Math.floorDiv(blockX, 16);
        int chunkZ = Math.floorDiv(blockZ, 16);
        int regionX = Math.floorDiv(chunkX, this.regionSizeChunks);
        int regionZ = Math.floorDiv(chunkZ, this.regionSizeChunks);
        return (long)regionX << 32 | (long)regionZ & 0xFFFFFFFFL;
    }

    private Path regionPath(long regionKey) {
        int regionX = (int)(regionKey >> 32);
        int regionZ = (int)regionKey;
        String fileName = "region_" + regionX + "_" + regionZ + ".nbt";
        return this.regionDir.resolve(fileName);
    }

    private static final class RegionData {
        private final Long2ObjectMap<ColumnRecord> columns = new Long2ObjectOpenHashMap();
        private boolean dirty;

        private RegionData() {
        }

        synchronized ColumnRecord get(long key) {
            return (ColumnRecord)this.columns.get(key);
        }

        synchronized void put(long key, ColumnRecord record) {
            if (record == null || record.isEmpty()) {
                if (this.columns.remove(key) != null) {
                    this.dirty = true;
                }
                return;
            }
            ColumnRecord previous = (ColumnRecord)this.columns.put(key, (Object)record);
            if (!record.equals(previous)) {
                this.dirty = true;
            }
        }

        synchronized void putLoaded(long key, ColumnRecord record) {
            if (record == null || record.isEmpty()) {
                return;
            }
            this.columns.put(key, (Object)record);
        }

        synchronized void markClean() {
            this.dirty = false;
        }

        synchronized Long2ObjectMap<ColumnRecord> snapshotIfDirty() {
            if (!this.dirty) {
                return null;
            }
            return new Long2ObjectOpenHashMap(this.columns);
        }

        synchronized int weightBytes() {
            return Math.max(1, this.columns.size()) * 64;
        }
    }
}

