/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.util.cache;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3754;
import net.minecraft.class_5284;
import net.minecraft.class_5309;
import net.minecraft.class_5539;
import net.minecraft.class_6350;
import net.minecraft.class_6568;
import net.minecraft.class_6748;
import net.minecraft.class_6910;
import net.minecraft.class_6916;
import net.minecraft.class_7138;
import net.minecraft.class_7243;
import net.oxcodsnet.roadarchitect.storage.CacheStorage;
import net.oxcodsnet.roadarchitect.util.cache.ChunkHeightSnapshot;
import net.oxcodsnet.roadarchitect.util.cache.WorldCacheState;
import net.oxcodsnet.roadarchitect.util.profiler.PipelineProfiler;

public final class ChunkHeightGenerator {
    private ChunkHeightGenerator() {
    }

    public static ChunkHeightSnapshot generate(class_3218 world, WorldCacheState state, CacheStorage storage, class_1923 chunkPos, int chunkSide, int columnsPerChunk) {
        int worldZ;
        class_2794 generator = world.method_14178().method_12129();
        if (!(generator instanceof class_3754)) {
            return null;
        }
        class_3754 noiseGenerator = (class_3754)generator;
        class_7138 noiseConfig = world.method_14178().method_41248();
        class_5284 settings = (class_5284)noiseGenerator.method_41541().comp_349();
        class_5309 shape = settings.comp_474().method_42368((class_5539)world);
        int horizontalBlockSize = shape.method_39546();
        int verticalBlockSize = shape.method_39545();
        if (horizontalBlockSize <= 0 || verticalBlockSize <= 0) {
            return null;
        }
        int horizontalCellCount = Math.max(1, chunkSide / horizontalBlockSize);
        int verticalCellCount = class_3532.method_48116((int)shape.comp_174(), (int)verticalBlockSize);
        if (verticalCellCount <= 0) {
            return null;
        }
        int[] heights = new int[columnsPerChunk];
        Arrays.fill(heights, state.minWorldY());
        boolean[] resolved = new boolean[columnsPerChunk];
        int remaining = columnsPerChunk;
        Predicate predicate = class_2902.class_2903.field_13194.method_16402();
        class_2680 defaultBlock = settings.comp_475();
        int startX = chunkPos.method_8326();
        int startZ = chunkPos.method_8328();
        int minCellY = class_3532.method_48116((int)shape.comp_173(), (int)verticalBlockSize);
        AccessibleChunkNoiseSampler sampler = new AccessibleChunkNoiseSampler(horizontalCellCount, noiseConfig, startX, startZ, shape, ChunkHeightGenerator.noBeard(), settings, ChunkHeightGenerator.createFluidSampler(settings), class_6748.method_39336());
        sampler.method_38336();
        long startNanos = System.nanoTime();
        block5: for (int cellX = 0; cellX < horizontalCellCount; ++cellX) {
            sampler.method_38339(cellX);
            for (int cellZ = 0; cellZ < horizontalCellCount; ++cellZ) {
                for (int cellY = verticalCellCount - 1; cellY >= 0; --cellY) {
                    sampler.method_38362(cellY, cellZ);
                    for (int voxelY = verticalBlockSize - 1; voxelY >= 0; --voxelY) {
                        int absoluteY = (minCellY + cellY) * verticalBlockSize + voxelY;
                        double fracY = (double)voxelY / (double)verticalBlockSize;
                        sampler.method_38337(absoluteY, fracY);
                        for (int voxelX = horizontalBlockSize - 1; voxelX >= 0; --voxelX) {
                            int globalX = startX + cellX * horizontalBlockSize + voxelX;
                            double fracX = (double)voxelX / (double)horizontalBlockSize;
                            sampler.method_38349(globalX, fracX);
                            for (int voxelZ = horizontalBlockSize - 1; voxelZ >= 0; --voxelZ) {
                                int globalZ = startZ + cellZ * horizontalBlockSize + voxelZ;
                                double fracZ = (double)voxelZ / (double)horizontalBlockSize;
                                sampler.method_38355(globalZ, fracZ);
                                int localX = globalX & chunkSide - 1;
                                int localZ = globalZ & chunkSide - 1;
                                int index = localZ * chunkSide + localX;
                                class_2680 stateAtPos = sampler.sampleBlockStateDirect();
                                if (resolved[index]) continue;
                                if (stateAtPos == null) {
                                    stateAtPos = defaultBlock;
                                }
                                if (!predicate.test(stateAtPos)) continue;
                                heights[index] = absoluteY + 1;
                                resolved[index] = true;
                                if (--remaining == 0) break block5;
                            }
                        }
                    }
                }
            }
        }
        sampler.method_40537();
        int noiseColumns = columnsPerChunk - remaining;
        long noiseDuration = System.nanoTime() - startNanos;
        ChunkHeightGenerator.recordLoadDurationPerColumn(noiseDuration, noiseColumns);
        if (noiseColumns > 0) {
            PipelineProfiler.increment("cache.height.loads", noiseColumns);
        }
        if (remaining > 0) {
            for (int index = 0; index < columnsPerChunk; ++index) {
                if (resolved[index]) continue;
                int localX = index % chunkSide;
                int localZ = index / chunkSide;
                int worldX = startX + localX;
                worldZ = startZ + localZ;
                PipelineProfiler.increment("cache.height.loads");
                try (PipelineProfiler.Section section = PipelineProfiler.openSection("cache.height.load_time");){
                    int value;
                    heights[index] = value = generator.method_16397(worldX, worldZ, class_2902.class_2903.field_13194, (class_5539)world, noiseConfig);
                    continue;
                }
            }
        }
        for (int value : heights) {
            PipelineProfiler.recordValue("cache.height.loaded_value", value);
        }
        int writeIndex = 0;
        for (int localZ = 0; localZ < chunkSide; ++localZ) {
            int localX = 0;
            while (localX < chunkSide) {
                int worldX = startX + localX;
                worldZ = startZ + localZ;
                long columnKey = ChunkHeightGenerator.hash(worldX, worldZ);
                int value = heights[writeIndex];
                storage.putHeight(columnKey, value);
                ++localX;
                ++writeIndex;
            }
        }
        return new ChunkHeightSnapshot(heights, chunkSide);
    }

    private static class_6350.class_6565 createFluidSampler(class_5284 settings) {
        class_6350.class_6351 lava = new class_6350.class_6351(-54, class_2246.field_10164.method_9564());
        int seaLevel = settings.comp_479();
        class_6350.class_6351 sea = new class_6350.class_6351(seaLevel, settings.comp_476());
        int cutoff = Math.min(-54, seaLevel);
        return (x, y, z) -> y < cutoff ? lava : sea;
    }

    private static void recordLoadDurationPerColumn(long totalNanos, int columns) {
        if (columns <= 0 || totalNanos <= 0L) {
            return;
        }
        long base = totalNanos / (long)columns;
        long remainder = totalNanos % (long)columns;
        for (int i = 0; i < columns; ++i) {
            long sample = base + ((long)i < remainder ? 1L : 0L);
            PipelineProfiler.recordDuration("cache.height.load_time", sample);
        }
    }

    private static class_6916.class_7050 noBeard() {
        return LazyBeardifyingHolder.INSTANCE;
    }

    private static long hash(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    private static final class AccessibleChunkNoiseSampler
    extends class_6568 {
        AccessibleChunkNoiseSampler(int horizontalCellCount, class_7138 noiseConfig, int startBlockX, int startBlockZ, class_5309 generationShapeConfig, class_6916.class_7050 beardifying, class_5284 chunkGeneratorSettings, class_6350.class_6565 fluidLevelSampler, class_6748 blender) {
            super(horizontalCellCount, noiseConfig, startBlockX, startBlockZ, generationShapeConfig, beardifying, chunkGeneratorSettings, fluidLevelSampler, blender);
        }

        class_2680 sampleBlockStateDirect() {
            return super.method_40536();
        }
    }

    private static final class LazyBeardifyingHolder {
        private static final class_6916.class_7050 INSTANCE = new class_6916.class_7050(){

            public double method_40464(class_6910.class_6912 pos) {
                return 0.0;
            }

            public void method_40470(double[] densities, class_6910.class_6911 applier) {
                Arrays.fill(densities, 0.0);
            }

            public double comp_377() {
                return 0.0;
            }

            public double comp_378() {
                return 0.0;
            }

            public class_7243<? extends class_6910> method_41062() {
                return class_7243.method_42116((MapCodec)MapCodec.unit((Object)class_6916.method_40480((double)0.0)));
            }
        };

        private LazyBeardifyingHolder() {
        }
    }
}

