/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.worldgen;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.storage.PathDecorStorage;
import net.oxcodsnet.roadarchitect.storage.PathStorage;
import net.oxcodsnet.roadarchitect.storage.RoadBuilderStorage;
import net.oxcodsnet.roadarchitect.util.PathDecorUtil;
import net.oxcodsnet.roadarchitect.worldgen.RoadFeatureConfig;
import net.oxcodsnet.roadarchitect.worldgen.style.RoadStyle;
import net.oxcodsnet.roadarchitect.worldgen.style.RoadStyles;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.BuoyDecoration;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.Decoration;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.FenceDecoration;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.LampPostConfigResolver;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.LampPostDecoration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoadFeature
extends class_3031<RoadFeatureConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + RoadFeature.class.getSimpleName()));
    private static final BuoyDecoration BUOY = new BuoyDecoration();
    private static final class_2680 PREPARATION_BLOCK = class_2246.field_9987.method_9564();
    private static final int PREPARATION_CLEARANCE_EXTRA = 2;
    private static final Map<Long, PreparationEntry> PREPARATION_BACKUP = new ConcurrentHashMap<Long, PreparationEntry>();
    private static final Map<Long, ColumnSnapshot> PREPARATION_COLUMNS = new ConcurrentHashMap<Long, ColumnSnapshot>();
    private static final double PIXEL_PADDING = Math.sqrt(0.5);

    public RoadFeature(Codec<RoadFeatureConfig> codec) {
        super(codec);
    }

    private static void buildRoadStripe(class_5281 world, List<class_2338> pts, int halfWidth, class_5819 random, RoadFeatureConfig.GenerationPhase phase) {
        boolean finalizePhase = phase == RoadFeatureConfig.GenerationPhase.FINALIZE;
        int clearanceHalfWidth = halfWidth + 2;
        class_2378 biomeRegistry = finalizePhase ? world.method_30349().method_30530(class_7924.field_41236) : null;
        for (int i = 0; i < pts.size(); ++i) {
            class_2338 p = pts.get(i);
            int prevIdx = Math.max(0, i - 2);
            int nextIdx = Math.min(pts.size() - 1, i + 2);
            class_243 prevPoint = class_243.method_24953((class_2382)((class_2382)pts.get(prevIdx)));
            class_243 nextPoint = class_243.method_24953((class_2382)((class_2382)pts.get(nextIdx)));
            double segDx = nextPoint.field_1352 - prevPoint.field_1352;
            double segDz = nextPoint.field_1350 - prevPoint.field_1350;
            double segmentLengthSq = segDx * segDx + segDz * segDz;
            if (segmentLengthSq < 1.0E-6) {
                segmentLengthSq = 1.0;
                segDx = 1.0;
                segDz = 0.0;
            }
            double invLen = 1.0 / Math.sqrt(segmentLengthSq);
            class_243 dir = new class_243(segDx * invLen, 0.0, segDz * invLen);
            double nx = dir.field_1352;
            double nz = dir.field_1350;
            for (int dx = -clearanceHalfWidth; dx <= clearanceHalfWidth; ++dx) {
                for (int dz = -clearanceHalfWidth; dz <= clearanceHalfWidth; ++dz) {
                    boolean insideClearance;
                    class_2338 roadPos = p.method_10069(dx, 0, dz);
                    class_243 cellCenter = class_243.method_24953((class_2382)roadPos);
                    double dist = RoadFeature.horizontalDistanceToSegment(cellCenter, prevPoint, segDx, segDz, segmentLengthSq);
                    boolean insideRoad = dist <= (double)halfWidth + PIXEL_PADDING;
                    boolean bl = insideClearance = dist <= (double)clearanceHalfWidth + PIXEL_PADDING;
                    if (!insideClearance) continue;
                    long packedPos = roadPos.method_10063();
                    if (!finalizePhase) {
                        if (!RoadFeature.isNotWaterBlock(world, roadPos)) continue;
                        if (insideRoad) {
                            RoadFeature.prepareCell(world, roadPos, PreparationRole.ROAD);
                            class_2338 topPos = roadPos.method_10084();
                            RoadFeature.prepareCell(world, topPos, PreparationRole.CAP);
                            continue;
                        }
                        RoadFeature.prepareCell(world, roadPos, PreparationRole.CLEARANCE);
                        continue;
                    }
                    if (insideRoad) {
                        class_2338 topPos;
                        long packedTop;
                        PreparationEntry topEntry;
                        if (!RoadFeature.isNotWaterBlock(world, roadPos)) continue;
                        class_6880 biome = world.method_23753(roadPos);
                        RoadStyle style = RoadStyles.forBiome((class_2378<class_1959>)biomeRegistry, (class_6880<class_1959>)biome);
                        class_2680 roadState = style.palette().pick(random);
                        RoadFeature.placeRoad(world, roadPos, roadState);
                        PreparationEntry groundEntry = PREPARATION_BACKUP.remove(packedPos);
                        if (groundEntry != null) {
                            RoadFeature.releaseColumn(roadPos);
                        }
                        if ((topEntry = PREPARATION_BACKUP.remove(packedTop = (topPos = roadPos.method_10084()).method_10063())) != null) {
                            RoadFeature.restoreFromEntry(world, topPos, topEntry);
                            continue;
                        }
                        if (!world.method_8320(topPos).method_27852(PREPARATION_BLOCK.method_26204())) continue;
                        world.method_8650(topPos, false);
                        continue;
                    }
                    PreparationEntry entry = PREPARATION_BACKUP.remove(packedPos);
                    if (entry != null) {
                        RoadFeature.restoreFromEntry(world, roadPos, entry);
                        continue;
                    }
                    if (!world.method_8320(roadPos).method_27852(PREPARATION_BLOCK.method_26204())) continue;
                    world.method_8650(roadPos, false);
                }
            }
            if (!finalizePhase) continue;
            RoadStyle style = RoadStyles.forBiome((class_2378<class_1959>)biomeRegistry, (class_6880<class_1959>)world.method_23753(p));
            for (Decoration deco : style.decorations()) {
                if (deco instanceof LampPostDecoration || RoadArchitect.CONFIG.deterministicDecorations() || random.method_43048(18) != 0 || !RoadFeature.isNotWaterBlock(world, p)) continue;
                RoadFeature.decorateSide(world, p, nx, nz, halfWidth, deco, random);
            }
        }
    }

    private static void decorateSide(class_5281 world, class_2338 center, double nx, double nz, int halfWidth, Decoration deco, class_5819 random) {
        int side = random.method_43056() ? 1 : -1;
        int sx = (int)Math.round(-nz * (double)side);
        int sz = (int)Math.round(nx * (double)side);
        int fx = (int)Math.round(nx);
        int fz = (int)Math.round(nz);
        int length = 1 + random.method_43048(3);
        if (deco instanceof FenceDecoration) {
            FenceDecoration fence = (FenceDecoration)deco;
            ArrayList<class_2338> stripe = new ArrayList<class_2338>();
            for (int j = 0; j < length; ++j) {
                class_2338 dpos = center.method_10069(sx * (halfWidth + 1) + fx * j, 0, sz * (halfWidth + 1) + fz * j);
                if (!RoadFeature.isNotWaterBlock(world, dpos)) continue;
                stripe.add(dpos);
            }
            fence.placeFenceStripe(world, stripe);
        } else {
            for (int j = 0; j < length; ++j) {
                class_2338 dpos = center.method_10069(sx * (halfWidth + 1) + fx * j, 0, sz * (halfWidth + 1) + fz * j);
                if (!RoadFeature.isNotWaterBlock(world, dpos)) continue;
                deco.place(world, dpos, random);
            }
        }
    }

    private static void placeLampDet(class_5281 world, class_2338 center, double nx, double nz, int halfWidth, LampPostDecoration base, boolean leftFirst, class_5819 random) {
        class_2350 secondFacing;
        int sx = (int)Math.round(-nz);
        int sz = (int)Math.round(nx);
        class_2338 leftPos = center.method_10069(sx * (halfWidth + 1), 0, sz * (halfWidth + 1));
        class_2338 rightPos = center.method_10069(-sx * (halfWidth + 1), 0, -sz * (halfWidth + 1));
        class_2350 leftFace = RoadFeature.directionFrom(-sx, -sz);
        class_2350 rightFace = RoadFeature.directionFrom(sx, sz);
        class_2338 firstPos = leftFirst ? leftPos : rightPos;
        class_2350 firstFacing = leftFirst ? leftFace : rightFace;
        class_2338 secondPos = leftFirst ? rightPos : leftPos;
        class_2350 class_23502 = secondFacing = leftFirst ? rightFace : leftFace;
        if (RoadFeature.isNotWaterBlock(world, firstPos) && base.facing(firstFacing).tryPlace(world, firstPos, random)) {
            return;
        }
        if (RoadFeature.isNotWaterBlock(world, secondPos)) {
            base.facing(secondFacing).tryPlace(world, secondPos, random);
        }
    }

    private static void placeSideDet(class_5281 world, class_2338 center, double nx, double nz, int halfWidth, Decoration deco, boolean leftSide, int length, class_5819 detRandom) {
        int sideMul = leftSide ? 1 : -1;
        int sx = (int)Math.round(-nz * (double)sideMul);
        int sz = (int)Math.round(nx * (double)sideMul);
        int fx = (int)Math.round(nx);
        int fz = (int)Math.round(nz);
        if (deco instanceof FenceDecoration) {
            FenceDecoration fence = (FenceDecoration)deco;
            ArrayList<class_2338> stripe = new ArrayList<class_2338>();
            for (int j = 0; j < length; ++j) {
                class_2338 dpos = center.method_10069(sx * (halfWidth + 1) + fx * j, 0, sz * (halfWidth + 1) + fz * j);
                if (!RoadFeature.isNotWaterBlock(world, dpos)) continue;
                stripe.add(dpos);
            }
            if (!stripe.isEmpty()) {
                fence.placeFenceStripe(world, stripe);
            }
        } else {
            for (int j = 0; j < length; ++j) {
                class_2338 dpos = center.method_10069(sx * (halfWidth + 1) + fx * j, 0, sz * (halfWidth + 1) + fz * j);
                if (!RoadFeature.isNotWaterBlock(world, dpos)) continue;
                deco.place(world, dpos, detRandom);
            }
        }
    }

    static class_2350 directionFrom(int dx, int dz) {
        if (dx > 0) {
            return class_2350.field_11034;
        }
        if (dx < 0) {
            return class_2350.field_11039;
        }
        if (dz > 0) {
            return class_2350.field_11035;
        }
        return class_2350.field_11043;
    }

    private static void prepareCell(class_5281 world, class_2338 pos, PreparationRole role) {
        long key = pos.method_10063();
        class_2680 currentState = world.method_8320(pos);
        PREPARATION_BACKUP.compute(key, (k, existing) -> {
            PreparationRole mergedRole;
            boolean first = existing == null;
            class_2680 original = first ? currentState : existing.originalState();
            PreparationRole preparationRole = mergedRole = first ? role : PreparationRole.merge(existing.role(), role);
            if (first) {
                RoadFeature.retainColumn(world, pos, mergedRole, original);
            }
            if (!currentState.method_27852(PREPARATION_BLOCK.method_26204())) {
                world.method_8652(pos, PREPARATION_BLOCK, 1);
            }
            return new PreparationEntry(original, mergedRole);
        });
    }

    private static void restoreFromEntry(class_5281 world, class_2338 pos, PreparationEntry entry) {
        if (entry == null) {
            return;
        }
        class_2680 original = entry.originalState();
        if (original == null || original.method_26215()) {
            world.method_8650(pos, false);
        } else {
            world.method_8652(pos, original, 1);
        }
        RoadFeature.releaseColumn(pos);
    }

    private static void retainColumn(class_5281 world, class_2338 pos, PreparationRole role, class_2680 originalState) {
        long key = RoadFeature.columnKey(pos.method_10263(), pos.method_10260());
        PREPARATION_COLUMNS.compute(key, (k, snapshot) -> {
            int measuredHeight = RoadFeature.measureSurfaceHeight(world, pos, originalState);
            if (snapshot == null) {
                snapshot = new ColumnSnapshot(measuredHeight, 0);
            }
            if (role != PreparationRole.CAP) {
                snapshot.height = Math.max(snapshot.height, measuredHeight);
            }
            ++snapshot.count;
            return snapshot;
        });
    }

    private static void releaseColumn(class_2338 pos) {
        long key = RoadFeature.columnKey(pos.method_10263(), pos.method_10260());
        PREPARATION_COLUMNS.computeIfPresent(key, (k, snapshot) -> {
            --snapshot.count;
            if (snapshot.count <= 0) {
                return null;
            }
            return snapshot;
        });
    }

    private static int measureSurfaceHeight(class_5281 world, class_2338 pos, class_2680 originalState) {
        if (originalState != null && !originalState.method_26215()) {
            return pos.method_10264();
        }
        class_2338.class_2339 mutable = pos.method_25503();
        int bottom = world.method_31607();
        while (mutable.method_10264() >= bottom) {
            class_2680 state = world.method_8320((class_2338)mutable);
            if (!state.method_26215()) {
                return mutable.method_10264();
            }
            mutable.method_10098(class_2350.field_11033);
        }
        return pos.method_10264();
    }

    private static long columnKey(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    public static OptionalInt lookupPreparedSurface(int x, int z) {
        ColumnSnapshot snapshot = PREPARATION_COLUMNS.get(RoadFeature.columnKey(x, z));
        if (snapshot == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(snapshot.height);
    }

    private static double horizontalDistanceToSegment(class_243 point, class_243 start, double segDx, double segDz, double segmentLengthSq) {
        double px = point.field_1352;
        double pz = point.field_1350;
        double ax = start.field_1352;
        double az = start.field_1350;
        if (segmentLengthSq <= 1.0E-6) {
            double dx = px - ax;
            double dz = pz - az;
            return Math.sqrt(dx * dx + dz * dz);
        }
        double t = class_3532.method_15350((double)(((px - ax) * segDx + (pz - az) * segDz) / segmentLengthSq), (double)0.0, (double)1.0);
        double closestX = ax + segDx * t;
        double closestZ = az + segDz * t;
        double dx = px - closestX;
        double dz = pz - closestZ;
        return Math.sqrt(dx * dx + dz * dz);
    }

    private static void placeRoad(class_5281 world, class_2338 pos, class_2680 stateRoad) {
        if (!RoadFeature.isNotWaterBlock(world, pos)) {
            return;
        }
        world.method_8652(pos, stateRoad, 1);
    }

    private static boolean isNotWaterBlock(class_5281 world, class_2338 pos) {
        int cz;
        int cx = pos.method_10263() >> 4;
        if (!world.method_8393(cx, cz = pos.method_10260() >> 4)) {
            return true;
        }
        return !world.method_8320(pos).method_26227().method_15767(class_3486.field_15517);
    }

    private static List<class_2338> collectLandPoints(class_5281 world, List<class_2338> pts, int from, int to) {
        int n = pts.size();
        int extFrom = Math.max(0, from - 1);
        int extTo = Math.min(n, to + 1);
        boolean[] landMask = new boolean[extTo - extFrom];
        for (int i = extFrom; i < extTo; ++i) {
            landMask[i - extFrom] = RoadFeature.isNotWaterBlock(world, pts.get(i));
        }
        ArrayList<class_2338> out = new ArrayList<class_2338>(Math.max(0, to - from));
        for (int i = from; i < to; ++i) {
            boolean rightLand;
            int k = i - extFrom;
            if (!landMask[k]) continue;
            boolean leftLand = k - 1 >= 0 && landMask[k - 1];
            boolean bl = rightLand = k + 1 < landMask.length && landMask[k + 1];
            if (!leftLand || !rightLand) continue;
            out.add(pts.get(i));
        }
        return out;
    }

    public boolean method_13151(class_5821<RoadFeatureConfig> ctx) {
        class_3218 serverWorld = ctx.method_33652().method_8410();
        if (serverWorld == null) {
            return false;
        }
        class_5281 world = ctx.method_33652();
        class_1923 chunk = new class_1923(ctx.method_33655());
        RoadBuilderStorage builder = RoadBuilderStorage.get(serverWorld);
        PathStorage paths = PathStorage.get(serverWorld);
        PathDecorStorage decor = PathDecorStorage.get(serverWorld);
        ArrayList<RoadBuilderStorage.SegmentEntry> queue = new ArrayList<RoadBuilderStorage.SegmentEntry>(builder.getSegments(chunk));
        if (queue.isEmpty()) {
            return false;
        }
        int orthWidth = Math.max(1, RoadArchitect.CONFIG.roadWidth());
        if ((orthWidth & 1) == 0) {
            --orthWidth;
        }
        int halfWidth = Math.max(0, orthWidth / 2);
        class_5819 random = world.method_8409();
        RoadFeatureConfig.GenerationPhase phase = ((RoadFeatureConfig)ctx.method_33656()).phase();
        boolean finalizePhase = phase == RoadFeatureConfig.GenerationPhase.FINALIZE;
        class_2378 biomeRegistry = world.method_30349().method_30530(class_7924.field_41236);
        boolean placedAny = false;
        for (RoadBuilderStorage.SegmentEntry entry : queue) {
            double nz;
            double nx;
            class_243 dir;
            int nextIdx;
            int prevIdx;
            class_2338 p;
            int i;
            byte[] landMask;
            List<PathDecorUtil.Marker> marks;
            String[] ids = entry.pathKey().split("\\|", 2);
            if (ids.length != 2) {
                LOGGER.warn("Malformed path key '{}'; skipping", (Object)entry.pathKey());
                builder.removeSegment(chunk, entry);
                continue;
            }
            List<class_2338> pts = paths.getPath(ids[0], ids[1]);
            if (pts.isEmpty()) {
                builder.removeSegment(chunk, entry);
                continue;
            }
            int from = Math.max(0, entry.start());
            int to = Math.min(pts.size(), entry.end());
            String pathKey = entry.pathKey();
            double[] S = PathDecorUtil.ensurePrefix(decor, pathKey, pts);
            int erosion = Math.max(0, RoadArchitect.CONFIG.maskErosion());
            int buoyInterval = Math.max(0, RoadArchitect.CONFIG.buoyInterval());
            int lampInterval = Math.max(0, RoadArchitect.CONFIG.lampInterval());
            int sideInterval = Math.max(0, RoadArchitect.CONFIG.sideDecorationInterval());
            boolean det = RoadArchitect.CONFIG.deterministicDecorations();
            PathDecorUtil.fillGroundMask(decor, pathKey, world, pts, from, to);
            PathDecorUtil.fillWaterInteriorMask(decor, pathKey, world, pts, from, to);
            if (finalizePhase && det && buoyInterval > 0) {
                int markerPhase = PathDecorUtil.phaseFor(pathKey, buoyInterval);
                List<PathDecorUtil.Marker> marks2 = PathDecorUtil.markersInWindow(S, from, to, buoyInterval, markerPhase);
                byte[] waterMask = decor.getWaterInteriorMask(pathKey);
                for (PathDecorUtil.Marker m : marks2) {
                    int idx = m.index();
                    if (!PathDecorUtil.erodedAccept(waterMask, idx, erosion, (byte)1)) continue;
                    BUOY.place(world, pts.get(idx), random);
                }
            }
            List<class_2338> landPts = RoadFeature.collectLandPoints(world, pts, from, to);
            RoadFeature.buildRoadStripe(world, landPts, halfWidth, random, phase);
            placedAny = true;
            if (!finalizePhase) continue;
            if (det && lampInterval > 0) {
                int markerPhase = PathDecorUtil.phaseFor(pathKey, lampInterval);
                marks = PathDecorUtil.markersInWindow(S, from, to, lampInterval, markerPhase);
                landMask = decor.getGroundMask(pathKey);
                for (PathDecorUtil.Marker m : marks) {
                    i = m.index();
                    p = pts.get(i);
                    if (!PathDecorUtil.erodedAccept(landMask, i, erosion, (byte)1)) continue;
                    prevIdx = Math.max(0, i - 2);
                    nextIdx = Math.min(pts.size() - 1, i + 2);
                    dir = new class_243((double)(pts.get(nextIdx).method_10263() - pts.get(prevIdx).method_10263()), 0.0, (double)(pts.get(nextIdx).method_10260() - pts.get(prevIdx).method_10260())).method_1029();
                    nx = dir.field_1352;
                    nz = dir.field_1350;
                    boolean leftFirst = PathDecorUtil.detBool(pathKey, m.k());
                    class_6880 biomeAtP = world.method_23753(p);
                    LampPostDecoration resolved = LampPostConfigResolver.resolve(world, (class_6880<class_1959>)biomeAtP, null, pathKey, m.k());
                    if (resolved == null) continue;
                    RoadFeature.placeLampDet(world, p, nx, nz, halfWidth, resolved, leftFirst, random);
                }
            }
            if (!det || sideInterval <= 0) continue;
            int markerPhase = PathDecorUtil.phaseFor(pathKey, sideInterval);
            marks = PathDecorUtil.markersInWindow(S, from, to, sideInterval, markerPhase);
            landMask = decor.getGroundMask(pathKey);
            for (PathDecorUtil.Marker m : marks) {
                i = m.index();
                if (!PathDecorUtil.erodedAccept(landMask, i, erosion, (byte)1)) continue;
                p = pts.get(i);
                prevIdx = Math.max(0, i - 2);
                nextIdx = Math.min(pts.size() - 1, i + 2);
                dir = new class_243((double)(pts.get(nextIdx).method_10263() - pts.get(prevIdx).method_10263()), 0.0, (double)(pts.get(nextIdx).method_10260() - pts.get(prevIdx).method_10260())).method_1029();
                nx = dir.field_1352;
                nz = dir.field_1350;
                RoadStyle styleAtP = RoadStyles.forBiome((class_2378<class_1959>)biomeRegistry, (class_6880<class_1959>)world.method_23753(p));
                ArrayList<Decoration> sideDecos = new ArrayList<Decoration>();
                for (Decoration d : styleAtP.decorations()) {
                    if (d instanceof LampPostDecoration) continue;
                    sideDecos.add(d);
                }
                if (sideDecos.isEmpty()) continue;
                int choice = PathDecorUtil.detInt(pathKey, m.k(), sideDecos.size());
                Decoration chosen = (Decoration)sideDecos.get(choice);
                boolean leftSide = PathDecorUtil.detBool(pathKey, m.k());
                int length = 1 + PathDecorUtil.detInt(pathKey, m.k() ^ 0x55AA55AAL, 3);
                RoadFeature.placeSideDet(world, p, nx, nz, halfWidth, chosen, leftSide, length, class_5819.method_43049((long)(m.k() ^ (long)pathKey.hashCode())));
            }
        }
        return placedAny;
    }

    private static enum PreparationRole {
        CLEARANCE(0),
        ROAD(1),
        CAP(2);

        private final int priority;

        private PreparationRole(int priority) {
            this.priority = priority;
        }

        static PreparationRole merge(PreparationRole a, PreparationRole b) {
            return a.priority >= b.priority ? a : b;
        }
    }

    private record PreparationEntry(class_2680 originalState, PreparationRole role) {
    }

    private static final class ColumnSnapshot {
        int height;
        int count;

        ColumnSnapshot(int height, int count) {
            this.height = height;
            this.count = count;
        }
    }
}

