/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.util.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_3218;
import net.oxcodsnet.roadarchitect.config.records.CacheSettings;
import net.oxcodsnet.roadarchitect.storage.CacheStorage;
import net.oxcodsnet.roadarchitect.util.cache.ChunkHeightSnapshot;

public final class WorldCacheState {
    private final CacheStorage storage;
    private final Cache<Long, ChunkHeightSnapshot> chunkSnapshots;
    private final ConcurrentHashMap<Long, CompletableFuture<ChunkHeightSnapshot>> chunkComputations = new ConcurrentHashMap();
    private final int minWorldY;

    public WorldCacheState(class_3218 world, CacheStorage storage, CacheSettings settings) {
        this.storage = storage;
        this.minWorldY = world.method_31607();
        long maxWeight = Math.max(settings.snapshotBudgetBytes(), 0x1000000L);
        this.chunkSnapshots = Caffeine.newBuilder().maximumWeight(maxWeight).weigher((key, snapshot) -> snapshot == null ? 0 : snapshot.weightBytes()).build();
    }

    public CacheStorage storage() {
        return this.storage;
    }

    public ConcurrentHashMap<Long, CompletableFuture<ChunkHeightSnapshot>> chunkComputations() {
        return this.chunkComputations;
    }

    public int minWorldY() {
        return this.minWorldY;
    }

    public Integer lookupHeight(long key, int chunkSide) {
        int x = (int)(key >> 32);
        int z = (int)key;
        long chunkKey = class_1923.method_8331((int)(x >> 4), (int)(z >> 4));
        ChunkHeightSnapshot snapshot = (ChunkHeightSnapshot)this.chunkSnapshots.getIfPresent((Object)chunkKey);
        if (snapshot == null) {
            return null;
        }
        int mask = chunkSide - 1;
        int localX = x & mask;
        int localZ = z & mask;
        return snapshot.get(localX, localZ);
    }

    public void putChunkSnapshot(long chunkKey, ChunkHeightSnapshot snapshot) {
        if (snapshot == null) {
            return;
        }
        this.chunkSnapshots.put((Object)chunkKey, (Object)snapshot);
    }

    public ChunkHeightSnapshot getChunkSnapshot(long chunkKey) {
        return (ChunkHeightSnapshot)this.chunkSnapshots.getIfPresent((Object)chunkKey);
    }

    public void removeChunkSnapshot(long chunkKey) {
        this.chunkSnapshots.invalidate((Object)chunkKey);
        this.chunkComputations.remove(chunkKey);
    }

    public long snapshotWeightBytes() {
        return this.chunkSnapshots.policy().eviction().map(eviction -> eviction.weightedSize().orElse(0L)).orElse(0L);
    }

    public void flush() {
        this.storage.flush();
        this.chunkSnapshots.invalidateAll();
    }
}

