/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.handlers;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.handlers.PathFinderManager;
import net.oxcodsnet.roadarchitect.handlers.PipelineStage;
import net.oxcodsnet.roadarchitect.handlers.RoadPostProcessor;
import net.oxcodsnet.roadarchitect.handlers.StructureScanManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect/PipelineRunner");
    private static final AtomicBoolean RUNNING = new AtomicBoolean(false);
    private static volatile PipelineStage currentStage = PipelineStage.SCANNING_STRUCTURES;

    private PipelineRunner() {
    }

    public static PipelineStage getCurrentStage() {
        return currentStage;
    }

    private static void setStage(PipelineStage stage) {
        currentStage = stage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void runPipeline(class_3218 world, class_2338 center, PipelineMode mode) {
        if (!RUNNING.compareAndSet(false, true)) {
            return;
        }
        try {
            PipelineRunner.setStage(PipelineStage.INITIALISATION);
            LOGGER.debug("Pipeline start: {}", (Object)mode.reason());
            switch (mode.ordinal()) {
                case 0: {
                    PipelineRunner.setStage(PipelineStage.SCANNING_STRUCTURES);
                    StructureScanManager.scan(world, mode.reason(), center, RoadArchitect.CONFIG.initScanRadius());
                    PipelineRunner.setStage(PipelineStage.PATH_FINDING);
                    PathFinderManager.computePaths(world, 1000);
                    PipelineRunner.setStage(PipelineStage.POST_PROCESSING);
                    RoadPostProcessor.processPending(world);
                    return;
                }
                default: {
                    PipelineRunner.setStage(PipelineStage.SCANNING_STRUCTURES);
                    StructureScanManager.scan(world, mode.reason(), center, RoadArchitect.CONFIG.chunkGenerateScanRadius());
                    PipelineRunner.setStage(PipelineStage.PATH_FINDING);
                    PathFinderManager.computePaths(world, 50, RoadArchitect.CONFIG.maxConnectionDistance() * 5);
                    return;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Pipeline failure", (Throwable)e);
            return;
        }
        finally {
            PipelineRunner.setStage(PipelineStage.COMPLETE);
            RUNNING.set(false);
            LOGGER.debug("Pipeline finished: {}", (Object)mode.reason());
        }
    }

    public static enum PipelineMode {
        INIT("initial_chunk"),
        CHUNK("chunk_structure_trigger"),
        PERIODIC("player_periodic_trigger");

        private final String reason;

        private PipelineMode(String reason) {
            this.reason = reason;
        }

        public String reason() {
            return this.reason;
        }
    }
}

