/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.api.addon;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import net.oxcodsnet.roadarchitect.api.addon.AddonContext;
import net.oxcodsnet.roadarchitect.api.addon.RoadAddon;
import net.oxcodsnet.roadarchitect.api.core.CoreApi;
import net.oxcodsnet.roadarchitect.api.core.CoreApiImpl;
import net.oxcodsnet.roadarchitect.api.storage.AddonPersistentStorage;
import net.oxcodsnet.roadarchitect.api.storage.PersistentStore;
import net.oxcodsnet.roadarchitect.util.DebugLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoadAddons {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect/addons");
    private static final List<RoadAddon> ADDONS = new ArrayList<RoadAddon>();

    private RoadAddons() {
    }

    public static void registerAddon(RoadAddon addon) {
        try {
            ADDONS.add(addon);
            addon.onRegister(new ContextImpl(addon.id()));
            DebugLog.info(LOGGER, "Registered addon {}", addon.id());
        }
        catch (Throwable t) {
            LOGGER.error("Addon registration failed: {}", (Object)addon.id(), (Object)t);
        }
    }

    public static void onPathReady(class_3218 world, String pathKey, List<class_2338> refinedPath) {
        for (RoadAddon addon : ADDONS) {
            try {
                addon.onPathReady(world, pathKey, refinedPath);
            }
            catch (Throwable t) {
                LOGGER.error("Addon {} onPathReady failure", (Object)addon.id(), (Object)t);
            }
        }
    }

    public static void onServerTick(MinecraftServer server) {
        for (RoadAddon addon : ADDONS) {
            try {
                addon.onServerTick(server);
            }
            catch (Throwable t) {
                LOGGER.error("Addon {} onServerTick failure", (Object)addon.id(), (Object)t);
            }
        }
    }

    public static void onChunkLoad(class_3218 world, class_1923 pos) {
        for (RoadAddon addon : ADDONS) {
            try {
                addon.onChunkLoad(world, pos);
            }
            catch (Throwable t) {
                LOGGER.error("Addon {} onChunkLoad failure at {}", new Object[]{addon.id(), pos, t});
            }
        }
    }

    public static void initBuiltins() {
    }

    public static PersistentStore persistent(class_2960 addonId, class_3218 world) {
        AddonPersistentStorage state = AddonPersistentStorage.get(world, addonId);
        return new StoreView(state);
    }

    private record ContextImpl(class_2960 addonId) implements AddonContext
    {
        private static Logger makeLogger(class_2960 id) {
            return LoggerFactory.getLogger((String)("roadarchitect/addons/" + String.valueOf(id)));
        }

        @Override
        public PersistentStore persistent(class_3218 world) {
            return RoadAddons.persistent(this.addonId, world);
        }

        @Override
        public Logger logger() {
            return ContextImpl.makeLogger(this.addonId);
        }

        @Override
        public CoreApi core() {
            return CoreApiImpl.INSTANCE;
        }
    }

    private static final class StoreView
    implements PersistentStore {
        private final AddonPersistentStorage state;

        private StoreView(AddonPersistentStorage state) {
            this.state = state;
        }

        @Override
        public Optional<class_2487> get(class_2960 key) {
            return this.state.get(key);
        }

        @Override
        public void put(class_2960 key, class_2487 value) {
            this.state.put(key, value);
            this.state.method_80();
        }

        @Override
        public void remove(class_2960 key) {
            this.state.remove(key);
            this.state.method_80();
        }

        @Override
        public Set<class_2960> keys() {
            return this.state.keys();
        }
    }
}

