/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.config;

import java.util.ArrayList;
import java.util.List;
import net.oxcodsnet.roadarchitect.config.RoadDecorationType;

public record RoadStyleConfigEntry(List<String> biomeSelectors, List<SurfaceBlockEntry> palette, List<DecorationEntry> decorations) {
    public RoadStyleConfigEntry {
        biomeSelectors = biomeSelectors == null ? List.of() : List.copyOf(biomeSelectors);
        palette = palette == null ? List.of() : RoadStyleConfigEntry.sanitizePalette(palette);
        decorations = decorations == null ? List.of() : RoadStyleConfigEntry.sanitizeDecorations(decorations);
    }

    private static List<SurfaceBlockEntry> sanitizePalette(List<SurfaceBlockEntry> entries) {
        ArrayList<SurfaceBlockEntry> list = new ArrayList<SurfaceBlockEntry>();
        for (SurfaceBlockEntry entry : entries) {
            SurfaceBlockEntry normalized;
            if (entry == null || (normalized = new SurfaceBlockEntry(entry.block(), entry.weight())).block().isBlank() || normalized.weight() <= 0) continue;
            list.add(normalized);
        }
        return List.copyOf(list);
    }

    private static List<DecorationEntry> sanitizeDecorations(List<DecorationEntry> entries) {
        ArrayList<DecorationEntry> list = new ArrayList<DecorationEntry>();
        for (DecorationEntry entry : entries) {
            if (entry == null) continue;
            DecorationEntry normalized = new DecorationEntry(entry.type(), entry.block());
            if (normalized.type() == RoadDecorationType.NONE) {
                list.add(normalized.withBlock(""));
                continue;
            }
            if (normalized.block().isBlank()) continue;
            list.add(normalized);
        }
        return List.copyOf(list);
    }

    public record SurfaceBlockEntry(String block, int weight) {
        public SurfaceBlockEntry {
            block = block == null ? "" : block.trim();
            weight = Math.max(0, weight);
        }
    }

    public record DecorationEntry(RoadDecorationType type, String block) {
        public DecorationEntry {
            type = type == null ? RoadDecorationType.NONE : type;
            block = block == null ? "" : block.trim();
        }

        public DecorationEntry withBlock(String newBlock) {
            return new DecorationEntry(this.type, newBlock);
        }
    }
}

