/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.handlers;

import java.util.List;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.oxcodsnet.roadarchitect.storage.RoadBuilderStorage;
import net.oxcodsnet.roadarchitect.util.DebugLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoadBuilderManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + RoadBuilderManager.class.getSimpleName()));

    static void queueSegments(class_3218 world, Map<String, List<class_2338>> paths) {
        RoadBuilderStorage storage = RoadBuilderStorage.get(world);
        for (Map.Entry<String, List<class_2338>> entry : paths.entrySet()) {
            String key = entry.getKey();
            List<class_2338> path = entry.getValue();
            if (path == null || path.size() < 2) {
                DebugLog.info(LOGGER, "Skipped road construction {} ({} steps) because path too short", key, path == null ? 0 : path.size());
                continue;
            }
            int i = 0;
            while (i < path.size()) {
                class_1923 chunk = new class_1923(path.get(i));
                int start = i;
                while (++i < path.size() && new class_1923(path.get(i)).equals((Object)chunk)) {
                }
                storage.addSegment(chunk, key, start, i);
            }
            DebugLog.info(LOGGER, "Queued road construction {} ({} steps)", key, path.size());
        }
    }
}

