/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.handlers;

import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import net.oxcodsnet.roadarchitect.storage.RoadGraphState;
import net.oxcodsnet.roadarchitect.util.DebugLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoadGraphStateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + RoadGraphStateManager.class.getSimpleName()));

    private RoadGraphStateManager() {
    }

    public static void onWorldLoad(class_3218 world) {
        RoadGraphState.get(world);
        DebugLog.info(LOGGER, "RoadGraphState loaded for world {}", world.method_27983().method_29177());
    }

    public static void onWorldUnload(class_3218 world) {
        RoadGraphState state = RoadGraphState.get(world);
        state.method_80();
        DebugLog.info(LOGGER, "Saved RoadGraphState for world {} on unload", world.method_27983().method_29177());
    }

    public static void onServerStopping(MinecraftServer server) {
        for (class_3218 world : server.method_3738()) {
            RoadGraphState.get(world).method_80();
        }
        DebugLog.info(LOGGER, "Server stopping, all RoadGraphStates marked dirty", new Object[0]);
    }
}

