/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.oxcodsnet.roadarchitect.storage.components.Node;
import net.oxcodsnet.roadarchitect.util.KeyUtil;
import net.oxcodsnet.roadarchitect.util.NbtUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + EdgeStorage.class.getSimpleName()));
    private final double radius;
    private final Map<String, Edge> edges = new ConcurrentHashMap<String, Edge>();

    public EdgeStorage(double radius) {
        this.radius = radius;
    }

    public static EdgeStorage fromNbt(class_2487 tag, double radius) {
        EdgeStorage storage = new EdgeStorage(radius);
        for (String edgeId : tag.method_10541()) {
            class_2487 entry = tag.method_10562(edgeId);
            String a = entry.method_10558("a");
            String b = entry.method_10558("b");
            Status status = NbtUtils.getEnumOrDefault(entry, "status", Status.class, Status.NEW);
            storage.edges.put(edgeId, new Edge(a, b, status));
        }
        return storage;
    }

    public double radius() {
        return this.radius;
    }

    public boolean add(Node a, Node b) {
        if (a.id().equals(b.id())) {
            return false;
        }
        String edgeId = KeyUtil.edgeKey(a.id(), b.id());
        this.edges.put(edgeId, new Edge(a.id(), b.id(), Status.NEW));
        return true;
    }

    public boolean remove(String edgeId) {
        return this.edges.remove(edgeId) != null;
    }

    public Status getStatus(String edgeId) {
        Edge edge = this.edges.get(edgeId);
        return edge == null ? null : edge.status();
    }

    public void setStatus(String edgeId, Status status) {
        Edge old = this.edges.get(edgeId);
        if (old != null) {
            this.edges.put(edgeId, new Edge(old.nodeA(), old.nodeB(), status));
        }
    }

    public Set<String> neighbors(String nodeId) {
        HashSet<String> set = new HashSet<String>();
        for (Edge edge : this.edges.values()) {
            if (!edge.connects(nodeId)) continue;
            set.add(edge.other(nodeId));
        }
        return Collections.unmodifiableSet(set);
    }

    public Map<String, Edge> all() {
        return Collections.unmodifiableMap(new HashMap<String, Edge>(this.edges));
    }

    public Map<String, Status> allWithStatus() {
        HashMap<String, Status> map = new HashMap<String, Status>();
        for (Map.Entry<String, Edge> e : this.edges.entrySet()) {
            map.put(e.getKey(), e.getValue().status());
        }
        return Collections.unmodifiableMap(map);
    }

    public class_2487 toNbt() {
        class_2487 tag = new class_2487();
        for (Edge edge : this.edges.values()) {
            class_2487 entry = new class_2487();
            entry.method_10582("a", edge.nodeA());
            entry.method_10582("b", edge.nodeB());
            entry.method_10582("status", edge.status().name());
            tag.method_10566(edge.id(), (class_2520)entry);
        }
        return tag;
    }

    public void clear() {
        this.edges.clear();
    }

    public static enum Status {
        NEW,
        SUCCESS,
        FAILURE;

    }

    public record Edge(String nodeA, String nodeB, Status status) {
        public String id() {
            return KeyUtil.edgeKey(this.nodeA, this.nodeB);
        }

        public boolean connects(String nodeId) {
            return this.nodeA.equals(nodeId) || this.nodeB.equals(nodeId);
        }

        public String other(String nodeId) {
            return this.nodeA.equals(nodeId) ? this.nodeB : this.nodeA;
        }
    }
}

