/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.client.gui;

import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.oxcodsnet.roadarchitect.client.gui.UiGfx;
import net.oxcodsnet.roadarchitect.storage.EdgeStorage;
import net.oxcodsnet.roadarchitect.storage.components.Node;

@Environment(value=EnvType.CLIENT)
public class GraphComponent
extends BaseComponent {
    private static final int RADIUS_PX = 4;
    private static final int PADDING = 20;
    private static final int TARGET_GRID_PX = 80;
    private final List<Node> nodes;
    private final Collection<EdgeStorage.Edge> edges;
    private final Map<EdgeStorage.Status, Color> statusColors = Map.of(EdgeStorage.Status.NEW, Color.ofRgb((int)15911244), EdgeStorage.Status.SUCCESS, Color.ofRgb((int)2600544), EdgeStorage.Status.FAILURE, Color.ofRgb((int)11408939));
    private final Map<String, Color> typeColors = new HashMap<String, Color>();
    private final Map<String, ScreenPos> screenPositions = new HashMap<String, ScreenPos>();
    private int minX;
    private int maxX;
    private int minZ;
    private int maxZ;
    private double baseScale = 1.0;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double zoom = 1.0;
    private boolean invertPan = false;
    private double dragPrevX = 0.0;
    private double dragPrevY = 0.0;
    private boolean dragging = false;
    private boolean firstLayout = true;

    public GraphComponent(List<Node> nodes, Collection<EdgeStorage.Edge> edges) {
        this.nodes = nodes;
        this.edges = edges;
        this.horizontalSizing(Sizing.fill());
        this.verticalSizing(Sizing.fill());
        if (!nodes.isEmpty()) {
            this.minX = nodes.stream().mapToInt(n -> n.pos().method_10263()).min().orElse(0);
            this.maxX = nodes.stream().mapToInt(n -> n.pos().method_10263()).max().orElse(0);
            this.minZ = nodes.stream().mapToInt(n -> n.pos().method_10260()).min().orElse(0);
            this.maxZ = nodes.stream().mapToInt(n -> n.pos().method_10260()).max().orElse(0);
        }
        for (Node node : nodes) {
            this.typeColors.computeIfAbsent(node.type(), t -> Color.ofHsv((float)((float)Math.abs(t.hashCode() % 360) / 360.0f), (float)0.6f, (float)0.9f));
        }
    }

    public boolean canFocus(Component.FocusSource source) {
        return source == Component.FocusSource.MOUSE_CLICK;
    }

    public void onFocusGained(Component.FocusSource src) {
    }

    public void onFocusLost() {
    }

    protected int determineHorizontalContentSize(Sizing s) {
        return 100;
    }

    protected int determineVerticalContentSize(Sizing s) {
        return 100;
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float delta, float tickDelta) {
        Color col;
        this.computeLayout();
        context.drawPanel(this.x(), this.y(), this.width(), this.height(), true);
        context.drawRectOutline(this.x(), this.y(), this.width(), this.height(), -1);
        this.drawGrid(context);
        for (EdgeStorage.Edge e : this.edges) {
            ScreenPos a = this.screenPositions.get(e.nodeA());
            ScreenPos b = this.screenPositions.get(e.nodeB());
            if (a == null || b == null) continue;
            col = this.statusColors.getOrDefault((Object)e.status(), Color.WHITE);
            context.drawLine(a.x, a.y, b.x, b.y, 1.0, col);
        }
        Node hovered = null;
        for (Node n : this.nodes) {
            ScreenPos p = this.screenPositions.get(n.id());
            if (p == null) continue;
            col = this.typeColors.getOrDefault(n.type(), Color.WHITE);
            UiGfx.drawCircleApprox(context, p.x, p.y, 24, 4.0, 1.5, col);
            UiGfx.drawCircleApprox(context, p.x, p.y, 24, 3.0, 1.0, Color.BLACK);
            if (!(GraphComponent.distance(p.x, p.y, mouseX, mouseY) <= 4.0)) continue;
            hovered = n;
        }
        if (hovered != null) {
            context.method_51438(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)(hovered.pos().method_23854() + " \u2022 " + hovered.type())), mouseX, mouseY);
        }
        this.drawScale(context);
        this.drawLegend(context);
    }

    public boolean onMouseDown(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        if (this.clickOnNode(mouseX, mouseY)) {
            return true;
        }
        this.dragging = true;
        this.dragPrevX = mouseX;
        this.dragPrevY = mouseY;
        return true;
    }

    public boolean onMouseDrag(double mouseX, double mouseY, double _dx, double _dy, int button) {
        if (!this.dragging || button != 0) {
            return false;
        }
        double dx = mouseX - this.dragPrevX;
        double dy = mouseY - this.dragPrevY;
        double sign = this.invertPan ? -1.0 : 1.0;
        this.offsetX += sign * dx;
        this.offsetY += sign * dy;
        this.dragPrevX = mouseX;
        this.dragPrevY = mouseY;
        return true;
    }

    public boolean onMouseUp(double mouseX, double mouseY, int button) {
        if (button == 0 && this.dragging) {
            this.dragging = false;
            return true;
        }
        return false;
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        double oldZoom = this.zoom;
        this.zoom = amount > 0.0 ? this.zoom * 1.1 : this.zoom / 1.1;
        double sOld = this.baseScale * oldZoom;
        double sNew = this.baseScale * this.zoom;
        this.offsetX = (this.offsetX - mouseX + 20.0) * (sNew / sOld) + mouseX - 20.0;
        this.offsetY = (this.offsetY - mouseY + 20.0) * (sNew / sOld) + mouseY - 20.0;
        return true;
    }

    private static double distance(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private void computeLayout() {
        if (this.nodes.isEmpty()) {
            return;
        }
        int w = Math.max(1, this.width() - 40);
        int h = Math.max(1, this.height() - 40);
        double scaleX = (double)w / (double)Math.max(1, this.maxX - this.minX);
        double scaleZ = (double)h / (double)Math.max(1, this.maxZ - this.minZ);
        this.baseScale = Math.min(scaleX, scaleZ);
        if (this.firstLayout) {
            double graphW = (double)(this.maxX - this.minX) * this.baseScale * this.zoom;
            double graphH = (double)(this.maxZ - this.minZ) * this.baseScale * this.zoom;
            this.offsetX = ((double)w - graphW) / 2.0;
            this.offsetY = ((double)h - graphH) / 2.0;
            this.firstLayout = false;
        }
        this.screenPositions.clear();
        double s = this.baseScale * this.zoom;
        for (Node n : this.nodes) {
            int sx = 20 + (int)Math.round((double)(n.pos().method_10263() - this.minX) * s + this.offsetX);
            int sy = 20 + (int)Math.round((double)(n.pos().method_10260() - this.minZ) * s + this.offsetY);
            this.screenPositions.put(n.id(), new ScreenPos(sx, sy));
        }
    }

    private void drawGrid(OwoUIDrawContext ctx) {
        int w = Math.max(1, this.width() - 40);
        int h = Math.max(1, this.height() - 40);
        double s = this.baseScale * this.zoom;
        double worldX0 = (double)this.minX + -this.offsetX / s;
        double worldZ0 = (double)this.minZ + -this.offsetY / s;
        double worldX1 = (double)this.minX + ((double)w - this.offsetX) / s;
        double worldZ1 = (double)this.minZ + ((double)h - this.offsetY) / s;
        int spacing = this.computeGridSpacing();
        int startWX = (int)(Math.floor(worldX0 / (double)spacing) * (double)spacing);
        int startWZ = (int)(Math.floor(worldZ0 / (double)spacing) * (double)spacing);
        int x = startWX;
        while ((double)x <= worldX1 + 1.0) {
            int sx = 20 + (int)Math.round((double)(x - this.minX) * s + this.offsetX);
            ctx.drawLine(sx, 20, sx, 20 + h, 1.0, Color.ofArgb((int)0x60444444));
            UiGfx.drawTextScaled(ctx, (class_2561)class_2561.method_43470((String)Integer.toString(x)), sx + 2, 22.0f, 0.6f, -1);
            x += spacing;
        }
        int z = startWZ;
        while ((double)z <= worldZ1 + 1.0) {
            int sz = 20 + (int)Math.round((double)(z - this.minZ) * s + this.offsetY);
            ctx.drawLine(20, sz, 20 + w, sz, 1.0, Color.ofArgb((int)0x60444444));
            UiGfx.drawTextScaled(ctx, (class_2561)class_2561.method_43470((String)Integer.toString(z)), 22.0f, sz + 2, 0.6f, -1);
            z += spacing;
        }
    }

    private int computeGridSpacing() {
        int[] nice;
        double s = this.baseScale * this.zoom;
        double worldPerTarget = 80.0 / s;
        double pow10 = Math.pow(10.0, Math.floor(Math.log10(worldPerTarget)));
        for (int n : nice = new int[]{1, 2, 5}) {
            double candidate = (double)n * pow10;
            if (!(candidate >= worldPerTarget)) continue;
            return (int)Math.round(candidate);
        }
        return (int)Math.round(10.0 * pow10);
    }

    private void drawScale(OwoUIDrawContext ctx) {
        int spacing = this.computeGridSpacing();
        int lengthPx = (int)Math.round((double)spacing * this.baseScale * this.zoom);
        int x = this.width() - 20 - lengthPx - 10;
        int y = this.height() - 20 - 8;
        ctx.drawLine(x, y, x + lengthPx, y, 2.0, Color.WHITE);
        ctx.drawLine(x, y - 3, x, y + 3, 2.0, Color.WHITE);
        ctx.drawLine(x + lengthPx, y - 3, x + lengthPx, y + 3, 2.0, Color.WHITE);
        UiGfx.drawTextScaled(ctx, (class_2561)class_2561.method_43470((String)(spacing + " m")), x, y - 10, 0.7f, -1);
    }

    private void drawLegend(OwoUIDrawContext ctx) {
        int x = 20;
        int y = this.height() - 20 - this.typeColors.size() * 12;
        for (Map.Entry<String, Color> e : this.typeColors.entrySet()) {
            ctx.method_25294(x, y, x + 8, y + 8, e.getValue().argb());
            ctx.drawRectOutline(x, y, 8, 8, -1);
            UiGfx.drawTextScaled(ctx, (class_2561)class_2561.method_43470((String)e.getKey()), x + 10, y, 0.7f, -1);
            y += 12;
        }
    }

    private boolean clickOnNode(double mouseX, double mouseY) {
        for (Node node : this.nodes) {
            ScreenPos pos = this.screenPositions.get(node.id());
            if (pos == null || !(GraphComponent.distance(pos.x, pos.y, mouseX, mouseY) <= 4.0)) continue;
            class_310 client = class_310.method_1551();
            client.execute(() -> {
                class_3222 sp;
                if (client.method_1576() != null && client.field_1724 != null && (sp = client.method_1576().method_3760().method_14602(client.field_1724.method_5667())) != null) {
                    sp.method_5859((double)node.pos().method_10263() + 0.5, (double)node.pos().method_10264(), (double)node.pos().method_10260() + 0.5);
                }
            });
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    private record ScreenPos(int x, int y) {
    }
}

