/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.client.gui;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.util.CacheManager;
import net.oxcodsnet.roadarchitect.util.DebugLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheDebugOverlayRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect/CacheDebugOverlayRenderer");
    private static final Method SYSTEM_INFO_METHOD;
    private static final int TEXT_COLOR = -30356;
    private static boolean loggedActive;
    private static boolean loggedEmpty;
    private static boolean positionLogged;

    private CacheDebugOverlayRenderer() {
    }

    public static void render(GuiGraphics graphics) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.level == null) {
            return;
        }
        if (!RoadArchitect.CONFIG.debugCacheOverlay()) {
            return;
        }
        if (mc.gui == null || !mc.gui.getDebugOverlay().showDebugScreen()) {
            return;
        }
        List<Component> lines = CacheDebugOverlayRenderer.collectLines(mc);
        if (lines.isEmpty()) {
            CacheDebugOverlayRenderer.logEmpty();
            return;
        }
        CacheDebugOverlayRenderer.logActive(lines.size(), graphics.guiWidth(), graphics.guiHeight());
        int x = graphics.guiWidth() - 4;
        int y = CacheDebugOverlayRenderer.computeRightColumnTop(mc);
        CacheDebugOverlayRenderer.logPosition(x, y);
        for (Component line : lines) {
            int width = mc.font.width((FormattedText)line);
            graphics.drawString(mc.font, line, x - width, y, -30356, false);
            Objects.requireNonNull(mc.font);
            y += 9;
        }
    }

    public static List<Component> collectLines(Minecraft mc) {
        if (mc == null || mc.level == null) {
            return List.of();
        }
        if (!RoadArchitect.CONFIG.debugCacheOverlay()) {
            return List.of();
        }
        if (mc.getSingleplayerServer() == null) {
            return List.of(Component.literal((String)"RoadArchitect cache: remote server"));
        }
        ServerLevel serverLevel = mc.getSingleplayerServer().getLevel(mc.level.dimension());
        if (serverLevel == null) {
            return List.of(Component.literal((String)"RoadArchitect cache: world unavailable"));
        }
        CacheManager.CacheStats stats = CacheManager.stats(serverLevel);
        if (!stats.available()) {
            return List.of(Component.literal((String)"RoadArchitect cache: inactive"));
        }
        ArrayList<Component> lines = new ArrayList<Component>();
        ResourceLocation dimensionId = serverLevel.dimension().location();
        lines.add((Component)Component.literal((String)("RoadArchitect cache (" + String.valueOf(dimensionId) + ")")));
        lines.add((Component)Component.literal((String)("  runtime: " + CacheDebugOverlayRenderer.formatUsage(stats.runtimeUsedBytes(), stats.runtimeBudgetBytes()))));
        lines.add((Component)Component.literal((String)("  snapshots: " + CacheDebugOverlayRenderer.formatUsage(stats.snapshotUsedBytes(), stats.snapshotBudgetBytes()))));
        lines.add((Component)Component.literal((String)("  pages: " + CacheDebugOverlayRenderer.formatUsage(stats.persistedUsedBytes(), stats.persistedBudgetBytes()))));
        lines.add((Component)Component.literal((String)("  prefill: " + (stats.prefillEnabled() ? "ON" : "OFF") + " limit=" + stats.prefillMaxChunks())));
        return lines;
    }

    private static void logEmpty() {
        if (!loggedEmpty && DebugLog.isEnabled()) {
            LOGGER.info("Cache debug overlay skipped: no lines to render (config={}, levelLoaded={})", (Object)RoadArchitect.CONFIG.debugCacheOverlay(), (Object)(Minecraft.getInstance() != null && Minecraft.getInstance().level != null ? 1 : 0));
            loggedEmpty = true;
        }
    }

    private static void logActive(int lineCount, int width, int height) {
        if (!loggedActive && DebugLog.isEnabled()) {
            LOGGER.info("Cache debug overlay rendering {} line(s) at {}x{} surface", new Object[]{lineCount, width, height});
            loggedActive = true;
        }
    }

    private static void logPosition(int x, int y) {
        if (!DebugLog.isEnabled() || !loggedActive || positionLogged) {
            return;
        }
        LOGGER.info("Cache debug overlay start position: x={} y={}", (Object)x, (Object)y);
        positionLogged = true;
    }

    private static int computeRightColumnTop(Minecraft mc) {
        try {
            Objects.requireNonNull(mc.font);
            int lineHeight = 9;
            List<String> existing = CacheDebugOverlayRenderer.getSystemInformation(mc);
            if (!existing.isEmpty()) {
                return 2 + existing.size() * lineHeight + 2;
            }
            return 2;
        }
        catch (Throwable ignored) {
            return 48;
        }
    }

    private static List<String> getSystemInformation(Minecraft mc) throws ReflectiveOperationException {
        if (SYSTEM_INFO_METHOD == null || mc.gui == null) {
            return List.of();
        }
        DebugScreenOverlay overlay = mc.gui.getDebugOverlay();
        return (List)SYSTEM_INFO_METHOD.invoke((Object)overlay, new Object[0]);
    }

    private static String formatUsage(long usedBytes, long budgetBytes) {
        double used = CacheDebugOverlayRenderer.bytesToMiB(usedBytes);
        double budget = CacheDebugOverlayRenderer.bytesToMiB(budgetBytes);
        double pct = budgetBytes > 0L ? (double)usedBytes / (double)budgetBytes * 100.0 : 0.0;
        return String.format(Locale.ROOT, "%.1f / %.1f MiB (%.0f%%)", used, budget, pct);
    }

    private static double bytesToMiB(long value) {
        return (double)value / 1024.0 / 1024.0;
    }

    static {
        Method m = null;
        try {
            m = DebugScreenOverlay.class.getDeclaredMethod("getSystemInformation", new Class[0]);
            m.setAccessible(true);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        SYSTEM_INFO_METHOD = m;
    }
}

