/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.oxcodsnet.roadarchitect.storage.EdgeStorage;
import net.oxcodsnet.roadarchitect.storage.components.Node;

public class RoadGraphDebugScreenVanilla
extends Screen {
    private static final int RADIUS = 4;
    private static final int PADDING = 20;
    private static final int TARGET_GRID_PX = 80;
    private static final int EDGE_CULL_MARGIN = 12;
    private final List<DimensionLayer> layers;
    private final Supplier<Component> titleSupplier;
    private final Map<String, Integer> typeColors = new HashMap<String, Integer>();
    private final Map<EdgeStorage.Status, Integer> statusColors = Map.of(EdgeStorage.Status.NEW, -865972, EdgeStorage.Status.SUCCESS, -14176672, EdgeStorage.Status.FAILURE, -5368277);
    private final Map<ResourceKey<Level>, ViewState> viewStates = new HashMap<ResourceKey<Level>, ViewState>();
    private NodeRenderData[] nodeRenderData = NodeRenderData.EMPTY;
    private EdgeRenderData[] edgeRenderData = EdgeRenderData.EMPTY;
    private List<LegendEntry> legendEntries = List.of();
    private DimensionLayer currentLayer;
    private ResourceKey<Level> lastPlayerDimension;
    private Component dimensionLabel = Component.empty();
    private boolean dragging = false;
    private boolean firstLayout = true;
    private boolean layoutDirty = true;
    private double zoom = 1.0;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double baseScale = 1.0;
    private int minX;
    private int maxX;
    private int minZ;
    private int maxZ;
    private int viewportMinX;
    private int viewportMaxX;
    private int viewportMinY;
    private int viewportMaxY;
    private static final int INSIDE = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int BOTTOM = 4;
    private static final int TOP = 8;

    public RoadGraphDebugScreenVanilla(List<DimensionLayer> layers) {
        this(layers, () -> Component.literal((String)"Road Graph Debug"));
    }

    public RoadGraphDebugScreenVanilla(List<DimensionLayer> layers, Supplier<Component> titleSupplier) {
        super(titleSupplier.get());
        this.layers = List.copyOf(layers);
        this.titleSupplier = titleSupplier;
        for (DimensionLayer layer : this.layers) {
            for (Node node : layer.nodes()) {
                this.typeColors.computeIfAbsent(node.type(), t -> RoadGraphDebugScreenVanilla.hsvToArgb(Math.abs(t.hashCode() % 360), 0.6f, 0.9f));
            }
        }
        if (this.layers.isEmpty()) {
            this.clearActiveLayer();
        }
    }

    protected void init() {
        super.init();
        this.focusOnCurrentDimension();
    }

    public void resize(Minecraft client, int width, int height) {
        this.saveCurrentViewState();
        super.resize(client, width, height);
        this.layoutDirty = true;
        if (this.currentLayer != null) {
            this.loadViewState(this.currentLayer);
        }
    }

    public void render(GuiGraphics ctx, int mouseX, int mouseY, float delta) {
        this.focusOnCurrentDimension();
        this.ensureLayout();
        ctx.fill(20, 20, this.width - 20, this.height - 20, -1609560048);
        ctx.renderOutline(20, 20, this.width - 40, this.height - 40, -1);
        this.drawGrid(ctx);
        this.renderGraphCanvas(ctx);
        NodeRenderData hovered = this.findHovered(mouseX, mouseY);
        if (hovered != null) {
            RoadGraphDebugScreenVanilla.drawCircleOutline(ctx, hovered.screenX, hovered.screenY, 7, -1);
        }
        if (hovered != null) {
            Font font = Minecraft.getInstance().font;
            ctx.setTooltipForNextFrame(font, hovered.tooltip(), mouseX, mouseY);
        }
        this.drawPlayerMarker(ctx);
        this.drawScale(ctx);
        this.drawLegend(ctx);
        this.drawDimensionLabel(ctx);
        this.drawCenteredTitle(ctx);
        super.render(ctx, mouseX, mouseY, delta);
    }

    public void removed() {
        this.saveCurrentViewState();
        super.removed();
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    protected void renderBlurredBackground(GuiGraphics context) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        Node clicked = this.findClickedNode(mouseX, mouseY);
        if (clicked != null) {
            return this.teleportTo(clicked);
        }
        this.dragging = true;
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging && button == 0) {
            this.offsetX += deltaX;
            this.offsetY += deltaY;
            this.firstLayout = false;
            this.layoutDirty = true;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.dragging) {
            this.dragging = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontal, double vertical) {
        double old = this.zoom;
        this.zoom = Mth.clamp((double)(vertical > 0.0 ? this.zoom * 1.1 : this.zoom / 1.1), (double)0.1, (double)10.0);
        this.offsetX = (this.offsetX - mouseX + 20.0) * (this.zoom / old) + mouseX - 20.0;
        this.offsetY = (this.offsetY - mouseY + 20.0) * (this.zoom / old) + mouseY - 20.0;
        this.firstLayout = false;
        this.layoutDirty = true;
        return true;
    }

    private void drawCenteredTitle(GuiGraphics ctx) {
        Font font = Minecraft.getInstance().font;
        Component t = this.titleSupplier.get();
        int tw = font.width((FormattedText)t);
        ctx.drawString(font, t, (this.width - tw) / 2, 8, -1, true);
    }

    private void drawGrid(GuiGraphics ctx) {
        if (this.nodeRenderData.length == 0) {
            return;
        }
        int w = this.width - 40;
        int h = this.height - 40;
        double worldX0 = (double)this.minX + -this.offsetX / (this.baseScale * this.zoom);
        double worldZ0 = (double)this.minZ + -this.offsetY / (this.baseScale * this.zoom);
        double worldX1 = (double)this.minX + ((double)w - this.offsetX) / (this.baseScale * this.zoom);
        double worldZ1 = (double)this.minZ + ((double)h - this.offsetY) / (this.baseScale * this.zoom);
        int spacing = this.computeGridSpacing();
        int startWX = (int)Math.floor(worldX0 / (double)spacing) * spacing;
        int startWZ = (int)Math.floor(worldZ0 / (double)spacing) * spacing;
        int x = startWX;
        while ((double)x <= worldX1) {
            int sx = 20 + (int)(((double)x - worldX0) * this.baseScale * this.zoom);
            RoadGraphDebugScreenVanilla.fillV(ctx, sx, 20, 20 + h, 0x60444444);
            this.drawSmallLabel(ctx, String.valueOf(x), sx + 2, 22);
            x += spacing;
        }
        int z = startWZ;
        while ((double)z <= worldZ1) {
            int sz = 20 + (int)(((double)z - worldZ0) * this.baseScale * this.zoom);
            RoadGraphDebugScreenVanilla.fillH(ctx, 20, 20 + w, sz, 0x60444444);
            this.drawSmallLabel(ctx, String.valueOf(z), 22, sz + 2);
            z += spacing;
        }
    }

    private void drawScale(GuiGraphics ctx) {
        if (this.nodeRenderData.length == 0) {
            return;
        }
        int spacing = this.computeGridSpacing();
        int lengthPx = (int)((double)spacing * this.baseScale * this.zoom);
        int x = this.width - 20 - lengthPx - 10;
        int y = this.height - 20 - 8;
        RoadGraphDebugScreenVanilla.fillH(ctx, x, x + lengthPx, y, -1);
        RoadGraphDebugScreenVanilla.fillV(ctx, x, y - 3, y + 3, -1);
        RoadGraphDebugScreenVanilla.fillV(ctx, x + lengthPx, y - 3, y + 3, -1);
        this.drawSmallLabel(ctx, spacing + "m", x, y - 10);
    }

    private void drawLegend(GuiGraphics ctx) {
        if (this.legendEntries.isEmpty()) {
            return;
        }
        Font font = Minecraft.getInstance().font;
        int x = 20;
        int y = this.height - 20 - this.legendEntries.size() * 12;
        for (LegendEntry entry : this.legendEntries) {
            ctx.fill(x, y, x + 8, y + 8, entry.color());
            ctx.renderOutline(x, y, 8, 8, -1);
            ctx.drawString(font, entry.label(), x + 10, y, -1, true);
            y += 12;
        }
    }

    private void drawDimensionLabel(GuiGraphics ctx) {
        if (this.currentLayer == null) {
            return;
        }
        Font font = Minecraft.getInstance().font;
        ctx.drawString(font, this.dimensionLabel, 24, 24, -5592406, false);
    }

    private void drawPlayerMarker(GuiGraphics ctx) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.player == null || mc.level == null) {
            return;
        }
        if (this.currentLayer == null || !Objects.equals(mc.level.dimension(), this.currentLayer.dimension())) {
            return;
        }
        if (this.nodeRenderData.length == 0) {
            return;
        }
        ScreenPoint p = this.worldToScreen(mc.player.getX(), mc.player.getZ());
        if (p == null) {
            return;
        }
        int r = 6;
        int fill = -1618884;
        int outline = -16777216;
        RoadGraphDebugScreenVanilla.fillCircle(ctx, p.x(), p.y(), 6, -1618884);
        RoadGraphDebugScreenVanilla.drawCircleOutline(ctx, p.x(), p.y(), 6, -16777216);
        float yaw = mc.player.getYRot();
        double a = Math.toRadians(yaw) + 1.5707963267948966;
        int tx = p.x() + (int)Math.round(Math.cos(a) * 9.0);
        int ty = p.y() + (int)Math.round(Math.sin(a) * 9.0);
        RoadGraphDebugScreenVanilla.drawLine(ctx, p.x(), p.y(), tx, ty, -1);
    }

    private void ensureLayout() {
        if (!this.layoutDirty) {
            return;
        }
        if (this.nodeRenderData.length == 0) {
            this.viewportMinX = 20;
            this.viewportMinY = 20;
            this.viewportMaxX = this.width - 20;
            this.viewportMaxY = this.height - 20;
            this.layoutDirty = false;
            return;
        }
        int w = Math.max(1, this.width - 40);
        int h = Math.max(1, this.height - 40);
        double scaleX = (double)w / (double)Math.max(1, this.maxX - this.minX);
        double scaleZ = (double)h / (double)Math.max(1, this.maxZ - this.minZ);
        this.baseScale = Math.min(scaleX, scaleZ);
        if (this.firstLayout) {
            double graphW = (double)(this.maxX - this.minX) * this.baseScale * this.zoom;
            double graphH = (double)(this.maxZ - this.minZ) * this.baseScale * this.zoom;
            this.offsetX = ((double)w - graphW) / 2.0;
            this.offsetY = ((double)h - graphH) / 2.0;
            this.firstLayout = false;
        }
        this.viewportMinX = 20;
        this.viewportMinY = 20;
        this.viewportMaxX = this.width - 20;
        this.viewportMaxY = this.height - 20;
        for (NodeRenderData node : this.nodeRenderData) {
            double sx = (double)(node.node.pos().getX() - this.minX) * this.baseScale * this.zoom + this.offsetX;
            double sy = (double)(node.node.pos().getZ() - this.minZ) * this.baseScale * this.zoom + this.offsetY;
            node.screenX = 20 + (int)Math.round(sx);
            node.screenY = 20 + (int)Math.round(sy);
            node.visible = node.screenX >= this.viewportMinX - 12 && node.screenX <= this.viewportMaxX + 12 && node.screenY >= this.viewportMinY - 12 && node.screenY <= this.viewportMaxY + 12;
        }
        for (EdgeRenderData edge : this.edgeRenderData) {
            edge.visible = edge.a.visible || edge.b.visible || RoadGraphDebugScreenVanilla.segmentIntersectsRect(edge.a.screenX, edge.a.screenY, edge.b.screenX, edge.b.screenY, this.viewportMinX, this.viewportMinY, this.viewportMaxX, this.viewportMaxY);
        }
        this.layoutDirty = false;
    }

    private int computeGridSpacing() {
        double unitsPerPixel = 1.0 / (this.baseScale * this.zoom);
        double raw = 80.0 * unitsPerPixel;
        double pow10 = Math.pow(10.0, Math.floor(Math.log10(raw)));
        for (int n : new int[]{1, 2, 5}) {
            double candidate = (double)n * pow10;
            if (!(candidate >= raw)) continue;
            return (int)candidate;
        }
        return (int)(10.0 * pow10);
    }

    private Node findClickedNode(double mouseX, double mouseY) {
        NodeRenderData hovered = this.findHovered(mouseX, mouseY);
        return hovered == null ? null : hovered.node;
    }

    private boolean teleportTo(Node node) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return false;
        }
        if (this.currentLayer == null || !Objects.equals(mc.level.dimension(), this.currentLayer.dimension())) {
            return false;
        }
        if (mc.getSingleplayerServer() != null) {
            mc.getSingleplayerServer().execute(() -> {
                ServerPlayer sp = mc.getSingleplayerServer().getPlayerList().getPlayer(mc.player.getUUID());
                if (sp != null) {
                    sp.teleportTo((double)node.pos().getX() + 0.5, (double)node.pos().getY(), (double)node.pos().getZ() + 0.5);
                }
            });
            return true;
        }
        return false;
    }

    private static double dist2(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return dx * dx + dy * dy;
    }

    private void drawSmallLabel(GuiGraphics ctx, String text, int x, int y) {
        Font font = Minecraft.getInstance().font;
        ctx.drawString(font, text, x, y, -1, true);
    }

    private static void fillH(GuiGraphics ctx, int x0, int x1, int y, int argb) {
        if (x1 < x0) {
            int t = x0;
            x0 = x1;
            x1 = t;
        }
        ctx.fill(x0, y, x1, y + 1, argb);
    }

    private static void fillV(GuiGraphics ctx, int x, int y0, int y1, int argb) {
        if (y1 < y0) {
            int t = y0;
            y0 = y1;
            y1 = t;
        }
        ctx.fill(x, y0, x + 1, y1, argb);
    }

    private static void drawLine(GuiGraphics ctx, int x0, int y0, int x1, int y1, int argb) {
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dy = -Math.abs(y1 - y0);
        int sy = y0 < y1 ? 1 : -1;
        int err = dx + dy;
        int x = x0;
        int y = y0;
        while (true) {
            ctx.fill(x, y, x + 1, y + 1, argb);
            if (x == x1 && y == y1) break;
            int e2 = 2 * err;
            if (e2 >= dy) {
                err += dy;
                x += sx;
            }
            if (e2 > dx) continue;
            err += dx;
            y += sy;
        }
    }

    private static void fillCircle(GuiGraphics ctx, int cx, int cy, int r, int argb) {
        for (int dy = -r; dy <= r; ++dy) {
            int span = (int)Math.round(Math.sqrt(r * r - dy * dy));
            ctx.fill(cx - span, cy + dy, cx + span + 1, cy + dy + 1, argb);
        }
    }

    private static void drawCircleOutline(GuiGraphics ctx, int cx, int cy, int r, int argb) {
        int x = r;
        int y = 0;
        int err = 0;
        while (x >= y) {
            RoadGraphDebugScreenVanilla.plot8(ctx, cx, cy, x, y, argb);
            ++y;
            if (err <= 0) {
                err += 2 * y + 1;
            }
            if (err <= 0) continue;
            err -= 2 * --x + 1;
        }
    }

    private static void plot8(GuiGraphics ctx, int cx, int cy, int x, int y, int argb) {
        ctx.fill(cx + x, cy + y, cx + x + 1, cy + y + 1, argb);
        ctx.fill(cx + y, cy + x, cx + y + 1, cy + x + 1, argb);
        ctx.fill(cx - y, cy + x, cx - y + 1, cy + x + 1, argb);
        ctx.fill(cx - x, cy + y, cx - x + 1, cy + y + 1, argb);
        ctx.fill(cx - x, cy - y, cx - x + 1, cy - y + 1, argb);
        ctx.fill(cx - y, cy - x, cx - y + 1, cy - x + 1, argb);
        ctx.fill(cx + y, cy - x, cx + y + 1, cy - x + 1, argb);
        ctx.fill(cx + x, cy - y, cx + x + 1, cy - y + 1, argb);
    }

    private static int hsvToArgb(float hDeg, float s, float v) {
        float h = (hDeg % 360.0f + 360.0f) % 360.0f / 60.0f;
        int i = (int)Math.floor(h);
        float f = h - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        switch (i) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            case -1: 
            case 5: {
                r = v;
                g = p;
                b = q;
            }
        }
        int ri = Math.round(r * 255.0f);
        int gi = Math.round(g * 255.0f);
        int bi = Math.round(b * 255.0f);
        return 0xFF000000 | ri << 16 | gi << 8 | bi;
    }

    private ScreenPoint worldToScreen(double wx, double wz) {
        if (this.nodeRenderData.length == 0) {
            return null;
        }
        int sx = 20 + (int)Math.round((wx - (double)this.minX) * this.baseScale * this.zoom + this.offsetX);
        int sy = 20 + (int)Math.round((wz - (double)this.minZ) * this.baseScale * this.zoom + this.offsetY);
        return new ScreenPoint(sx, sy);
    }

    private void setActiveLayer(int index) {
        if (this.layers.isEmpty()) {
            this.clearActiveLayer();
            return;
        }
        this.saveCurrentViewState();
        int normalized = Math.floorMod(index, this.layers.size());
        this.currentLayer = this.layers.get(normalized);
        HashMap<String, NodeRenderData> lookup = new HashMap<String, NodeRenderData>(this.currentLayer.nodes().size() * 2);
        this.nodeRenderData = new NodeRenderData[this.currentLayer.nodes().size()];
        LinkedHashSet<String> typeOrder = new LinkedHashSet<String>();
        for (int i = 0; i < this.currentLayer.nodes().size(); ++i) {
            NodeRenderData data;
            Node node = this.currentLayer.nodes().get(i);
            typeOrder.add(node.type());
            int color = this.typeColors.computeIfAbsent(node.type(), t -> RoadGraphDebugScreenVanilla.hsvToArgb(Math.abs(t.hashCode() % 360), 0.6f, 0.9f));
            this.nodeRenderData[i] = data = new NodeRenderData(node, color);
            lookup.put(node.id(), data);
        }
        ArrayList<EdgeRenderData> edges = new ArrayList<EdgeRenderData>(this.currentLayer.edges().size());
        for (EdgeStorage.Edge edge : this.currentLayer.edges()) {
            NodeRenderData a = (NodeRenderData)lookup.get(edge.nodeA());
            NodeRenderData b = (NodeRenderData)lookup.get(edge.nodeB());
            if (a == null || b == null) continue;
            int color = this.statusColors.getOrDefault((Object)edge.status(), -1);
            edges.add(new EdgeRenderData(a, b, color));
        }
        this.edgeRenderData = (EdgeRenderData[])edges.toArray(EdgeRenderData[]::new);
        ArrayList<LegendEntry> legend = new ArrayList<LegendEntry>(typeOrder.size());
        for (String type : typeOrder) {
            legend.add(new LegendEntry((Component)Component.literal((String)type), this.typeColors.getOrDefault(type, -1)));
        }
        this.legendEntries = List.copyOf(legend);
        this.dimensionLabel = Component.translatable((String)"screen.roadarchitect.debug.dimension_label", (Object[])new Object[]{RoadGraphDebugScreenVanilla.describeLayer(this.currentLayer).getString()}).withStyle(ChatFormatting.GRAY);
        this.recalcBounds(this.nodeRenderData);
        this.loadViewState(this.currentLayer);
        this.layoutDirty = true;
        this.lastPlayerDimension = this.currentLayer.dimension();
    }

    private void clearActiveLayer() {
        this.saveCurrentViewState();
        this.currentLayer = null;
        this.nodeRenderData = NodeRenderData.EMPTY;
        this.edgeRenderData = EdgeRenderData.EMPTY;
        this.legendEntries = List.of();
        this.dimensionLabel = Component.empty();
        this.recalcBounds(this.nodeRenderData);
        this.zoom = 1.0;
        this.offsetX = 0.0;
        this.offsetY = 0.0;
        this.baseScale = 1.0;
        this.firstLayout = true;
        this.layoutDirty = true;
    }

    private void focusOnCurrentDimension() {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.level == null) {
            if (this.currentLayer != null) {
                this.clearActiveLayer();
            }
            this.lastPlayerDimension = null;
            return;
        }
        ResourceKey playerDimension = mc.level.dimension();
        if (this.currentLayer != null && Objects.equals(this.currentLayer.dimension(), playerDimension)) {
            this.lastPlayerDimension = playerDimension;
            return;
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            DimensionLayer layer = this.layers.get(i);
            if (!Objects.equals(layer.dimension(), playerDimension)) continue;
            this.setActiveLayer(i);
            this.lastPlayerDimension = playerDimension;
            return;
        }
        if (this.currentLayer != null || !Objects.equals(this.lastPlayerDimension, playerDimension)) {
            this.clearActiveLayer();
        }
        this.lastPlayerDimension = playerDimension;
    }

    private void recalcBounds(NodeRenderData[] nodes) {
        if (nodes.length == 0) {
            this.maxZ = 0;
            this.minZ = 0;
            this.maxX = 0;
            this.minX = 0;
            return;
        }
        this.minX = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.minZ = Integer.MAX_VALUE;
        this.maxZ = Integer.MIN_VALUE;
        for (NodeRenderData node : nodes) {
            int x = node.node.pos().getX();
            int z = node.node.pos().getZ();
            if (x < this.minX) {
                this.minX = x;
            }
            if (x > this.maxX) {
                this.maxX = x;
            }
            if (z < this.minZ) {
                this.minZ = z;
            }
            if (z <= this.maxZ) continue;
            this.maxZ = z;
        }
        if (this.minX == this.maxX) {
            --this.minX;
            ++this.maxX;
        }
        if (this.minZ == this.maxZ) {
            --this.minZ;
            ++this.maxZ;
        }
    }

    private void saveCurrentViewState() {
        if (this.currentLayer == null) {
            return;
        }
        this.viewStates.put(this.currentLayer.dimension(), new ViewState(this.zoom, this.offsetX, this.offsetY, this.firstLayout));
    }

    private void loadViewState(DimensionLayer layer) {
        ViewState state = this.viewStates.get(layer.dimension());
        if (state != null) {
            this.zoom = state.zoom();
            this.offsetX = state.offsetX();
            this.offsetY = state.offsetY();
            this.firstLayout = state.firstLayout();
        } else {
            this.zoom = 1.0;
            this.offsetX = 0.0;
            this.offsetY = 0.0;
            this.firstLayout = true;
        }
        this.layoutDirty = true;
    }

    private static Component describeLayer(DimensionLayer layer) {
        ResourceLocation id = layer.dimension().location();
        return Component.literal((String)id.toString());
    }

    private static boolean segmentIntersectsRect(int x0, int y0, int x1, int y1, int minX, int minY, int maxX, int maxY) {
        int code0 = RoadGraphDebugScreenVanilla.outCode(x0, y0, minX, minY, maxX, maxY);
        int code1 = RoadGraphDebugScreenVanilla.outCode(x1, y1, minX, minY, maxX, maxY);
        while ((code0 | code1) != 0) {
            if ((code0 & code1) != 0) {
                return false;
            }
            int outCode = code0 != 0 ? code0 : code1;
            double ix = 0.0;
            double iy = 0.0;
            if ((outCode & 8) != 0) {
                if (y1 == y0) {
                    iy = maxY;
                    ix = x0;
                } else {
                    ix = (double)x0 + (double)(x1 - x0) * (double)(maxY - y0) / (double)(y1 - y0);
                    iy = maxY;
                }
            } else if ((outCode & 4) != 0) {
                if (y1 == y0) {
                    iy = minY;
                    ix = x0;
                } else {
                    ix = (double)x0 + (double)(x1 - x0) * (double)(minY - y0) / (double)(y1 - y0);
                    iy = minY;
                }
            } else if ((outCode & 2) != 0) {
                if (x1 == x0) {
                    ix = maxX;
                    iy = y0;
                } else {
                    iy = (double)y0 + (double)(y1 - y0) * (double)(maxX - x0) / (double)(x1 - x0);
                    ix = maxX;
                }
            } else if ((outCode & 1) != 0) {
                if (x1 == x0) {
                    ix = minX;
                    iy = y0;
                } else {
                    iy = (double)y0 + (double)(y1 - y0) * (double)(minX - x0) / (double)(x1 - x0);
                    ix = minX;
                }
            }
            if (outCode == code0) {
                x0 = (int)Math.round(ix);
                y0 = (int)Math.round(iy);
                code0 = RoadGraphDebugScreenVanilla.outCode(x0, y0, minX, minY, maxX, maxY);
                continue;
            }
            x1 = (int)Math.round(ix);
            y1 = (int)Math.round(iy);
            code1 = RoadGraphDebugScreenVanilla.outCode(x1, y1, minX, minY, maxX, maxY);
        }
        return true;
    }

    private static int outCode(int x, int y, int minX, int minY, int maxX, int maxY) {
        int code = 0;
        if (x < minX) {
            code |= 1;
        } else if (x > maxX) {
            code |= 2;
        }
        if (y < minY) {
            code |= 4;
        } else if (y > maxY) {
            code |= 8;
        }
        return code;
    }

    private void renderGraphCanvas(GuiGraphics ctx) {
        if (this.nodeRenderData.length == 0) {
            return;
        }
        for (EdgeRenderData edge : this.edgeRenderData) {
            if (!edge.visible) continue;
            RoadGraphDebugScreenVanilla.drawLine(ctx, edge.a.screenX, edge.a.screenY, edge.b.screenX, edge.b.screenY, edge.color);
        }
        for (NodeRenderData node : this.nodeRenderData) {
            if (!node.visible) continue;
            RoadGraphDebugScreenVanilla.fillCircle(ctx, node.screenX, node.screenY, 4, node.color);
            RoadGraphDebugScreenVanilla.drawCircleOutline(ctx, node.screenX, node.screenY, 4, -16777216);
        }
    }

    private NodeRenderData findHovered(double mouseX, double mouseY) {
        for (NodeRenderData node : this.nodeRenderData) {
            if (!node.visible || !(RoadGraphDebugScreenVanilla.dist2(node.screenX, node.screenY, mouseX, mouseY) <= 16.0)) continue;
            return node;
        }
        return null;
    }

    private static final class NodeRenderData {
        private static final NodeRenderData[] EMPTY = new NodeRenderData[0];
        final Node node;
        final int color;
        final Component tooltip;
        int screenX;
        int screenY;
        boolean visible;

        NodeRenderData(Node node, int color) {
            this.node = node;
            this.color = color;
            this.tooltip = Component.literal((String)(node.pos().toShortString() + " \u2022 " + node.type()));
        }

        Component tooltip() {
            return this.tooltip;
        }
    }

    private static final class EdgeRenderData {
        private static final EdgeRenderData[] EMPTY = new EdgeRenderData[0];
        final NodeRenderData a;
        final NodeRenderData b;
        final int color;
        boolean visible;

        EdgeRenderData(NodeRenderData a, NodeRenderData b, int color) {
            this.a = a;
            this.b = b;
            this.color = color;
        }
    }

    public record DimensionLayer(ResourceKey<Level> dimension, List<Node> nodes, List<EdgeStorage.Edge> edges) {
        public DimensionLayer {
            nodes = List.copyOf(nodes);
            edges = List.copyOf(edges);
        }
    }

    private record LegendEntry(Component label, int color) {
    }

    private record ScreenPoint(int x, int y) {
    }

    private record ViewState(double zoom, double offsetX, double offsetY, boolean firstLayout) {
    }
}

