/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.neoforge.events;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.oxcodsnet.roadarchitect.handlers.RoadGraphStateManager;
import net.oxcodsnet.roadarchitect.handlers.RoadPostProcessor;
import net.oxcodsnet.roadarchitect.util.CacheManager;

public final class NeoForgeEventBridge {
    private NeoForgeEventBridge() {
    }

    public static void register() {
        NeoForge.EVENT_BUS.register(NeoForgeEventBridge.class);
    }

    @SubscribeEvent
    private static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)levelAccessor;
            RoadGraphStateManager.onWorldLoad(world);
            CacheManager.onWorldLoad(world);
        }
    }

    @SubscribeEvent
    private static void onWorldUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)levelAccessor;
            RoadGraphStateManager.onWorldUnload(world);
            CacheManager.onWorldUnload(world);
        }
    }

    @SubscribeEvent
    private static void onChunkLoad(ChunkEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)levelAccessor;
            CacheManager.onChunkLoad(world, event.getChunk());
        }
    }

    @SubscribeEvent
    private static void onChunkUnload(ChunkEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)levelAccessor;
            CacheManager.onChunkUnload(world, ((LevelChunk)event.getChunk()).getPos());
        }
    }

    @SubscribeEvent
    private static void onServerStopping(ServerStoppingEvent event) {
        RoadGraphStateManager.onServerStopping(event.getServer());
        CacheManager.onServerStopping(event.getServer());
    }

    @SubscribeEvent
    private static void onLevelTick(LevelTickEvent.Pre event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            RoadPostProcessor.onStartWorldTick(world);
        }
    }
}

