/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;

final class DimensionPaths {
    private DimensionPaths() {
    }

    static Path resolveCacheDirectory(ServerLevel world) {
        Path dimRoot = DimensionPaths.resolveDimensionRoot(world);
        Path cacheDir = dimRoot.resolve("roadarchitect").resolve("cache");
        try {
            Files.createDirectories(cacheDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create cache directory at " + String.valueOf(cacheDir), e);
        }
        return cacheDir;
    }

    static Path resolveDimensionRoot(ServerLevel world) {
        Path root = world.getServer().getWorldPath(LevelResource.ROOT);
        ResourceKey key = world.dimension();
        if (key == Level.OVERWORLD) {
            return root;
        }
        if (key == Level.NETHER) {
            return root.resolve("DIM-1");
        }
        if (key == Level.END) {
            return root.resolve("DIM1");
        }
        ResourceLocation id = key.location();
        return root.resolve("dimensions").resolve(id.getNamespace()).resolve(id.getPath());
    }
}

