/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.client.gui;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.oxcodsnet.roadarchitect.storage.EdgeStorage;
import net.oxcodsnet.roadarchitect.storage.components.Node;

public class RoadGraphDebugScreenVanilla
extends class_437 {
    private static final int RADIUS = 4;
    private static final int PADDING = 20;
    private static final int TARGET_GRID_PX = 80;
    private final List<Node> nodes;
    private final Collection<EdgeStorage.Edge> edges;
    private final Supplier<class_2561> titleSupplier;
    private final Map<String, ScreenPos> screenPositions = new HashMap<String, ScreenPos>();
    private final Map<String, Integer> typeColors = new HashMap<String, Integer>();
    private final Map<EdgeStorage.Status, Integer> statusColors = Map.of(EdgeStorage.Status.NEW, -865972, EdgeStorage.Status.SUCCESS, -14176672, EdgeStorage.Status.FAILURE, -5368277);
    private boolean dragging = false;
    private boolean firstLayout = true;
    private double zoom = 1.0;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double baseScale = 1.0;
    private int minX;
    private int maxX;
    private int minZ;
    private int maxZ;

    public RoadGraphDebugScreenVanilla(List<Node> nodes, Collection<EdgeStorage.Edge> edges) {
        this(nodes, edges, () -> class_2561.method_43470((String)"Road Graph Debug"));
    }

    public RoadGraphDebugScreenVanilla(List<Node> nodes, Collection<EdgeStorage.Edge> edges, Supplier<class_2561> titleSupplier) {
        super(titleSupplier.get());
        this.nodes = nodes;
        this.edges = edges;
        this.titleSupplier = titleSupplier;
        if (!nodes.isEmpty()) {
            this.minX = nodes.stream().mapToInt(n -> n.pos().method_10263()).min().orElse(0);
            this.maxX = nodes.stream().mapToInt(n -> n.pos().method_10263()).max().orElse(0);
            this.minZ = nodes.stream().mapToInt(n -> n.pos().method_10260()).min().orElse(0);
            this.maxZ = nodes.stream().mapToInt(n -> n.pos().method_10260()).max().orElse(0);
        }
        for (Node node : nodes) {
            this.typeColors.computeIfAbsent(node.type(), t -> RoadGraphDebugScreenVanilla.hsvToArgb(Math.abs(t.hashCode() % 360), 0.6f, 0.9f));
        }
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.method_25420(ctx, mouseX, mouseY, delta);
        this.computeLayout();
        ctx.method_25294(20, 20, this.field_22789 - 20, this.field_22790 - 20, -1609560048);
        ctx.method_49601(20, 20, this.field_22789 - 40, this.field_22790 - 40, -1);
        this.drawGrid(ctx);
        for (EdgeStorage.Edge edge : this.edges) {
            ScreenPos a = this.screenPositions.get(edge.nodeA());
            ScreenPos b = this.screenPositions.get(edge.nodeB());
            if (a == null || b == null) continue;
            int col = this.statusColors.getOrDefault((Object)edge.status(), -1);
            RoadGraphDebugScreenVanilla.drawLine(ctx, a.x, a.y, b.x, b.y, col);
        }
        Node hovered = null;
        for (Node n : this.nodes) {
            ScreenPos p = this.screenPositions.get(n.id());
            if (p == null) continue;
            int fill = this.typeColors.getOrDefault(n.type(), -1);
            RoadGraphDebugScreenVanilla.fillCircle(ctx, p.x, p.y, 4, fill);
            RoadGraphDebugScreenVanilla.drawCircleOutline(ctx, p.x, p.y, 4, -16777216);
            if (!(RoadGraphDebugScreenVanilla.dist2(p.x, p.y, mouseX, mouseY) <= 16.0)) continue;
            hovered = n;
        }
        if (hovered != null) {
            class_327 class_3272 = class_310.method_1551().field_1772;
            ctx.method_51438(class_3272, (class_2561)class_2561.method_43470((String)(hovered.pos().method_23854() + " \u2022 " + hovered.type())), mouseX, mouseY);
        }
        this.drawScale(ctx);
        this.drawLegend(ctx);
        this.drawCenteredTitle(ctx);
        super.method_25394(ctx, mouseX, mouseY, delta);
    }

    public boolean method_25422() {
        return true;
    }

    protected void method_57734() {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return super.method_25402(mouseX, mouseY, button);
        }
        Node clicked = this.findClickedNode(mouseX, mouseY);
        if (clicked != null) {
            this.teleportTo(clicked);
            return true;
        }
        this.dragging = true;
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging && button == 0) {
            this.offsetX += deltaX;
            this.offsetY += deltaY;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.dragging) {
            this.dragging = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontal, double vertical) {
        double old = this.zoom;
        this.zoom = vertical > 0.0 ? this.zoom * 1.1 : this.zoom / 1.1;
        this.offsetX = (this.offsetX - mouseX + 20.0) * (this.zoom / old) + mouseX - 20.0;
        this.offsetY = (this.offsetY - mouseY + 20.0) * (this.zoom / old) + mouseY - 20.0;
        return true;
    }

    private void drawCenteredTitle(class_332 ctx) {
        class_327 font = class_310.method_1551().field_1772;
        class_2561 t = this.titleSupplier.get();
        int tw = font.method_27525((class_5348)t);
        ctx.method_51439(font, t, (this.field_22789 - tw) / 2, 8, -1, true);
    }

    private void drawGrid(class_332 ctx) {
        int w = this.field_22789 - 40;
        int h = this.field_22790 - 40;
        double worldX0 = (double)this.minX + -this.offsetX / (this.baseScale * this.zoom);
        double worldZ0 = (double)this.minZ + -this.offsetY / (this.baseScale * this.zoom);
        double worldX1 = (double)this.minX + ((double)w - this.offsetX) / (this.baseScale * this.zoom);
        double worldZ1 = (double)this.minZ + ((double)h - this.offsetY) / (this.baseScale * this.zoom);
        int spacing = this.computeGridSpacing();
        int startWX = (int)Math.floor(worldX0 / (double)spacing) * spacing;
        int startWZ = (int)Math.floor(worldZ0 / (double)spacing) * spacing;
        int x = startWX;
        while ((double)x <= worldX1) {
            int sx = 20 + (int)(((double)x - worldX0) * this.baseScale * this.zoom);
            RoadGraphDebugScreenVanilla.fillV(ctx, sx, 20, 20 + h, 0x60444444);
            this.drawSmallLabel(ctx, String.valueOf(x), sx + 2, 22);
            x += spacing;
        }
        int z = startWZ;
        while ((double)z <= worldZ1) {
            int sz = 20 + (int)(((double)z - worldZ0) * this.baseScale * this.zoom);
            RoadGraphDebugScreenVanilla.fillH(ctx, 20, 20 + w, sz, 0x60444444);
            this.drawSmallLabel(ctx, String.valueOf(z), 22, sz + 2);
            z += spacing;
        }
    }

    private void drawScale(class_332 ctx) {
        int spacing = this.computeGridSpacing();
        int lengthPx = (int)((double)spacing * this.baseScale * this.zoom);
        int x = this.field_22789 - 20 - lengthPx - 10;
        int y = this.field_22790 - 20 - 8;
        RoadGraphDebugScreenVanilla.fillH(ctx, x, x + lengthPx, y, -1);
        RoadGraphDebugScreenVanilla.fillV(ctx, x, y - 3, y + 3, -1);
        RoadGraphDebugScreenVanilla.fillV(ctx, x + lengthPx, y - 3, y + 3, -1);
        this.drawSmallLabel(ctx, spacing + "m", x, y - 10);
    }

    private void drawLegend(class_332 ctx) {
        int x = 20;
        int y = this.field_22790 - 20 - this.typeColors.size() * 12;
        for (Map.Entry<String, Integer> e : this.typeColors.entrySet()) {
            ctx.method_25294(x, y, x + 8, y + 8, e.getValue().intValue());
            ctx.method_49601(x, y, 8, 8, -1);
            this.drawSmallLabel(ctx, e.getKey(), x + 10, y);
            y += 12;
        }
    }

    private void computeLayout() {
        if (this.nodes.isEmpty()) {
            return;
        }
        int w = Math.max(1, this.field_22789 - 40);
        int h = Math.max(1, this.field_22790 - 40);
        double scaleX = (double)w / (double)Math.max(1, this.maxX - this.minX);
        double scaleZ = (double)h / (double)Math.max(1, this.maxZ - this.minZ);
        this.baseScale = Math.min(scaleX, scaleZ);
        if (this.firstLayout) {
            double graphW = (double)(this.maxX - this.minX) * this.baseScale * this.zoom;
            double graphH = (double)(this.maxZ - this.minZ) * this.baseScale * this.zoom;
            this.offsetX = ((double)w - graphW) / 2.0;
            this.offsetY = ((double)h - graphH) / 2.0;
            this.firstLayout = false;
        }
        this.screenPositions.clear();
        for (Node node : this.nodes) {
            double sx = (double)(node.pos().method_10263() - this.minX) * this.baseScale * this.zoom + this.offsetX;
            double sy = (double)(node.pos().method_10260() - this.minZ) * this.baseScale * this.zoom + this.offsetY;
            this.screenPositions.put(node.id(), new ScreenPos(20 + (int)sx, 20 + (int)sy));
        }
    }

    private int computeGridSpacing() {
        double unitsPerPixel = 1.0 / (this.baseScale * this.zoom);
        double raw = 80.0 * unitsPerPixel;
        double pow10 = Math.pow(10.0, Math.floor(Math.log10(raw)));
        for (int n : new int[]{1, 2, 5}) {
            double candidate = (double)n * pow10;
            if (!(candidate >= raw)) continue;
            return (int)candidate;
        }
        return (int)(10.0 * pow10);
    }

    private Node findClickedNode(double mouseX, double mouseY) {
        for (Node node : this.nodes) {
            ScreenPos p = this.screenPositions.get(node.id());
            if (p == null || !(RoadGraphDebugScreenVanilla.dist2(p.x, p.y, mouseX, mouseY) <= 16.0)) continue;
            return node;
        }
        return null;
    }

    private void teleportTo(Node node) {
        class_310 mc = class_310.method_1551();
        mc.execute(() -> {
            class_3222 sp;
            if (mc.method_1576() != null && mc.field_1724 != null && (sp = mc.method_1576().method_3760().method_14602(mc.field_1724.method_5667())) != null) {
                sp.method_5859((double)node.pos().method_10263() + 0.5, (double)node.pos().method_10264(), (double)node.pos().method_10260() + 0.5);
            }
        });
    }

    private static double dist2(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return dx * dx + dy * dy;
    }

    private void drawSmallLabel(class_332 ctx, String s, int x, int y) {
        class_327 font = class_310.method_1551().field_1772;
        ctx.method_51439(font, (class_2561)class_2561.method_43470((String)s), x, y, -1, true);
    }

    private static void fillH(class_332 ctx, int x0, int x1, int y, int argb) {
        if (x1 < x0) {
            int t = x0;
            x0 = x1;
            x1 = t;
        }
        ctx.method_25294(x0, y, x1, y + 1, argb);
    }

    private static void fillV(class_332 ctx, int x, int y0, int y1, int argb) {
        if (y1 < y0) {
            int t = y0;
            y0 = y1;
            y1 = t;
        }
        ctx.method_25294(x, y0, x + 1, y1, argb);
    }

    private static void drawLine(class_332 ctx, int x0, int y0, int x1, int y1, int argb) {
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dy = -Math.abs(y1 - y0);
        int sy = y0 < y1 ? 1 : -1;
        int err = dx + dy;
        int x = x0;
        int y = y0;
        while (true) {
            ctx.method_25294(x, y, x + 1, y + 1, argb);
            if (x == x1 && y == y1) break;
            int e2 = 2 * err;
            if (e2 >= dy) {
                err += dy;
                x += sx;
            }
            if (e2 > dx) continue;
            err += dx;
            y += sy;
        }
    }

    private static void fillCircle(class_332 ctx, int cx, int cy, int r, int argb) {
        for (int dy = -r; dy <= r; ++dy) {
            int span = (int)Math.round(Math.sqrt(r * r - dy * dy));
            ctx.method_25294(cx - span, cy + dy, cx + span + 1, cy + dy + 1, argb);
        }
    }

    private static void drawCircleOutline(class_332 ctx, int cx, int cy, int r, int argb) {
        int x = r;
        int y = 0;
        int err = 0;
        while (x >= y) {
            RoadGraphDebugScreenVanilla.plot8(ctx, cx, cy, x, y, argb);
            ++y;
            if (err <= 0) {
                err += 2 * y + 1;
            }
            if (err <= 0) continue;
            err -= 2 * --x + 1;
        }
    }

    private static void plot8(class_332 ctx, int cx, int cy, int x, int y, int argb) {
        ctx.method_25294(cx + x, cy + y, cx + x + 1, cy + y + 1, argb);
        ctx.method_25294(cx + y, cy + x, cx + y + 1, cy + x + 1, argb);
        ctx.method_25294(cx - y, cy + x, cx - y + 1, cy + x + 1, argb);
        ctx.method_25294(cx - x, cy + y, cx - x + 1, cy + y + 1, argb);
        ctx.method_25294(cx - x, cy - y, cx - x + 1, cy - y + 1, argb);
        ctx.method_25294(cx - y, cy - x, cx - y + 1, cy - x + 1, argb);
        ctx.method_25294(cx + y, cy - x, cx + y + 1, cy - x + 1, argb);
        ctx.method_25294(cx + x, cy - y, cx + x + 1, cy - y + 1, argb);
    }

    private static int hsvToArgb(float hDeg, float s, float v) {
        float h = (hDeg % 360.0f + 360.0f) % 360.0f / 60.0f;
        int i = (int)Math.floor(h);
        float f = h - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        switch (i) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            case -1: 
            case 5: {
                r = v;
                g = p;
                b = q;
            }
        }
        int ri = Math.round(r * 255.0f);
        int gi = Math.round(g * 255.0f);
        int bi = Math.round(b * 255.0f);
        return 0xFF000000 | ri << 16 | gi << 8 | bi;
    }

    private record ScreenPos(int x, int y) {
    }
}

