/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.handlers;

import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.storage.RoadGraphState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoadGraphStateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect/RoadGraphStateManager");

    private RoadGraphStateManager() {
    }

    public static void onWorldLoad(class_3218 world) {
        RoadGraphState.get(world, RoadArchitect.CONFIG.maxConnectionDistance());
        LOGGER.debug("RoadGraphState loaded for world {}", (Object)world.method_27983().method_29177());
    }

    public static void onWorldUnload(class_3218 world) {
        RoadGraphState state = RoadGraphState.get(world, RoadArchitect.CONFIG.maxConnectionDistance());
        state.method_80();
        LOGGER.debug("Saved RoadGraphState for world {} on unload", (Object)world.method_27983().method_29177());
    }

    public static void onServerStopping(MinecraftServer server) {
        for (class_3218 world : server.method_3738()) {
            RoadGraphState.get(world, RoadArchitect.CONFIG.maxConnectionDistance()).method_80();
        }
        LOGGER.debug("Server stopping, all RoadGraphStates marked dirty");
    }
}

