/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.util;

import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7138;
import net.oxcodsnet.roadarchitect.storage.NodeStorage;
import net.oxcodsnet.roadarchitect.storage.components.Node;
import net.oxcodsnet.roadarchitect.util.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathFinder {
    public static final int GRID_STEP = 4;
    public static final double HEURISTIC_WEIGHT = 1.5;
    public static final double HEURISTIC_SCALE = 95.0;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect/PathFinder");
    private static final int[][] OFFSETS = PathFinder.generateOffsets();
    private static final Map<class_6862<class_1959>, Double> BIOME_COSTS = Map.of(class_6908.field_36511, 400.0, class_6908.field_36509, 999.0, class_6908.field_36508, 999.0, class_6908.field_36512, 160.0, class_6908.field_36510, 160.0);
    private static final boolean PROFILING_ENABLED = true;
    private final NodeStorage nodes;
    private final class_3218 world;
    private final int maxSteps;
    private final double heuristicWeight;
    private final class_2794 generator;
    private final class_7138 noiseConfig;
    private final class_6544.class_6552 noiseSampler;
    private final class_1966 biomeSource;
    private long profHeightCalls = 0L;
    private long profBiomeCalls = 0L;
    private long profStabCalls = 0L;

    public PathFinder(NodeStorage nodes, class_3218 world, int maxSteps) {
        this(nodes, world, maxSteps, 1.5);
    }

    public PathFinder(NodeStorage nodes, class_3218 world, int maxSteps, double heuristicWeight) {
        this.nodes = nodes;
        this.world = world;
        this.maxSteps = maxSteps;
        this.heuristicWeight = heuristicWeight;
        this.generator = world.method_14178().method_12129();
        this.noiseConfig = world.method_14178().method_41248();
        this.noiseSampler = this.noiseConfig.method_42371();
        this.biomeSource = this.generator.method_12098();
    }

    private static double stepCost(int[] off) {
        return Math.abs(off[0]) == 4 && Math.abs(off[1]) == 4 ? 1.5 : 1.0;
    }

    private static double elevationCost(int y1, int y2) {
        return (double)Math.abs(y1 - y2) * 40.0;
    }

    private static double biomeCost(class_6880<class_1959> biome) {
        for (Map.Entry<class_6862<class_1959>, Double> entry : BIOME_COSTS.entrySet()) {
            if (!biome.method_40220(entry.getKey())) continue;
            return entry.getValue();
        }
        return 0.0;
    }

    private static double yLevelCost(int y) {
        return y <= 63 ? 240.0 : 0.0;
    }

    private static boolean isSteep(int y1, int y2) {
        return Math.abs(y1 - y2) > 3;
    }

    private static double heuristic(int x, int z, class_2338 goal, double scale) {
        int dx = Math.abs(x - goal.method_10263());
        int dz = Math.abs(z - goal.method_10260());
        double a = (double)(dx + dz) - 0.5 * (double)Math.min(dx, dz);
        return a * scale;
    }

    private static double heuristic(class_2338 a, class_2338 b, double scale) {
        return PathFinder.heuristic(a.method_10263(), a.method_10260(), b, scale);
    }

    private static double heuristic(int x, int z, class_2338 goal) {
        return PathFinder.heuristic(x, z, goal, 95.0);
    }

    private static double heuristic(class_2338 a, class_2338 b) {
        return PathFinder.heuristic(a, b, 95.0);
    }

    private static double selectHeuristicScale(class_2338 start, class_2338 goal) {
        int l1 = Math.abs(start.method_10263() - goal.method_10263()) + Math.abs(start.method_10260() - goal.method_10260());
        double L0 = 200.0;
        double L1 = 1200.0;
        double t = ((double)l1 - 200.0) / 1000.0;
        if (t < 0.0) {
            t = 0.0;
        } else if (t > 1.0) {
            t = 1.0;
        }
        double s = t * t * (3.0 - 2.0 * t);
        double scale = 80.0 + s * 40.0;
        return Math.max(80.0, Math.min(120.0, scale));
    }

    private static int selectMaxSteps(class_2338 start, class_2338 goal) {
        int l1 = Math.abs(start.method_10263() - goal.method_10263()) + Math.abs(start.method_10260() - goal.method_10260());
        double k = 16.0;
        int min = 512;
        int max = 200000;
        long est = Math.round(k * (double)l1 / 4.0);
        if (est < (long)min) {
            return min;
        }
        if (est > (long)max) {
            return max;
        }
        return (int)est;
    }

    private static class_2338 snap(class_2338 p) {
        int x = Math.floorDiv(p.method_10263(), 4) * 4;
        int z = Math.floorDiv(p.method_10260(), 4) * 4;
        return new class_2338(x, p.method_10264(), z);
    }

    private static int[][] generateOffsets() {
        int d = 4;
        return new int[][]{{d, 0}, {-d, 0}, {0, d}, {0, -d}, {d, d}, {d, -d}, {-d, d}, {-d, -d}};
    }

    public List<class_2338> findPath(String fromId, String toId) {
        Node startNode = this.nodes.all().get(fromId);
        Node endNode = this.nodes.all().get(toId);
        if (startNode == null || endNode == null) {
            LOGGER.debug("Missing node(s) {} or {}", (Object)fromId, (Object)toId);
            return List.of();
        }
        return this.aStarPositions(PathFinder.snap(startNode.pos()), PathFinder.snap(endNode.pos()));
    }

    public List<class_2338> findPath(class_2338 from, class_2338 to) {
        return this.aStarPositions(PathFinder.snap(from), PathFinder.snap(to));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<class_2338> aStarPositions(class_2338 startPos, class_2338 endPos) {
        ProfileSession ps = new ProfileSession(startPos, endPos);
        try {
            List<class_2338> list = this.aStarPositions(startPos, endPos, ps);
            return list;
        }
        finally {
            this.logProfile(ps);
            this.profStabCalls = 0L;
            this.profBiomeCalls = 0L;
            this.profHeightCalls = 0L;
        }
    }

    private List<class_2338> aStarPositions(class_2338 startPos, class_2338 endPos, ProfileSession ps) {
        long startKey = CacheManager.hash(startPos.method_10263(), startPos.method_10260());
        long endKey = CacheManager.hash(endPos.method_10263(), endPos.method_10260());
        double localScale = PathFinder.selectHeuristicScale(startPos, endPos);
        int localStepCap = Math.min(PathFinder.selectMaxSteps(startPos, endPos), this.maxSteps);
        if (ps != null) {
            ps.localScale = localScale;
            ps.stepCap = localStepCap;
        }
        PriorityQueue<Rec> open = new PriorityQueue<Rec>(Comparator.comparingDouble(r -> r.f));
        Long2DoubleOpenHashMap gScore = new Long2DoubleOpenHashMap();
        gScore.defaultReturnValue(Double.MAX_VALUE);
        Long2LongOpenHashMap parent = new Long2LongOpenHashMap();
        gScore.put(startKey, 0.0);
        record Rec(long key, double g, double f) {
        }
        open.add(new Rec(startKey, 0.0, PathFinder.heuristic(startPos, endPos, localScale) * this.heuristicWeight));
        int iterations = 0;
        while (!open.isEmpty() && iterations++ < localStepCap) {
            Rec current;
            if (ps != null) {
                ++ps.iterations;
            }
            if ((current = open.poll()).g() > gScore.get(current.key())) continue;
            int curX = (int)(current.key >> 32);
            int curZ = (int)current.key;
            int curY = this.sampleHeight(curX, curZ);
            int md = Math.abs(curX - endPos.method_10263()) + Math.abs(curZ - endPos.method_10260());
            if (ps != null) {
                ps.lastL1 = md;
                if (current.f() < ps.bestF) {
                    ps.bestF = current.f();
                }
                if (md < ps.bestL1) {
                    ps.bestL1 = md;
                    ps.stallIters = 0;
                } else {
                    ++ps.stallIters;
                }
            }
            if (current.key == endKey) {
                List<class_2338> path = this.reconstructVertices(current.key, startKey, (Long2LongMap)parent);
                if (ps != null) {
                    ps.avgStepOnPath = this.computeAvgCostOfPathVertices(path);
                    ps.pathFound = true;
                    ps.bestL1 = Math.min(ps.bestL1, md);
                }
                return path;
            }
            for (int[] off : OFFSETS) {
                double bCost;
                double stab;
                int ny;
                int nx = curX + off[0];
                int nz = curZ + off[1];
                long neighKey = CacheManager.hash(nx, nz);
                if (ps != null) {
                    ++ps.neighborsChecked;
                }
                if (PathFinder.isSteep(curY, ny = this.sampleHeight(nx, nz)) || (stab = this.sampleStability(nx, nz, ny)) == Double.MAX_VALUE || (bCost = PathFinder.biomeCost(this.sampleBiome(nx, nz, ny))) >= 999.0) continue;
                double inc = PathFinder.stepCost(off) + PathFinder.elevationCost(curY, ny) + bCost + PathFinder.yLevelCost(ny) + stab;
                double tentativeG = gScore.get(current.key) + inc;
                if (!(tentativeG < gScore.get(neighKey))) continue;
                parent.put(neighKey, current.key);
                gScore.put(neighKey, tentativeG);
                if (ps != null) {
                    ++ps.relaxationsAccepted;
                    ps.sumStepCosts += inc;
                }
                double f = tentativeG + PathFinder.heuristic(nx, nz, endPos, localScale) * this.heuristicWeight;
                open.add(new Rec(neighKey, tentativeG, f));
            }
        }
        if (ps != null) {
            ps.hitCap = !open.isEmpty();
        }
        LOGGER.debug("Path not found between {} and {} after {} iterations (cap={})", new Object[]{startPos, endPos, Math.min(iterations, localStepCap), localStepCap});
        return List.of();
    }

    private int sampleHeight(int x, int z) {
        ++this.profHeightCalls;
        long key = CacheManager.hash(x, z);
        return CacheManager.getHeight(this.world, key, () -> this.generator.method_16397(x, z, class_2902.class_2903.field_13194, (class_5539)this.world, this.noiseConfig));
    }

    private double sampleStability(int x, int z, int y) {
        ++this.profStabCalls;
        long key = CacheManager.hash(x, z);
        return CacheManager.getStability(this.world, key, () -> this.terrainStabilityCost(x, z, y));
    }

    private class_6880<class_1959> sampleBiome(int x, int z, int y) {
        ++this.profBiomeCalls;
        long key = CacheManager.hash(x, z);
        return CacheManager.getBiome(this.world, key, () -> this.biomeSource.method_38109(class_5742.method_33100((int)x), 316, class_5742.method_33100((int)z), this.noiseSampler));
    }

    private double terrainStabilityCost(int x, int z, int y) {
        int cost = 0;
        for (class_2350 d : class_2350.class_2353.field_11062) {
            int ny = this.sampleHeight(x + d.method_10148(), z + d.method_10165());
            if ((cost += Math.abs(y - ny)) <= 3) continue;
            return Double.MAX_VALUE;
        }
        return (double)cost * 16.0;
    }

    private List<class_2338> reconstructVertices(long goal, long start, Long2LongMap parent) {
        ArrayList<class_2338> vertices = new ArrayList<class_2338>();
        long k = goal;
        while (true) {
            class_2338 p = CacheManager.keyToPos(k);
            int y = this.sampleHeight(p.method_10263(), p.method_10260());
            vertices.add(new class_2338(p.method_10263(), y, p.method_10260()));
            if (k == start) break;
            k = parent.get(k);
        }
        Collections.reverse(vertices);
        return vertices;
    }

    private double computeAvgCostOfPathVertices(List<class_2338> path) {
        if (path.size() < 2) {
            return 0.0;
        }
        double sum = 0.0;
        int cnt = 0;
        for (int i = 1; i < path.size(); ++i) {
            class_2338 a = path.get(i - 1);
            class_2338 b = path.get(i);
            int dx = b.method_10263() - a.method_10263();
            int dz = b.method_10260() - a.method_10260();
            int ay = a.method_10264();
            int by = b.method_10264();
            int[] off = new int[]{dx, dz};
            double inc = PathFinder.stepCost(off) + PathFinder.elevationCost(ay, by) + PathFinder.biomeCost(this.sampleBiome(b.method_10263(), b.method_10260(), by)) + PathFinder.yLevelCost(by) + this.sampleStability(b.method_10263(), b.method_10260(), by);
            if (inc == Double.MAX_VALUE) continue;
            sum += inc;
            ++cnt;
        }
        return cnt > 0 ? sum / (double)cnt : 0.0;
    }

    private void logProfile(ProfileSession ps) {
        boolean suggestable;
        if (ps == null) {
            return;
        }
        double avgStepAll = ps.relaxationsAccepted > 0L ? ps.sumStepCosts / (double)ps.relaxationsAccepted : 0.0;
        double suggested = 0.0;
        boolean bl = suggestable = ps.pathFound && ps.avgStepOnPath > 0.0;
        if (suggestable) {
            double base = ps.avgStepOnPath;
            suggested = Math.max(80.0, Math.min(120.0, base));
        }
        double progress = ps.initialL1 > 0 ? (double)(ps.initialL1 - Math.min(ps.bestL1, ps.initialL1)) / (double)ps.initialL1 : 0.0;
        LOGGER.debug("[A* profiler] {} -> {}\n  iterations={}  neighbors={}  relaxations={}\n  calls: height={}  biome={}  stability={}\n  avg-step: path={}  all-relaxations={}\n  localScale={}\n  convergence: L1_start={}  L1_best={}  progress={}%  stallIters={}  bestF={}  stepCap={}  hitCap={}\n  {}\n", new Object[]{ps.start.method_23854(), ps.goal.method_23854(), ps.iterations, ps.neighborsChecked, ps.relaxationsAccepted, this.profHeightCalls, this.profBiomeCalls, this.profStabCalls, String.format(Locale.ROOT, "%.2f", ps.avgStepOnPath), String.format(Locale.ROOT, "%.2f", avgStepAll), String.format(Locale.ROOT, "%.1f", ps.localScale), ps.initialL1, ps.bestL1 == Integer.MAX_VALUE ? -1 : ps.bestL1, String.format(Locale.ROOT, "%.1f", progress * 100.0), ps.stallIters, String.format(Locale.ROOT, "%.1f", ps.bestF), ps.stepCap, ps.hitCap, suggestable ? "suggest HEURISTIC_SCALE \u2248 " + String.format(Locale.ROOT, "%.1f", suggested) : "no suggestion (path not found)"});
    }

    private static final class ProfileSession {
        final class_2338 start;
        final class_2338 goal;
        int iterations = 0;
        long neighborsChecked = 0L;
        long relaxationsAccepted = 0L;
        double sumStepCosts = 0.0;
        double avgStepOnPath = 0.0;
        boolean pathFound = false;
        double localScale = 95.0;
        int initialL1 = 0;
        int bestL1 = Integer.MAX_VALUE;
        int lastL1 = 0;
        int stallIters = 0;
        double bestF = Double.POSITIVE_INFINITY;
        int stepCap = 0;
        boolean hitCap = false;

        ProfileSession(class_2338 start, class_2338 goal) {
            this.start = start;
            this.goal = goal;
            this.lastL1 = this.initialL1 = Math.abs(start.method_10263() - goal.method_10263()) + Math.abs(start.method_10260() - goal.method_10260());
        }
    }
}

