/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.StreamSupport;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7066;
import net.minecraft.class_7924;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.storage.RoadGraphState;
import net.oxcodsnet.roadarchitect.storage.components.Node;
import net.oxcodsnet.roadarchitect.util.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StructureLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect" + StructureLocator.class.getSimpleName()));
    private static final DynamicCommandExceptionType INVALID_STRUCTURE_EXCEPTION = new DynamicCommandExceptionType(id -> class_2561.method_43469((String)"commands.locate.structure.invalid", (Object[])new Object[]{id}));

    private StructureLocator() {
    }

    public static List<Pair<class_2338, String>> scanGridAsync(class_3218 world, class_2338 origin, int overallRadius, int scanRadius, List<String> structureSelectors) {
        List<Pair<class_2338, String>> list = StructureLocator.performGridScan(world, origin, overallRadius, scanRadius, structureSelectors);
        StructureLocator.schedulePersistence(world, list);
        return list;
    }

    private static List<Pair<class_2338, String>> performGridScan(class_3218 world, class_2338 origin, int overallRadius, int scanRadius, List<String> structureSelectors) {
        int step = scanRadius * 2 + 1;
        int originChunkX = origin.method_10263() >> 4;
        int originChunkZ = origin.method_10260() >> 4;
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        List<Pair<class_2338, String>> allFound = Collections.synchronizedList(new ArrayList());
        for (int dx = -overallRadius; dx <= overallRadius; dx += step) {
            for (int dz = -overallRadius; dz <= overallRadius; dz += step) {
                int chunkX = originChunkX + dx;
                int chunkZ = originChunkZ + dz;
                StructureLocator.scanCell(world, origin, chunkX, chunkZ, scanRadius, structureSelectors, seen, allFound);
            }
        }
        return allFound;
    }

    private static void scanCell(class_3218 world, class_2338 origin, int chunkX, int chunkZ, int scanRadius, List<String> structureSelectors, Set<class_2338> seen, List<Pair<class_2338, String>> out) {
        class_2338.class_2339 scanOrigin = new class_2338.class_2339((chunkX << 4) + 8, origin.method_10264(), (chunkZ << 4) + 8);
        List<Pair<class_2338, String>> local = StructureLocator.findStructures(world, scanOrigin.method_10062(), scanRadius, structureSelectors);
        class_2338.class_2339 tmp = new class_2338.class_2339();
        for (Pair<class_2338, String> pair : local) {
            class_2338 p = (class_2338)pair.getFirst();
            int y = CacheManager.getHeight(world, p.method_10263(), p.method_10260());
            tmp.method_10103(p.method_10263(), y, p.method_10260());
            class_2338 key = tmp.method_10062();
            if (!seen.add(key)) continue;
            out.add((Pair<class_2338, String>)Pair.of((Object)key, (Object)((String)pair.getSecond())));
        }
    }

    private static List<Pair<class_2338, String>> findStructures(class_3218 world, class_2338 origin, int radius, List<String> structureSelectors) {
        ArrayList<Pair<class_2338, String>> foundPositions = new ArrayList<Pair<class_2338, String>>();
        class_2378 registry = world.method_30349().method_30530(class_7924.field_41246);
        for (String selector : structureSelectors) {
            try {
                class_7066 argType = new class_7066(class_7924.field_41246);
                class_7066.class_7068 predicate = argType.method_41164(new StringReader(selector));
                class_6885<class_3195> structList = StructureLocator.getStructureList((class_7066.class_7068<class_3195>)predicate, (class_2378<class_3195>)registry).orElseThrow(() -> INVALID_STRUCTURE_EXCEPTION.create((Object)selector));
                Pair located = world.method_14178().method_12129().method_12103(world, structList, origin, radius, true);
                if (located == null) continue;
                class_2960 id = registry.method_10221((Object)((class_3195)((class_6880)located.getSecond()).comp_349()));
                foundPositions.add((Pair<class_2338, String>)Pair.of((Object)((class_2338)located.getFirst()), (Object)String.valueOf(id)));
            }
            catch (CommandSyntaxException ex) {
                LOGGER.error("Selector '{}' failed: {}", (Object)selector, (Object)ex.getMessage());
            }
        }
        return foundPositions;
    }

    private static void schedulePersistence(class_3218 world, List<Pair<class_2338, String>> found) {
        RoadGraphState graph = RoadGraphState.get(world, RoadArchitect.CONFIG.maxConnectionDistance());
        for (Pair<class_2338, String> pair : found) {
            Node node = graph.addNodeWithEdges((class_2338)pair.getFirst(), (String)pair.getSecond());
            LOGGER.debug("Added node {} at {}", (Object)node.id(), (Object)node.pos());
        }
        graph.method_80();
    }

    private static Optional<? extends class_6885<class_3195>> getStructureList(class_7066.class_7068<class_3195> predicate, class_2378<class_3195> registry) {
        return (Optional)predicate.method_41173().map(key -> registry.method_10223(key.method_29177()).map(xva$0 -> class_6885.method_40246((class_6880[])new class_6880[]{xva$0})), tag -> {
            List entries = StreamSupport.stream(registry.method_40286(tag).spliterator(), false).toList();
            return Optional.of(class_6885.method_40242(entries));
        });
    }
}

