/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.worldgen;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6880;
import net.oxcodsnet.roadarchitect.storage.PathStorage;
import net.oxcodsnet.roadarchitect.storage.RoadBuilderStorage;
import net.oxcodsnet.roadarchitect.worldgen.RoadFeatureConfig;
import net.oxcodsnet.roadarchitect.worldgen.style.RoadStyle;
import net.oxcodsnet.roadarchitect.worldgen.style.RoadStyles;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.BuoyDecoration;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.Decoration;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.FenceDecoration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoadFeature
extends class_3031<RoadFeatureConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect/RoadFeature");
    private static final BuoyDecoration BUOY = new BuoyDecoration();
    private static final int BUOY_INTERVAL = 18;
    private static final int[][] OFFSETS_8 = new int[][]{{-1, -1}, {0, -1}, {1, -1}, {-1, 0}, {1, 0}, {-1, 1}, {0, 1}, {1, 1}};

    public RoadFeature(Codec<RoadFeatureConfig> codec) {
        super(codec);
    }

    private static void buildRoadStripe(class_5281 world, List<class_2338> pts, int halfWidth, class_5819 random) {
        for (int i = 0; i < pts.size(); ++i) {
            class_2338 p = pts.get(i);
            if (!RoadFeature.isNotWaterBlock(world, p)) continue;
            int prevIdx = Math.max(0, i - 2);
            int nextIdx = Math.min(pts.size() - 1, i + 2);
            class_243 dir = new class_243((double)(pts.get(nextIdx).method_10263() - pts.get(prevIdx).method_10263()), 0.0, (double)(pts.get(nextIdx).method_10260() - pts.get(prevIdx).method_10260())).method_1029();
            double nx = dir.field_1352;
            double nz = dir.field_1350;
            boolean diagonal = Math.abs(nx) > 0.001 && Math.abs(nz) > 0.001;
            for (int dx = -halfWidth; dx <= halfWidth; ++dx) {
                for (int dz = -halfWidth; dz <= halfWidth; ++dz) {
                    boolean inside;
                    double dist = Math.abs((double)dx * nz - (double)dz * nx);
                    boolean bl = inside = dist <= (double)halfWidth + 0.01 || diagonal && Math.max(Math.abs(dx), Math.abs(dz)) <= halfWidth;
                    if (!inside) continue;
                    class_2338 roadPos = p.method_10069(dx, 0, dz);
                    if (!RoadFeature.isNotWaterBlock(world, p) || RoadFeature.isWaterSegment(world, roadPos)) continue;
                    class_6880 biome = world.method_23753(roadPos);
                    RoadStyle style = RoadStyles.forBiome((class_6880<class_1959>)biome);
                    class_2680 roadState = style.palette().pick(random);
                    RoadFeature.placeRoad(world, roadPos, roadState);
                }
            }
            if (random.method_43048(15) != 0) continue;
            RoadFeature.decorateSide(world, p, nx, nz, halfWidth, random);
        }
    }

    private static void decorateSide(class_5281 world, class_2338 center, double nx, double nz, int halfWidth, class_5819 random) {
        int side = random.method_43056() ? 1 : -1;
        int sx = (int)Math.round(-nz * (double)side);
        int sz = (int)Math.round(nx * (double)side);
        int fx = (int)Math.round(nx);
        int fz = (int)Math.round(nz);
        class_6880 biome = world.method_23753(center);
        RoadStyle style = RoadStyles.forBiome((class_6880<class_1959>)biome);
        int length = 1 + random.method_43048(3);
        Decoration deco = style.decoration();
        if (deco instanceof FenceDecoration) {
            FenceDecoration fence = (FenceDecoration)deco;
            ArrayList<class_2338> stripe = new ArrayList<class_2338>();
            for (int j = 0; j < length; ++j) {
                stripe.add(center.method_10069(sx * (halfWidth + 1) + fx * j, 0, sz * (halfWidth + 1) + fz * j));
            }
            fence.placeFenceStripe(world, stripe);
        } else {
            for (int j = 0; j < length; ++j) {
                deco.place(world, center.method_10069(sx * (halfWidth + 1) + fx * j, 0, sz * (halfWidth + 1) + fz * j), random);
            }
        }
    }

    private static void placeRoad(class_5281 world, class_2338 pos, class_2680 stateRoad) {
        world.method_8652(pos, stateRoad, 1);
    }

    private static boolean isWaterSegment(class_5281 world, class_2338 pos) {
        if (RoadFeature.isNotWaterBlock(world, pos)) {
            return false;
        }
        for (int[] d : OFFSETS_8) {
            class_2338 neighbor = pos.method_10069(d[0], 0, d[1]);
            if (!RoadFeature.isNotWaterBlock(world, neighbor)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNotWaterBlock(class_5281 world, class_2338 pos) {
        return !world.method_8320(pos).method_26227().method_15767(class_3486.field_15517);
    }

    public boolean method_13151(class_5821<RoadFeatureConfig> ctx) {
        class_3218 serverWorld = ctx.method_33652().method_8410();
        if (serverWorld == null) {
            return false;
        }
        class_5281 world = ctx.method_33652();
        class_1923 chunk = new class_1923(ctx.method_33655());
        RoadBuilderStorage builder = RoadBuilderStorage.get(serverWorld);
        PathStorage paths = PathStorage.get(serverWorld);
        ArrayList<RoadBuilderStorage.SegmentEntry> queue = new ArrayList<RoadBuilderStorage.SegmentEntry>(builder.getSegments(chunk));
        if (queue.isEmpty()) {
            return false;
        }
        int halfWidth = Math.max(0, ((RoadFeatureConfig)ctx.method_33656()).orthWidth() / 2);
        class_5819 random = world.method_8409();
        boolean placedAny = false;
        for (RoadBuilderStorage.SegmentEntry entry : queue) {
            String[] ids = entry.pathKey().split("\\|", 2);
            if (ids.length != 2) {
                LOGGER.warn("Malformed path key '{}'; skipping", (Object)entry.pathKey());
                builder.removeSegment(chunk, entry);
                continue;
            }
            List<class_2338> pts = paths.getPath(ids[0], ids[1]);
            if (pts.isEmpty()) {
                builder.removeSegment(chunk, entry);
                continue;
            }
            int from = Math.max(0, entry.start());
            int to = Math.min(pts.size(), entry.end());
            ArrayList<class_2338> landPts = new ArrayList<class_2338>();
            class_2338 lastBuoyPos = null;
            for (int i = from; i < to; ++i) {
                class_2338 p = pts.get(i);
                if (RoadFeature.isNotWaterBlock(world, p)) {
                    lastBuoyPos = null;
                    landPts.add(p);
                    continue;
                }
                if (!RoadFeature.isWaterSegment(world, p)) continue;
                boolean farEnough = false;
                if (lastBuoyPos == null) {
                    farEnough = true;
                } else {
                    long dz;
                    long dx = p.method_10263() - lastBuoyPos.method_10263();
                    long dist2 = dx * dx + (dz = (long)(p.method_10260() - lastBuoyPos.method_10260())) * dz;
                    boolean bl = farEnough = dist2 >= 324L;
                }
                if (!farEnough) continue;
                BUOY.place(world, p, random);
                lastBuoyPos = p;
            }
            RoadFeature.buildRoadStripe(world, landPts, halfWidth, random);
            builder.removeSegment(chunk, entry);
            placedAny = true;
        }
        return placedAny;
    }
}

