/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.worldgen.style.decoration;

import java.util.List;
import net.minecraft.class_10225;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.Decoration;

public final class FenceDecoration
implements Decoration {
    private static final int MAX_SUPPORT_DEPTH = 3;
    private final class_2680 fenceState;

    public FenceDecoration(class_2680 fenceState) {
        this.fenceState = fenceState;
    }

    @Override
    public void place(class_5281 world, class_2338 basePos, class_5819 random) {
        class_2338 top = basePos.method_10084();
        int worldTop = world.method_31607() + world.method_31605() - 1;
        while (!world.method_22347(top) && top.method_10264() < worldTop) {
            top = top.method_10084();
        }
        if (!world.method_22347(top)) {
            return;
        }
        int depth = 0;
        class_2338 probe = top.method_10074();
        while (probe.method_10264() >= world.method_31607() && !world.method_8320(probe).method_26212((class_1922)world, probe)) {
            if (++depth > 3) {
                return;
            }
            probe = probe.method_10074();
        }
        this.setFenceSmart(world, top);
        class_2338 current = top.method_10074();
        while (current.method_10264() >= world.method_31607() && !world.method_8320(current).method_26212((class_1922)world, current)) {
            this.setFenceSmart(world, current);
            current = current.method_10074();
        }
    }

    private void setFenceSmart(class_5281 world, class_2338 pos) {
        class_2338 head = pos;
        for (int i = 0; i < 3 && !world.method_8320(head).method_45474(); ++i) {
            head = head.method_10084();
        }
        if (!world.method_8320(head).method_45474()) {
            return;
        }
        world.method_8652(head, this.fenceState, 4);
        class_2338 leg = head.method_10074();
        int i = 0;
        while (i < 3 && world.method_8320(leg).method_45474()) {
            world.method_8652(leg, this.fenceState, 4);
            ++i;
            leg = leg.method_10074();
        }
    }

    public void placeFenceStripe(class_5281 world, List<class_2338> stripe) {
        for (class_2338 p : stripe) {
            this.setFenceSmart(world, p);
        }
        class_5819 random = class_5819.method_43047();
        for (class_2338 p : stripe) {
            class_2680 st = world.method_8320(p);
            for (class_2350 d : class_2350.class_2353.field_11062) {
                class_2338 n = p.method_10093(d);
                st = st.method_26191((class_4538)world, (class_10225)world, p, d, n, world.method_8320(n), random);
            }
            world.method_8652(p, st, 4);
        }
    }
}

