/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.client.gui;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_340;
import net.minecraft.class_5348;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.util.CacheManager;

public final class CacheDebugOverlayRenderer {
    private static final Method SYSTEM_INFO_METHOD;

    private CacheDebugOverlayRenderer() {
    }

    public static void render(class_332 graphics) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        if (!RoadArchitect.CONFIG.debugCacheOverlay()) {
            return;
        }
        if (mc.field_1705 == null || !mc.field_1705.method_53531().method_53536()) {
            return;
        }
        List<class_2561> lines = CacheDebugOverlayRenderer.collectLines(mc);
        if (lines.isEmpty()) {
            return;
        }
        int x = graphics.method_51421() - 4;
        int y = CacheDebugOverlayRenderer.computeRightColumnTop(mc);
        for (class_2561 line : lines) {
            int width = mc.field_1772.method_27525((class_5348)line);
            graphics.method_51439(mc.field_1772, line, x - width, y, 16746860, false);
            Objects.requireNonNull(mc.field_1772);
            y += 9;
        }
    }

    public static List<class_2561> collectLines(class_310 mc) {
        if (mc == null || mc.field_1687 == null) {
            return List.of();
        }
        if (!RoadArchitect.CONFIG.debugCacheOverlay()) {
            return List.of();
        }
        if (mc.method_1576() == null) {
            return List.of(class_2561.method_43470((String)"RoadArchitect cache: remote server"));
        }
        class_3218 serverLevel = mc.method_1576().method_3847(mc.field_1687.method_27983());
        if (serverLevel == null) {
            return List.of(class_2561.method_43470((String)"RoadArchitect cache: world unavailable"));
        }
        CacheManager.CacheStats stats = CacheManager.stats(serverLevel);
        if (!stats.available()) {
            return List.of(class_2561.method_43470((String)"RoadArchitect cache: inactive"));
        }
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        class_2960 dimensionId = serverLevel.method_27983().method_29177();
        lines.add((class_2561)class_2561.method_43470((String)("RoadArchitect cache (" + String.valueOf(dimensionId) + ")")));
        lines.add((class_2561)class_2561.method_43470((String)("  runtime: " + CacheDebugOverlayRenderer.formatUsage(stats.runtimeUsedBytes(), stats.runtimeBudgetBytes()))));
        lines.add((class_2561)class_2561.method_43470((String)("  snapshots: " + CacheDebugOverlayRenderer.formatUsage(stats.snapshotUsedBytes(), stats.snapshotBudgetBytes()))));
        lines.add((class_2561)class_2561.method_43470((String)("  pages: " + CacheDebugOverlayRenderer.formatUsage(stats.persistedUsedBytes(), stats.persistedBudgetBytes()))));
        lines.add((class_2561)class_2561.method_43470((String)("  prefill: " + (stats.prefillEnabled() ? "ON" : "OFF") + " limit=" + stats.prefillMaxChunks())));
        return lines;
    }

    private static int computeRightColumnTop(class_310 mc) {
        try {
            Objects.requireNonNull(mc.field_1772);
            int lineHeight = 9;
            List<String> existing = CacheDebugOverlayRenderer.getSystemInformation(mc);
            if (!existing.isEmpty()) {
                return 2 + existing.size() * lineHeight + 2;
            }
            return 2;
        }
        catch (Throwable ignored) {
            return 48;
        }
    }

    private static List<String> getSystemInformation(class_310 mc) throws ReflectiveOperationException {
        if (SYSTEM_INFO_METHOD == null || mc.field_1705 == null) {
            return List.of();
        }
        class_340 overlay = mc.field_1705.method_53531();
        return (List)SYSTEM_INFO_METHOD.invoke((Object)overlay, new Object[0]);
    }

    private static String formatUsage(long usedBytes, long budgetBytes) {
        double used = CacheDebugOverlayRenderer.bytesToMiB(usedBytes);
        double budget = CacheDebugOverlayRenderer.bytesToMiB(budgetBytes);
        double pct = budgetBytes > 0L ? (double)usedBytes / (double)budgetBytes * 100.0 : 0.0;
        return String.format(Locale.ROOT, "%.1f / %.1f MiB (%.0f%%)", used, budget, pct);
    }

    private static double bytesToMiB(long value) {
        return (double)value / 1024.0 / 1024.0;
    }

    static {
        Method m = null;
        try {
            m = class_340.class.getDeclaredMethod("getSystemInformation", new Class[0]);
            m.setAccessible(true);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        SYSTEM_INFO_METHOD = m;
    }
}

