/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.oxcodsnet.roadarchitect.storage.EdgeStorage;
import net.oxcodsnet.roadarchitect.storage.PathStorage;
import net.oxcodsnet.roadarchitect.storage.RoadGraphState;
import net.oxcodsnet.roadarchitect.util.AsyncExecutor;
import net.oxcodsnet.roadarchitect.util.PathFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathFinderManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect/PathFinderManager");

    public static void computePaths(class_3218 world, int preFillCacheZone, int maxSteps) {
        RoadGraphState graph = RoadGraphState.get(world);
        PathStorage storage = PathStorage.get(world);
        PathFinder finder = new PathFinder(graph.nodes(), world, maxSteps);
        ArrayList<CompletableFuture<PathJob>> futures = new ArrayList<CompletableFuture<PathJob>>();
        for (Map.Entry<String, EdgeStorage.Status> entry : graph.edges().allWithStatus().entrySet()) {
            if (entry.getValue() != EdgeStorage.Status.NEW) continue;
            String edgeId = entry.getKey();
            String[] nodes = edgeId.split("\\+", 2);
            if (nodes.length != 2) {
                LOGGER.debug("Invalid edge id: {}", (Object)edgeId);
                continue;
            }
            String from = nodes[0];
            String to = nodes[1];
            CompletableFuture<PathJob> job = AsyncExecutor.submit(() -> {
                long start = System.nanoTime();
                List<class_2338> path = finder.findPath(from, to);
                double ms = (double)(System.nanoTime() - start) / 1000000.0;
                return new PathJob(edgeId, from, to, path, ms);
            });
            futures.add(job);
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        for (CompletableFuture completableFuture : futures) {
            try {
                PathJob job = (PathJob)completableFuture.get();
                PathStorage.Status st = job.path().isEmpty() ? PathStorage.Status.FAILED : PathStorage.Status.PENDING;
                storage.putPath(job.from(), job.to(), job.path(), st);
                if (!job.path().isEmpty()) {
                    graph.edges().setStatus(job.edgeId(), EdgeStorage.Status.SUCCESS);
                    LOGGER.debug(">>> Computed path {} ({} ms)", (Object)job.edgeId(), (Object)job.durationMs());
                    continue;
                }
                graph.edges().setStatus(job.edgeId(), EdgeStorage.Status.FAILURE);
                LOGGER.debug("! No path for {} ({} ms)", (Object)job.edgeId(), (Object)job.durationMs());
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("Path computation failed", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        storage.method_80();
        graph.method_80();
        LOGGER.debug("Path calculation completed for world {}", (Object)world.method_27983().method_29177());
    }

    public static void computePaths(class_3218 world) {
        PathFinderManager.computePaths(world, 50, 10480);
    }

    public static void computePaths(class_3218 world, int preFillCacheZone) {
        PathFinderManager.computePaths(world, preFillCacheZone, 10480);
    }

    private record PathJob(String edgeId, String from, String to, List<class_2338> path, double durationMs) {
    }
}

