/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1959;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.oxcodsnet.roadarchitect.util.PersistentStateUtil;

public class CacheStorage
extends class_18 {
    private static final String KEY = "road_cache";
    private static final String HEIGHTS_KEY = "heights";
    private static final String STABILITIES_KEY = "stabilities";
    private static final String BIOMES_KEY = "biomes";
    private static final String ENTRY_KEY = "k";
    private static final String ENTRY_VALUE = "v";
    public static final class_10741<CacheStorage> TYPE = new class_10741("road_cache", ctx -> new CacheStorage(), ctx -> class_2487.field_25128.xmap(tag -> CacheStorage.fromNbt(tag, (class_7225.class_7874)ctx.comp_3639().method_30349()), storage -> storage.writeNbt(new class_2487(), (class_7225.class_7874)ctx.comp_3639().method_30349())), class_4284.field_45083);
    private final ConcurrentMap<Long, Integer> heights = new ConcurrentHashMap<Long, Integer>();
    private final ConcurrentMap<Long, Double> stabilities = new ConcurrentHashMap<Long, Double>();
    private final ConcurrentMap<Long, class_6880<class_1959>> biomes = new ConcurrentHashMap<Long, class_6880<class_1959>>();

    public static CacheStorage get(class_3218 world) {
        return PersistentStateUtil.get(world, TYPE);
    }

    public static CacheStorage fromNbt(class_2487 tag, class_7225.class_7874 lookup) {
        CacheStorage storage = new CacheStorage();
        class_2499 hList = tag.method_68569(HEIGHTS_KEY);
        for (int i = 0; i < hList.size(); ++i) {
            class_2487 entry = hList.method_68582(i);
            long k = entry.method_68080(ENTRY_KEY, 0L);
            int v = entry.method_68083(ENTRY_VALUE, 0);
            storage.heights.put(k, v);
        }
        class_2499 sList = tag.method_68569(STABILITIES_KEY);
        for (int i = 0; i < sList.size(); ++i) {
            class_2487 entry = sList.method_68582(i);
            long k = entry.method_68080(ENTRY_KEY, 0L);
            double v = entry.method_68563(ENTRY_VALUE, 0.0);
            storage.stabilities.put(k, v);
        }
        class_2499 bList = tag.method_68569(BIOMES_KEY);
        class_7225.class_7226 registry = lookup == null ? null : lookup.method_46762(class_7924.field_41236);
        for (int i = 0; i < bList.size(); ++i) {
            class_2487 entry = bList.method_68582(i);
            class_2960 id = class_2960.method_12829((String)entry.method_68564(ENTRY_VALUE, ""));
            if (id == null || registry == null) continue;
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)id);
            registry.method_46746(key).ifPresent(e -> storage.biomes.put(entry.method_68080(ENTRY_KEY, 0L), (class_6880<class_1959>)e));
        }
        return storage;
    }

    public class_2487 writeNbt(class_2487 tag, class_7225.class_7874 lookup) {
        class_2499 hList = new class_2499();
        for (Map.Entry entry : this.heights.entrySet()) {
            class_2487 class_24872 = new class_2487();
            class_24872.method_10544(ENTRY_KEY, ((Long)entry.getKey()).longValue());
            class_24872.method_10569(ENTRY_VALUE, ((Integer)entry.getValue()).intValue());
            hList.add((Object)class_24872);
        }
        tag.method_10566(HEIGHTS_KEY, (class_2520)hList);
        class_2499 sList = new class_2499();
        for (Map.Entry entry : this.stabilities.entrySet()) {
            class_2487 elem = new class_2487();
            elem.method_10544(ENTRY_KEY, ((Long)entry.getKey()).longValue());
            elem.method_10549(ENTRY_VALUE, ((Double)entry.getValue()).doubleValue());
            sList.add((Object)elem);
        }
        tag.method_10566(STABILITIES_KEY, (class_2520)sList);
        class_2499 class_24992 = new class_2499();
        for (Map.Entry entry : this.biomes.entrySet()) {
            class_2960 id = ((class_6880)entry.getValue()).method_40230().map(class_5321::method_29177).orElse(null);
            if (id == null) continue;
            class_2487 elem = new class_2487();
            elem.method_10544(ENTRY_KEY, ((Long)entry.getKey()).longValue());
            elem.method_10582(ENTRY_VALUE, id.toString());
            class_24992.add((Object)elem);
        }
        tag.method_10566(BIOMES_KEY, (class_2520)class_24992);
        return tag;
    }

    public ConcurrentMap<Long, Integer> heights() {
        return this.heights;
    }

    public ConcurrentMap<Long, Double> stabilities() {
        return this.stabilities;
    }

    public ConcurrentMap<Long, class_6880<class_1959>> biomes() {
        return this.biomes;
    }
}

