/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1959;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.oxcodsnet.roadarchitect.util.NbtUtils;
import net.oxcodsnet.roadarchitect.util.PersistentStateUtil;

public class CacheStorage
extends class_18 {
    private static final String KEY = "road_cache";
    private static final String HEIGHTS_KEY = "heights";
    private static final String STABILITIES_KEY = "stabilities";
    private static final String BIOMES_KEY = "biomes";
    private static final String ENTRY_KEY = "k";
    private static final String ENTRY_VALUE = "v";
    public static final class_10741<CacheStorage> TYPE = new class_10741("road_cache", ctx -> new CacheStorage(), ctx -> class_2487.field_25128.xmap(tag -> CacheStorage.fromNbt(tag, (class_7225.class_7874)ctx.comp_3639().method_30349()), storage -> storage.writeNbt(new class_2487(), (class_7225.class_7874)ctx.comp_3639().method_30349())), class_4284.field_45083);
    private final ConcurrentMap<Long, Integer> heights = new ConcurrentHashMap<Long, Integer>();
    private final ConcurrentMap<Long, Double> stabilities = new ConcurrentHashMap<Long, Double>();
    private final ConcurrentMap<Long, class_6880<class_1959>> biomes = new ConcurrentHashMap<Long, class_6880<class_1959>>();

    public static CacheStorage get(class_3218 world) {
        return PersistentStateUtil.get(world, TYPE);
    }

    public static CacheStorage fromNbt(class_2487 tag, class_7225.class_7874 lookup) {
        class_7225.class_7226 registry;
        CacheStorage storage = new CacheStorage();
        class_2499 hList = tag.method_68569(HEIGHTS_KEY);
        NbtUtils.fillLongIntMap(hList, storage.heights);
        class_2499 sList = tag.method_68569(STABILITIES_KEY);
        NbtUtils.fillLongDoubleMap(sList, storage.stabilities);
        class_2499 bList = tag.method_68569(BIOMES_KEY);
        HashMap<Long, String> biomeIds = new HashMap<Long, String>(bList.size());
        NbtUtils.fillLongStringMap(bList, biomeIds);
        class_7225.class_7226 class_72262 = registry = lookup == null ? null : lookup.method_46762(class_7924.field_41236);
        if (registry != null) {
            for (Map.Entry<Long, String> entry : biomeIds.entrySet()) {
                class_2960 id = class_2960.method_12829((String)entry.getValue());
                if (id == null) continue;
                class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)id);
                registry.method_46746(key).ifPresent(regEntry -> storage.biomes.put((Long)entry.getKey(), (class_6880<class_1959>)regEntry));
            }
        }
        return storage;
    }

    public class_2487 writeNbt(class_2487 tag, class_7225.class_7874 lookup) {
        tag.method_10566(HEIGHTS_KEY, (class_2520)NbtUtils.toLongIntList(this.heights));
        tag.method_10566(STABILITIES_KEY, (class_2520)NbtUtils.toLongDoubleList(this.stabilities));
        HashMap<Long, String> biomeIds = new HashMap<Long, String>(this.biomes.size());
        for (Map.Entry entry : this.biomes.entrySet()) {
            class_2960 id = ((class_6880)entry.getValue()).method_40230().map(class_5321::method_29177).orElse(null);
            if (id == null) continue;
            biomeIds.put((Long)entry.getKey(), id.toString());
        }
        tag.method_10566(BIOMES_KEY, (class_2520)NbtUtils.toLongStringList(biomeIds));
        return tag;
    }

    public ConcurrentMap<Long, Integer> heights() {
        return this.heights;
    }

    public ConcurrentMap<Long, Double> stabilities() {
        return this.stabilities;
    }

    public ConcurrentMap<Long, class_6880<class_1959>> biomes() {
        return this.biomes;
    }
}

