/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.oxcodsnet.roadarchitect.handlers.RoadBuilderManager;
import net.oxcodsnet.roadarchitect.storage.PathStorage;
import net.oxcodsnet.roadarchitect.util.AsyncExecutor;
import net.oxcodsnet.roadarchitect.util.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoadPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect/RoadPostProcessor");
    private static final int TOLERANCE_BLOCKS = 45;
    private static final int ANGLE_THRESHOLD_DEG = 35;
    private static final int TAIL_ANGLE_MAX_DEG = 35;
    private static final double AVG_DIST_FACTOR = 1.5;
    private static final double SCORE_LIMIT = 50.0;
    private static final int MAX_ITER = 5;
    private static final boolean UNTIL_STABLE = true;
    private static final int TRIM_RADIUS_L1 = 50;
    private static final int SMOOTH_MEDIAN_WINDOW = 5;
    private static final int SMOOTH_GRAD_MAX = 1;
    private static final int SMOOTH_PASSES = 2;
    private static final int DESPIKE_DELTA = 2;
    private static final boolean LOG_GRAD_CLAMP = true;

    private RoadPostProcessor() {
    }

    public static void register() {
        ServerTickEvents.START_WORLD_TICK.register(world -> {
            if (world.method_8608()) {
                return;
            }
            if (world.method_27983() != class_1937.field_25179) {
                return;
            }
            RoadPostProcessor.processPending(world);
        });
    }

    private static int manhattanXZ(class_2338 a, class_2338 b) {
        return Math.abs(a.method_10263() - b.method_10263()) + Math.abs(a.method_10260() - b.method_10260());
    }

    private static List<class_2338> trimByManhattan(List<class_2338> path) {
        int j;
        int i;
        if (path == null || path.size() < 2) {
            return path;
        }
        class_2338 start0 = path.getFirst();
        class_2338 end0 = path.getLast();
        for (i = 0; i < path.size() && RoadPostProcessor.manhattanXZ(path.get(i), start0) <= 50; ++i) {
        }
        for (j = path.size() - 1; j >= 0 && RoadPostProcessor.manhattanXZ(path.get(j), end0) <= 50; --j) {
        }
        if (i <= 0 && j >= path.size() - 1) {
            return path;
        }
        if (j - i + 1 < 2) {
            return path;
        }
        return new ArrayList<class_2338>(path.subList(i, j + 1));
    }

    private static List<class_2338> refine(class_3218 world, List<class_2338> verts) {
        if (verts.isEmpty()) {
            return List.of();
        }
        ArrayList<class_2338> out = new ArrayList<class_2338>(verts.size() * 4);
        for (int i = 0; i < verts.size() - 1; ++i) {
            class_2338 a = verts.get(i);
            class_2338 b = verts.get(i + 1);
            out.add(a.method_10074());
            RoadPostProcessor.interpolate(world, a, b, out);
        }
        out.add(verts.getLast().method_10074());
        return out;
    }

    private static void interpolate(class_3218 world, class_2338 a, class_2338 b, List<class_2338> out) {
        int dx = Integer.signum(b.method_10263() - a.method_10263());
        int dz = Integer.signum(b.method_10260() - a.method_10260());
        int steps = Math.max(Math.abs(b.method_10263() - a.method_10263()), Math.abs(b.method_10260() - a.method_10260()));
        for (int i = 1; i < steps; ++i) {
            int nx = a.method_10263() + dx * i;
            int nz = a.method_10260() + dz * i;
            int ny = CacheManager.getHeight(world, nx, nz) - 1;
            out.add(new class_2338(nx, ny, nz));
        }
    }

    private static NormalizeResult normalizeHeights(List<class_2338> refined) {
        int i;
        if (refined.size() < 3) {
            return new NormalizeResult(refined, 0, 0);
        }
        int n = refined.size();
        int[] y = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            y[i2] = refined.get(i2).method_10264();
        }
        int spikes = 0;
        int clamps = 0;
        for (int pass = 0; pass < 2; ++pass) {
            int clamped;
            int hi;
            int r = 2;
            int[] tmp = Arrays.copyOf(y, n);
            int[] win = new int[5];
            for (int i3 = 0; i3 < n; ++i3) {
                int s = Math.max(0, i3 - r);
                int e = Math.min(n - 1, i3 + r);
                int k = 0;
                for (int j = s; j <= e; ++j) {
                    win[k++] = y[j];
                }
                while (k < win.length) {
                    win[k] = i3 < r ? y[0] : y[n - 1];
                    ++k;
                }
                Arrays.sort(win);
                tmp[i3] = win[win.length / 2];
            }
            y = tmp;
            for (i = 1; i < n; ++i) {
                int lo = y[i - 1] - 1;
                hi = y[i - 1] + 1;
                int old = y[i];
                clamped = Math.max(lo, Math.min(hi, old));
                if (clamped == old) continue;
                ++clamps;
                class_2338 p = refined.get(i);
                LOGGER.debug("[PostProcess] Clamp\u2191 at {}: {} -> {} (ref={})", new Object[]{p, old, clamped, y[i - 1]});
                y[i] = clamped;
            }
            for (i = n - 2; i >= 0; --i) {
                int lo = y[i + 1] - 1;
                hi = y[i + 1] + 1;
                int old = y[i];
                clamped = Math.max(lo, Math.min(hi, old));
                if (clamped == old) continue;
                ++clamps;
                class_2338 p = refined.get(i);
                LOGGER.debug("[PostProcess] Clamp\u2193 at {}: {} -> {} (ref={})", new Object[]{p, old, clamped, y[i + 1]});
                y[i] = clamped;
            }
            for (i = 1; i < n - 1; ++i) {
                int neu;
                int a = y[i - 1];
                int b = y[i + 1];
                int m = Math.max(a, b);
                if (y[i] - m < 2) continue;
                class_2338 p = refined.get(i);
                int old = y[i];
                y[i] = neu = (a + b) / 2;
                ++spikes;
                LOGGER.warn("[PostProcess] \u0421\u0440\u0435\u0437\u0430\u043d \u043f\u0438\u043a \u0432\u044b\u0441\u043e\u0442\u044b \u0432 {}: {} -> {} (\u0441\u043e\u0441\u0435\u0434\u0438: {}/{})", new Object[]{p, old, neu, a, b});
            }
        }
        ArrayList<class_2338> out = new ArrayList<class_2338>(n);
        for (i = 0; i < n; ++i) {
            class_2338 p = refined.get(i);
            out.add(new class_2338(p.method_10263(), y[i], p.method_10260()));
        }
        return new NormalizeResult(out, spikes, clamps);
    }

    public static void processPending(class_3218 world) {
        PathStorage storage = PathStorage.get(world);
        for (Map.Entry<String, PathStorage.Status> e : storage.allStatuses().entrySet()) {
            if (e.getValue() != PathStorage.Status.PENDING) continue;
            RoadPostProcessor.schedule(world, storage, e.getKey());
            break;
        }
    }

    private static void processChunk(class_3218 world, class_1923 chunk) {
        PathStorage storage = PathStorage.get(world);
        for (String key : storage.getPendingForChunk(chunk)) {
            RoadPostProcessor.schedule(world, storage, key);
        }
    }

    private static void schedule(class_3218 world, PathStorage storage, String baseKey) {
        if (!storage.tryMarkProcessing(baseKey)) {
            return;
        }
        List<class_2338> baseRawInitial = storage.getPath(baseKey);
        AsyncExecutor.execute(() -> {
            String activeKey = baseKey;
            List<class_2338> activeRaw = new ArrayList<class_2338>(baseRawInitial);
            activeRaw = RoadPostProcessor.trimByManhattan(activeRaw);
            HashSet<String> partnersMarked = new HashSet<String>();
            HashSet<String> becameReady = new HashSet<String>();
            HashMap<String, List<class_2338>> toBuild = new HashMap<String, List<class_2338>>();
            try {
                boolean changed;
                int iter = 0;
                do {
                    changed = false;
                    ++iter;
                    MergeCandidate cand = RoadPostProcessor.findBestParallelPartner(storage, activeKey, activeRaw);
                    if (cand == null) break;
                    if (!storage.tryMarkProcessing(cand.otherKey)) continue;
                    partnersMarked.add(cand.otherKey);
                    List<class_2338> otherRaw = storage.getPath(cand.otherKey);
                    otherRaw = RoadPostProcessor.trimByManhattan(otherRaw);
                    Convergence conv = RoadPostProcessor.findConvergence(activeRaw, otherRaw);
                    if (conv == null) {
                        storage.setStatus(cand.otherKey, PathStorage.Status.PENDING);
                        partnersMarked.remove(cand.otherKey);
                        continue;
                    }
                    BuildResult br = RoadPostProcessor.buildY(world, activeKey, activeRaw, cand.otherKey, otherRaw, conv);
                    for (Map.Entry<String, List<class_2338>> leg : br.legsRaw.entrySet()) {
                        List<class_2338> refined = RoadPostProcessor.refine(world, leg.getValue());
                        NormalizeResult nr = RoadPostProcessor.normalizeHeights(refined);
                        storage.updatePath(leg.getKey(), nr.path(), PathStorage.Status.READY);
                        toBuild.put(leg.getKey(), nr.path());
                        if (!nr.path().isEmpty()) {
                            class_2338 s = nr.path().getFirst();
                            class_2338 t = nr.path().getLast();
                            LOGGER.debug("[PostProcess] READY (leg) key={} points={}, spikesCut={}, gradClamped={}, start={}, end={}", new Object[]{leg.getKey(), nr.path().size(), nr.spikesCut(), nr.gradClamped(), s, t});
                        }
                        becameReady.add(leg.getKey());
                    }
                    List<class_2338> trunkRefined = RoadPostProcessor.refine(world, br.trunkRaw.path);
                    NormalizeResult trunkNR = RoadPostProcessor.normalizeHeights(trunkRefined);
                    storage.updatePath(br.trunkRaw.key, trunkNR.path(), PathStorage.Status.READY);
                    toBuild.put(br.trunkRaw.key, trunkNR.path());
                    if (!trunkNR.path().isEmpty()) {
                        class_2338 s = trunkNR.path().getFirst();
                        class_2338 t = trunkNR.path().getLast();
                        LOGGER.debug("[PostProcess] READY (trunk) key={} points={}, spikesCut={}, gradClamped={}, start={}, end={}", new Object[]{br.trunkRaw.key, trunkNR.path().size(), trunkNR.spikesCut(), trunkNR.gradClamped(), s, t});
                    }
                    becameReady.add(br.trunkRaw.key);
                    activeKey = br.trunkRaw.key;
                    activeRaw = br.trunkRaw.path;
                    changed = true;
                } while (iter < 5 && (changed || iter == 1));
                if (toBuild.isEmpty()) {
                    List<class_2338> refined = RoadPostProcessor.refine(world, activeRaw);
                    NormalizeResult nr = RoadPostProcessor.normalizeHeights(refined);
                    storage.updatePath(activeKey, nr.path(), PathStorage.Status.READY);
                    toBuild.put(activeKey, nr.path());
                    if (!nr.path().isEmpty()) {
                        class_2338 s = nr.path().getFirst();
                        class_2338 t = nr.path().getLast();
                        LOGGER.debug("[PostProcess] READY (single) key={} points={}, spikesCut={}, gradClamped={}, start={}, end={}", new Object[]{activeKey, nr.path().size(), nr.spikesCut(), nr.gradClamped(), s, t});
                    }
                    becameReady.add(activeKey);
                }
                RoadBuilderManager.queueSegments(world, toBuild);
            }
            catch (Exception ex) {
                LOGGER.error("Post-processing failed for {}", (Object)baseKey, (Object)ex);
                storage.setStatus(baseKey, PathStorage.Status.FAILED);
                for (String p : partnersMarked) {
                    if (becameReady.contains(p)) continue;
                    storage.setStatus(p, PathStorage.Status.PENDING);
                }
                return;
            }
            for (String p : partnersMarked) {
                if (becameReady.contains(p) || storage.getStatus(p) != PathStorage.Status.PROCESSING) continue;
                storage.setStatus(p, PathStorage.Status.PENDING);
            }
        });
    }

    private static MergeCandidate findBestParallelPartner(PathStorage storage, String baseKey, List<class_2338> baseRaw) {
        AABB bbBase = AABB.of(baseRaw).inflate(90);
        double bestScore = Double.POSITIVE_INFINITY;
        String bestKey = null;
        for (Map.Entry<String, PathStorage.Status> e : storage.allStatuses().entrySet()) {
            double score;
            double minDist;
            double angle;
            AABB bbOther;
            List<class_2338> otherRaw;
            String otherKey;
            if (e.getValue() != PathStorage.Status.PENDING || (otherKey = e.getKey()).equals(baseKey) || (otherRaw = storage.getPath(otherKey)).size() < 2 || !bbBase.intersectsInflated(bbOther = AABB.of(otherRaw)) || (angle = RoadPostProcessor.angleDeg(RoadPostProcessor.dir(baseRaw), RoadPostProcessor.dir(otherRaw))) >= 35.0 || (minDist = RoadPostProcessor.minPointToPointDist(baseRaw, otherRaw)) >= 45.0 || !((score = angle + minDist * 0.5) < bestScore)) continue;
            bestScore = score;
            bestKey = otherKey;
        }
        return bestKey == null ? null : new MergeCandidate(bestKey, bestScore);
    }

    private static Convergence findConvergence(List<class_2338> a, List<class_2338> b) {
        int n = a.size();
        int m = b.size();
        if (n < 3 || m < 3) {
            return null;
        }
        double bestScore = Double.POSITIVE_INFINITY;
        int bestI = -1;
        int bestJ = -1;
        for (int i = 1; i < n - 1; ++i) {
            class_2338 ai = a.get(i);
            int jBest = -1;
            double dMin = Double.POSITIVE_INFINITY;
            for (int j = 1; j < m - 1; ++j) {
                double d = RoadPostProcessor.hypot2D(ai, b.get(j));
                if (!(d < dMin)) continue;
                dMin = d;
                jBest = j;
            }
            if (jBest <= 0 || dMin >= 90.0) continue;
            List<class_2338> tailA = a.subList(i, n);
            List<class_2338> tailB = b.subList(jBest, m);
            if (tailA.size() < 2 || tailB.size() < 2) continue;
            double angTail = RoadPostProcessor.angleDeg(RoadPostProcessor.dir(tailA), RoadPostProcessor.dir(tailB));
            double avgDist = RoadPostProcessor.minPointToPointDist(tailA, tailB);
            double score = angTail + avgDist / 10.0;
            if (!(angTail < 35.0) || !(avgDist < 67.5) || !(score < bestScore)) continue;
            bestScore = score;
            bestI = i;
            bestJ = jBest;
        }
        if (bestScore >= 50.0 || bestI < 0) {
            return null;
        }
        return new Convergence(bestI, bestJ);
    }

    private static BuildResult buildY(class_3218 world, String keyA, List<class_2338> a, String keyB, List<class_2338> b, Convergence conv) {
        String chosenKey;
        List<class_2338> chosenTail;
        class_2338 pa = a.get(conv.i);
        class_2338 pb = b.get(conv.j);
        int jx = (int)Math.round((double)(pa.method_10263() + pb.method_10263()) / 2.0);
        int jz = (int)Math.round((double)(pa.method_10260() + pb.method_10260()) / 2.0);
        int jy = CacheManager.getHeight(world, jx, jz);
        class_2338 J = new class_2338(jx, jy, jz);
        ArrayList<class_2338> legA = new ArrayList<class_2338>(a.subList(0, conv.i + 1));
        legA.set(legA.size() - 1, J);
        ArrayList<class_2338> legB = new ArrayList<class_2338>(b.subList(0, conv.j + 1));
        legB.set(legB.size() - 1, J);
        List<class_2338> tailA = a.subList(conv.i, a.size());
        List<class_2338> tailB = b.subList(conv.j, b.size());
        if (tailA.size() > tailB.size() || tailA.size() == tailB.size() && conv.i <= conv.j) {
            chosenTail = tailA;
            chosenKey = keyA;
        } else {
            chosenTail = tailB;
            chosenKey = keyB;
        }
        ArrayList<class_2338> trunk = new ArrayList<class_2338>(chosenTail.size());
        trunk.add(J);
        trunk.addAll(chosenTail.subList(1, chosenTail.size()));
        String trunkKey = chosenKey + "#J@" + jx + "," + jz;
        HashMap<String, List<class_2338>> legs = new HashMap<String, List<class_2338>>();
        legs.put(keyA, legA);
        legs.put(keyB, legB);
        return new BuildResult(legs, new Trunk(trunkKey, trunk));
    }

    private static double angleDeg(int[] v1, int[] v2) {
        double n1 = Math.hypot(v1[0], v1[1]);
        double n2 = Math.hypot(v2[0], v2[1]);
        if (n1 == 0.0 || n2 == 0.0) {
            return 180.0;
        }
        double dot = (double)(v1[0] * v2[0] + v1[1] * v2[1]) / (n1 * n2);
        dot = Math.max(-1.0, Math.min(1.0, dot));
        double ang = Math.toDegrees(Math.acos(dot));
        return Math.min(ang, 180.0 - ang);
    }

    private static int[] dir(List<class_2338> pts) {
        class_2338 s = pts.getFirst();
        class_2338 e = pts.getLast();
        return new int[]{e.method_10263() - s.method_10263(), e.method_10260() - s.method_10260()};
    }

    private static double minPointToPointDist(List<class_2338> a, List<class_2338> b) {
        double min = Double.POSITIVE_INFINITY;
        for (class_2338 pa : a) {
            for (class_2338 pb : b) {
                double d = RoadPostProcessor.hypot2D(pa, pb);
                if (!(d < min)) continue;
                min = d;
            }
        }
        return min;
    }

    private static double hypot2D(class_2338 p1, class_2338 p2) {
        int dx = p1.method_10263() - p2.method_10263();
        int dz = p1.method_10260() - p2.method_10260();
        return Math.hypot(dx, dz);
    }

    private record NormalizeResult(List<class_2338> path, int spikesCut, int gradClamped) {
    }

    private record AABB(int x1, int z1, int x2, int z2) {
        static AABB of(List<class_2338> pts) {
            int minX = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            for (class_2338 p : pts) {
                if (p.method_10263() < minX) {
                    minX = p.method_10263();
                }
                if (p.method_10260() < minZ) {
                    minZ = p.method_10260();
                }
                if (p.method_10263() > maxX) {
                    maxX = p.method_10263();
                }
                if (p.method_10260() <= maxZ) continue;
                maxZ = p.method_10260();
            }
            return new AABB(minX, minZ, maxX, maxZ);
        }

        AABB inflate(int r) {
            return new AABB(this.x1 - r, this.z1 - r, this.x2 + r, this.z2 + r);
        }

        boolean intersectsInflated(AABB other) {
            return this.x1 <= other.x2 && this.x2 >= other.x1 && this.z1 <= other.z2 && this.z2 >= other.z1;
        }
    }

    private record MergeCandidate(String otherKey, double score) {
    }

    private record Convergence(int i, int j) {
    }

    private static final class BuildResult {
        final Map<String, List<class_2338>> legsRaw;
        final Trunk trunkRaw;

        BuildResult(Map<String, List<class_2338>> legsRaw, Trunk trunkRaw) {
            this.legsRaw = legsRaw;
            this.trunkRaw = trunkRaw;
        }
    }

    private record Trunk(String key, List<class_2338> path) {
    }
}

