/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.util;

import java.util.Map;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public final class NbtUtils {
    private static final String K = "k";
    private static final String V = "v";

    private NbtUtils() {
    }

    public static <E extends Enum<E>> E getEnumOrDefault(CompoundTag tag, String key, Class<E> type, E def) {
        String raw = tag.getStringOr(key, "");
        try {
            return raw.isEmpty() ? def : Enum.valueOf(type, raw);
        }
        catch (IllegalArgumentException ex) {
            return def;
        }
    }

    public static ListTag toDoubleList(double[] values) {
        ListTag list = new ListTag();
        if (values == null) {
            return list;
        }
        for (double v : values) {
            list.add((Object)DoubleTag.valueOf((double)v));
        }
        return list;
    }

    public static double[] readDoubleList(ListTag list) {
        if (list == null || list.isEmpty()) {
            return new double[0];
        }
        double[] out = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Tag el = list.get(i);
            if (el instanceof DoubleTag) {
                DoubleTag d = (DoubleTag)el;
                out[i] = d.doubleValue();
                continue;
            }
            out[i] = 0.0;
        }
        return out;
    }

    public static ListTag toByteList(byte[] values) {
        ListTag list = new ListTag();
        if (values == null) {
            return list;
        }
        for (byte b : values) {
            list.add((Object)ByteTag.valueOf((byte)b));
        }
        return list;
    }

    public static byte[] readByteList(ListTag list) {
        if (list == null || list.isEmpty()) {
            return new byte[0];
        }
        byte[] out = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Tag el = list.get(i);
            if (el instanceof ByteTag) {
                ByteTag b = (ByteTag)el;
                out[i] = b.byteValue();
                continue;
            }
            out[i] = 0;
        }
        return out;
    }

    public static ListTag toLongIntList(Map<Long, Integer> map) {
        ListTag list = new ListTag();
        for (Map.Entry<Long, Integer> e : map.entrySet()) {
            CompoundTag elem = new CompoundTag();
            elem.putLong(K, e.getKey().longValue());
            elem.putInt(V, e.getValue().intValue());
            list.add((Object)elem);
        }
        return list;
    }

    public static void fillLongIntMap(ListTag list, Map<Long, Integer> out) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag elem = list.getCompoundOrEmpty(i);
            out.put(elem.getLongOr(K, 0L), elem.getIntOr(V, 0));
        }
    }

    public static ListTag toLongDoubleList(Map<Long, Double> map) {
        ListTag list = new ListTag();
        for (Map.Entry<Long, Double> e : map.entrySet()) {
            CompoundTag elem = new CompoundTag();
            elem.putLong(K, e.getKey().longValue());
            elem.putDouble(V, e.getValue().doubleValue());
            list.add((Object)elem);
        }
        return list;
    }

    public static void fillLongDoubleMap(ListTag list, Map<Long, Double> out) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag elem = list.getCompoundOrEmpty(i);
            out.put(elem.getLongOr(K, 0L), elem.getDoubleOr(V, 0.0));
        }
    }

    public static ListTag toLongStringList(Map<Long, String> map) {
        ListTag list = new ListTag();
        for (Map.Entry<Long, String> e : map.entrySet()) {
            CompoundTag elem = new CompoundTag();
            elem.putLong(K, e.getKey().longValue());
            elem.putString(V, e.getValue());
            list.add((Object)elem);
        }
        return list;
    }

    public static void fillLongStringMap(ListTag list, Map<Long, String> out) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag elem = list.getCompoundOrEmpty(i);
            out.put(elem.getLongOr(K, 0L), elem.getStringOr(V, ""));
        }
    }
}

