/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.util.Objects;
import net.minecraft.class_1959;
import net.minecraft.class_6880;

final class ColumnRecord {
    static final ColumnRecord EMPTY = new ColumnRecord(null, null, null);
    private final Integer height;
    private final Double stability;
    private final class_6880<class_1959> biome;

    ColumnRecord(Integer height, Double stability, class_6880<class_1959> biome) {
        this.height = height;
        this.stability = stability;
        this.biome = biome;
    }

    Integer height() {
        return this.height;
    }

    boolean hasHeight() {
        return this.height != null;
    }

    Double stability() {
        return this.stability;
    }

    boolean hasStability() {
        return this.stability != null;
    }

    class_6880<class_1959> biome() {
        return this.biome;
    }

    boolean hasBiome() {
        return this.biome != null;
    }

    ColumnRecord withHeight(int value) {
        if (Objects.equals(this.height, value)) {
            return this;
        }
        return new ColumnRecord(value, this.stability, this.biome);
    }

    ColumnRecord withStability(double value) {
        if (Objects.equals(this.stability, value)) {
            return this;
        }
        return new ColumnRecord(this.height, value, this.biome);
    }

    ColumnRecord withBiome(class_6880<class_1959> value) {
        if (Objects.equals(this.biome, value)) {
            return this;
        }
        return new ColumnRecord(this.height, this.stability, value);
    }

    boolean isEmpty() {
        return this.height == null && this.stability == null && this.biome == null;
    }

    int weightBytes() {
        int weight = 16;
        if (this.height != null) {
            weight += 8;
        }
        if (this.stability != null) {
            weight += 16;
        }
        if (this.biome != null) {
            weight += 48;
        }
        return weight;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ColumnRecord)) {
            return false;
        }
        ColumnRecord other = (ColumnRecord)obj;
        return Objects.equals(this.height, other.height) && Objects.equals(this.stability, other.stability) && Objects.equals(this.biome, other.biome);
    }

    public int hashCode() {
        return Objects.hash(this.height, this.stability, this.biome);
    }
}

