/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_7225;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.storage.EdgeStorage;
import net.oxcodsnet.roadarchitect.storage.NodeStorage;
import net.oxcodsnet.roadarchitect.storage.components.Node;
import net.oxcodsnet.roadarchitect.util.GeometryUtils;
import net.oxcodsnet.roadarchitect.util.KeyUtil;
import net.oxcodsnet.roadarchitect.util.PersistentStateUtil;

public class RoadGraphState
extends class_18 {
    private static final String KEY = "road_graph";
    private static final String NODES_KEY = "nodes";
    private static final String EDGES_KEY = "edges";
    private static final String RADIUS_KEY = "radius";
    public static final class_10741<RoadGraphState> TYPE = new class_10741("road_graph", ctx -> new RoadGraphState(RoadArchitect.CONFIG.maxConnectionDistance()), ctx -> class_2487.field_25128.xmap(tag -> RoadGraphState.fromNbt(tag, (class_7225.class_7874)ctx.comp_3639().method_30349()), state -> state.writeNbt(new class_2487(), (class_7225.class_7874)ctx.comp_3639().method_30349())), class_4284.field_45083);
    private final NodeStorage nodeStorage;
    private final EdgeStorage edgeStorage;

    public RoadGraphState(double radius) {
        this(new NodeStorage(), new EdgeStorage(radius));
    }

    private RoadGraphState(NodeStorage nodes, EdgeStorage edges) {
        this.nodeStorage = nodes;
        this.edgeStorage = edges;
    }

    public static RoadGraphState get(class_3218 world) {
        return PersistentStateUtil.get(world, TYPE);
    }

    public static RoadGraphState fromNbt(class_2487 tag, class_7225.class_7874 lookup) {
        double radius = tag.method_68563(RADIUS_KEY, 0.0);
        NodeStorage nodes = NodeStorage.fromNbt(tag.method_68569(NODES_KEY));
        EdgeStorage edges = EdgeStorage.fromNbt(tag.method_68568(EDGES_KEY), radius);
        return new RoadGraphState(nodes, edges);
    }

    public NodeStorage nodes() {
        return this.nodeStorage;
    }

    public EdgeStorage edges() {
        return this.edgeStorage;
    }

    public Node addNodeWithEdges(class_2338 pos, String type) {
        Node newNode = this.nodeStorage.add(pos, type);
        for (Node other : this.nodeStorage.all().values()) {
            if (other.id().equals(newNode.id())) continue;
            this.connect(newNode, other);
        }
        this.method_80();
        return newNode;
    }

    public void connect(Node nodeA, Node nodeB) {
        double max;
        double dz;
        String idNodeB;
        if (nodeA == null || nodeB == null) {
            return;
        }
        String idNodeA = nodeA.id();
        if (idNodeA.equals(idNodeB = nodeB.id())) {
            return;
        }
        double dx = nodeA.pos().method_10263() - nodeB.pos().method_10263();
        if (dx * dx + (dz = (double)(nodeA.pos().method_10260() - nodeB.pos().method_10260())) * dz > (max = this.edgeStorage.radius() * 2.0) * max) {
            return;
        }
        if (this.edgeStorage.all().containsKey(KeyUtil.edgeKey(idNodeA, idNodeB))) {
            return;
        }
        for (EdgeStorage.Edge e : this.edgeStorage.all().values()) {
            if (e.connects(idNodeA) || e.connects(idNodeB)) continue;
            Node n1 = this.nodeStorage.all().get(e.nodeA());
            Node n2 = this.nodeStorage.all().get(e.nodeB());
            if (n1 == null || n2 == null || !GeometryUtils.segmentsIntersect2D(nodeA.pos(), nodeB.pos(), n1.pos(), n2.pos())) continue;
            return;
        }
        boolean added = this.edgeStorage.add(nodeA, nodeB);
        if (added) {
            this.method_80();
        }
    }

    public class_2487 writeNbt(class_2487 tag, class_7225.class_7874 lookup) {
        tag.method_10549(RADIUS_KEY, this.edgeStorage.radius());
        tag.method_10566(NODES_KEY, (class_2520)this.nodeStorage.toNbt());
        tag.method_10566(EDGES_KEY, (class_2520)this.edgeStorage.toNbt());
        return tag;
    }
}

