/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.client.gui;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_340;
import net.minecraft.class_5348;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.util.CacheManager;
import net.oxcodsnet.roadarchitect.util.DebugLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheDebugOverlayRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect/CacheDebugOverlayRenderer");
    private static final Method SYSTEM_INFO_METHOD;
    private static final int TEXT_COLOR = -30356;
    private static boolean loggedActive;
    private static boolean loggedEmpty;
    private static boolean positionLogged;

    private CacheDebugOverlayRenderer() {
    }

    public static void render(class_332 graphics) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        if (!RoadArchitect.CONFIG.debugCacheOverlay()) {
            return;
        }
        if (mc.field_1705 == null || !mc.field_1705.method_53531().method_53536()) {
            return;
        }
        List<class_2561> lines = CacheDebugOverlayRenderer.collectLines(mc);
        if (lines.isEmpty()) {
            CacheDebugOverlayRenderer.logEmpty();
            return;
        }
        CacheDebugOverlayRenderer.logActive(lines.size(), graphics.method_51421(), graphics.method_51443());
        int x = graphics.method_51421() - 4;
        int y = CacheDebugOverlayRenderer.computeRightColumnTop(mc);
        CacheDebugOverlayRenderer.logPosition(x, y);
        for (class_2561 line : lines) {
            int width = mc.field_1772.method_27525((class_5348)line);
            graphics.method_51439(mc.field_1772, line, x - width, y, -30356, false);
            Objects.requireNonNull(mc.field_1772);
            y += 9;
        }
    }

    public static List<class_2561> collectLines(class_310 mc) {
        if (mc == null || mc.field_1687 == null) {
            return List.of();
        }
        if (!RoadArchitect.CONFIG.debugCacheOverlay()) {
            return List.of();
        }
        if (mc.method_1576() == null) {
            return List.of(class_2561.method_43470((String)"RoadArchitect cache: remote server"));
        }
        class_3218 serverLevel = mc.method_1576().method_3847(mc.field_1687.method_27983());
        if (serverLevel == null) {
            return List.of(class_2561.method_43470((String)"RoadArchitect cache: world unavailable"));
        }
        CacheManager.CacheStats stats = CacheManager.stats(serverLevel);
        if (!stats.available()) {
            return List.of(class_2561.method_43470((String)"RoadArchitect cache: inactive"));
        }
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        class_2960 dimensionId = serverLevel.method_27983().method_29177();
        lines.add((class_2561)class_2561.method_43470((String)("RoadArchitect cache (" + String.valueOf(dimensionId) + ")")));
        lines.add((class_2561)class_2561.method_43470((String)("  runtime: " + CacheDebugOverlayRenderer.formatUsage(stats.runtimeUsedBytes(), stats.runtimeBudgetBytes()))));
        lines.add((class_2561)class_2561.method_43470((String)("  snapshots: " + CacheDebugOverlayRenderer.formatUsage(stats.snapshotUsedBytes(), stats.snapshotBudgetBytes()))));
        lines.add((class_2561)class_2561.method_43470((String)("  pages: " + CacheDebugOverlayRenderer.formatUsage(stats.persistedUsedBytes(), stats.persistedBudgetBytes()))));
        lines.add((class_2561)class_2561.method_43470((String)("  prefill: " + (stats.prefillEnabled() ? "ON" : "OFF") + " limit=" + stats.prefillMaxChunks())));
        return lines;
    }

    private static void logEmpty() {
        if (!loggedEmpty && DebugLog.isEnabled()) {
            LOGGER.info("Cache debug overlay skipped: no lines to render (config={}, levelLoaded={})", (Object)RoadArchitect.CONFIG.debugCacheOverlay(), (Object)(class_310.method_1551() != null && class_310.method_1551().field_1687 != null ? 1 : 0));
            loggedEmpty = true;
        }
    }

    private static void logActive(int lineCount, int width, int height) {
        if (!loggedActive && DebugLog.isEnabled()) {
            LOGGER.info("Cache debug overlay rendering {} line(s) at {}x{} surface", new Object[]{lineCount, width, height});
            loggedActive = true;
        }
    }

    private static void logPosition(int x, int y) {
        if (!DebugLog.isEnabled() || !loggedActive || positionLogged) {
            return;
        }
        LOGGER.info("Cache debug overlay start position: x={} y={}", (Object)x, (Object)y);
        positionLogged = true;
    }

    private static int computeRightColumnTop(class_310 mc) {
        try {
            Objects.requireNonNull(mc.field_1772);
            int lineHeight = 9;
            List<String> existing = CacheDebugOverlayRenderer.getSystemInformation(mc);
            if (!existing.isEmpty()) {
                return 2 + existing.size() * lineHeight + 2;
            }
            return 2;
        }
        catch (Throwable ignored) {
            return 48;
        }
    }

    private static List<String> getSystemInformation(class_310 mc) throws ReflectiveOperationException {
        if (SYSTEM_INFO_METHOD == null || mc.field_1705 == null) {
            return List.of();
        }
        class_340 overlay = mc.field_1705.method_53531();
        return (List)SYSTEM_INFO_METHOD.invoke((Object)overlay, new Object[0]);
    }

    private static String formatUsage(long usedBytes, long budgetBytes) {
        double used = CacheDebugOverlayRenderer.bytesToMiB(usedBytes);
        double budget = CacheDebugOverlayRenderer.bytesToMiB(budgetBytes);
        double pct = budgetBytes > 0L ? (double)usedBytes / (double)budgetBytes * 100.0 : 0.0;
        return String.format(Locale.ROOT, "%.1f / %.1f MiB (%.0f%%)", used, budget, pct);
    }

    private static double bytesToMiB(long value) {
        return (double)value / 1024.0 / 1024.0;
    }

    static {
        Method m = null;
        try {
            m = class_340.class.getDeclaredMethod("getSystemInformation", new Class[0]);
            m.setAccessible(true);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        SYSTEM_INFO_METHOD = m;
    }
}

