/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.handlers;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3449;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.handlers.PipelineRunner;
import net.oxcodsnet.roadarchitect.util.DebugLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoadPipelineController {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + RoadPipelineController.class.getSimpleName()));
    private static final Set<class_5321<class_1937>> INITIALIZED = ConcurrentHashMap.newKeySet();
    private static final Set<class_2960> TARGET_IDS = new HashSet<class_2960>();
    private static final Set<class_6862<class_3195>> TARGET_TAGS = new HashSet<class_6862<class_3195>>();
    private static final Set<class_2960> TARGET_DIMENSION_IDS = new HashSet<class_2960>();
    private static int tickCounter = 0;

    private RoadPipelineController() {
    }

    public static void init() {
        RoadPipelineController.cacheStructureSelectors();
        tickCounter = 0;
        DebugLog.info(LOGGER, "RoadPipelineController initialized (selectors cached)", new Object[0]);
    }

    public static void refreshStructureSelectorCache() {
        RoadPipelineController.cacheStructureSelectors();
        DebugLog.info(LOGGER, "RoadPipelineController reloaded selectors from config", new Object[0]);
    }

    public static void onSpawnChunkGenerated(class_3218 world, class_2791 chunk) {
        if (!RoadPipelineController.isDimensionEnabled((class_5321<class_1937>)world.method_27983())) {
            return;
        }
        class_1923 spawnChunk = new class_1923(world.method_43126());
        if (!chunk.method_12004().equals((Object)spawnChunk)) {
            return;
        }
        if (INITIALIZED.add((class_5321<class_1937>)world.method_27983())) {
            DebugLog.info(LOGGER, "Spawn chunk {} generated in {}, starting INIT pipeline", chunk.method_12004(), world.method_27983().method_29177());
            PipelineRunner.runPipeline(world, world.method_43126(), PipelineRunner.PipelineMode.INIT);
        }
    }

    public static void onChunkGenerated(class_3218 world, class_2791 chunk) {
        if (!RoadPipelineController.isDimensionEnabled((class_5321<class_1937>)world.method_27983())) {
            return;
        }
        if (!RoadPipelineController.containsTargetStructure(world, chunk)) {
            return;
        }
        class_2338 center = chunk.method_12004().method_33943(0);
        DebugLog.info(LOGGER, "Chunk {} generated with target structure, starting CHUNK pipeline", chunk.method_12004());
        PipelineRunner.runPipeline(world, center, PipelineRunner.PipelineMode.CHUNK);
    }

    public static void onPlayerJoin(class_3222 player) {
        class_3218 world = player.method_51469();
        if (!RoadPipelineController.isDimensionEnabled((class_5321<class_1937>)world.method_27983())) {
            return;
        }
        class_2338 pos = player.method_24515();
        DebugLog.info(LOGGER, "Player {} joined at {}, starting PERIODIC pipeline", player.method_5477().getString(), pos);
        PipelineRunner.runPipeline(world, pos, PipelineRunner.PipelineMode.PERIODIC);
    }

    public static void onServerTick(MinecraftServer server) {
        int intervalTicks = Math.max(1, RoadArchitect.CONFIG.pipelineIntervalSeconds() * 20);
        if (++tickCounter < intervalTicks) {
            return;
        }
        tickCounter = 0;
        for (class_3222 player : server.method_3760().method_14571()) {
            class_3218 w = player.method_51469();
            if (!RoadPipelineController.isDimensionEnabled((class_5321<class_1937>)w.method_27983())) continue;
            class_2338 pos = player.method_24515();
            DebugLog.info(LOGGER, "Periodic trigger at player {} pos {}, starting PERIODIC pipeline", player.method_5477().getString(), pos);
            PipelineRunner.runPipeline(w, pos, PipelineRunner.PipelineMode.PERIODIC);
        }
    }

    public static void onServerStopping() {
        INITIALIZED.clear();
        tickCounter = 0;
        DebugLog.info(LOGGER, "Server stopping, state cleared", new Object[0]);
    }

    private static void cacheStructureSelectors() {
        TARGET_IDS.clear();
        TARGET_TAGS.clear();
        List<String> selectors = RoadArchitect.CONFIG.structureSelectors();
        for (String sel : selectors) {
            if (sel.startsWith("#")) {
                TARGET_TAGS.add((class_6862<class_3195>)class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60654((String)sel.substring(1))));
                continue;
            }
            TARGET_IDS.add(class_2960.method_60654((String)sel));
        }
        TARGET_DIMENSION_IDS.clear();
        List<String> dimensionSelectors = RoadArchitect.CONFIG.dimensionSelectors();
        if (dimensionSelectors == null || dimensionSelectors.isEmpty()) {
            TARGET_DIMENSION_IDS.add(class_1937.field_25179.method_29177());
        } else {
            for (String selector : dimensionSelectors) {
                if (selector.startsWith("#")) {
                    LOGGER.warn("Dimension selector tags are not supported (skipping '{}')", (Object)selector);
                    continue;
                }
                try {
                    TARGET_DIMENSION_IDS.add(class_2960.method_60654((String)selector));
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warn("Skipping invalid dimension selector '{}': {}", (Object)selector, (Object)ex.getMessage());
                }
            }
            if (TARGET_DIMENSION_IDS.isEmpty()) {
                TARGET_DIMENSION_IDS.add(class_1937.field_25179.method_29177());
            }
        }
    }

    static boolean isDimensionEnabled(class_5321<class_1937> key) {
        if (TARGET_DIMENSION_IDS.isEmpty()) {
            return key == class_1937.field_25179;
        }
        return TARGET_DIMENSION_IDS.contains(key.method_29177());
    }

    private static boolean containsTargetStructure(class_3218 world, class_2791 chunk) {
        if (!chunk.method_38871()) {
            return false;
        }
        class_2378 registry = world.method_30349().method_30530(class_7924.field_41246);
        for (class_3449 start : chunk.method_12016().values()) {
            class_3195 structure = start.method_16656();
            class_2960 id = registry.method_10221((Object)structure);
            if (id != null && TARGET_IDS.contains(id)) {
                return true;
            }
            class_6880 entry = registry.method_47983((Object)structure);
            if (entry == null) continue;
            for (class_6862<class_3195> tag : TARGET_TAGS) {
                if (!entry.method_40220(tag)) continue;
                return true;
            }
        }
        return false;
    }
}

