/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_7225;
import net.oxcodsnet.roadarchitect.util.NbtUtils;
import net.oxcodsnet.roadarchitect.util.PersistentStateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PathDecorStorage
extends class_18 {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + PathDecorStorage.class.getSimpleName()));
    private static final String KEY = "road_path_decor";
    private static final String ENTRIES_KEY = "entries";
    private static final String PATH_KEY = "path";
    private static final String CHECKSUM_KEY = "sum";
    private static final String PREFIX_KEY = "S";
    private static final String GROUND_KEY = "G";
    private static final String WATER_INNER_KEY = "W";
    public static final class_10741<PathDecorStorage> TYPE = new class_10741("road_path_decor", ctx -> new PathDecorStorage(), ctx -> class_2487.field_25128.xmap(tag -> PathDecorStorage.fromNbt(tag, (class_7225.class_7874)ctx.comp_3639().method_30349()), storage -> storage.writeNbt(new class_2487(), (class_7225.class_7874)ctx.comp_3639().method_30349())), class_4284.field_45083);
    private final ConcurrentMap<String, double[]> prefix = new ConcurrentHashMap<String, double[]>();
    private final ConcurrentMap<String, byte[]> groundMask = new ConcurrentHashMap<String, byte[]>();
    private final ConcurrentMap<String, byte[]> waterInteriorMask = new ConcurrentHashMap<String, byte[]>();
    private final ConcurrentMap<String, Long> checksums = new ConcurrentHashMap<String, Long>();

    public static PathDecorStorage get(class_3218 world) {
        return PersistentStateUtil.get(world, TYPE);
    }

    public static PathDecorStorage fromNbt(class_2487 tag, class_7225.class_7874 lookup) {
        PathDecorStorage storage = new PathDecorStorage();
        class_2499 list = tag.method_68569(ENTRIES_KEY);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 e = list.method_68582(i);
            String key = e.method_68564(PATH_KEY, "");
            if (key.isEmpty()) continue;
            long sum = e.method_68080(CHECKSUM_KEY, 0L);
            storage.checksums.put(key, sum);
            double[] S = NbtUtils.readDoubleList(e.method_68569(PREFIX_KEY));
            storage.prefix.put(key, S);
            storage.groundMask.put(key, NbtUtils.readByteList(e.method_68569(GROUND_KEY)));
            storage.waterInteriorMask.put(key, NbtUtils.readByteList(e.method_68569(WATER_INNER_KEY)));
        }
        return storage;
    }

    public class_2487 writeNbt(class_2487 tag, class_7225.class_7874 lookup) {
        class_2499 out = new class_2499();
        for (Map.Entry e : this.prefix.entrySet()) {
            String key = (String)e.getKey();
            class_2487 obj = new class_2487();
            obj.method_10582(PATH_KEY, key);
            obj.method_10544(CHECKSUM_KEY, this.checksums.getOrDefault(key, 0L).longValue());
            obj.method_10566(PREFIX_KEY, (class_2520)NbtUtils.toDoubleList((double[])e.getValue()));
            obj.method_10566(GROUND_KEY, (class_2520)NbtUtils.toByteList((byte[])this.groundMask.get(key)));
            obj.method_10566(WATER_INNER_KEY, (class_2520)NbtUtils.toByteList((byte[])this.waterInteriorMask.get(key)));
            out.add((Object)obj);
        }
        tag.method_10566(ENTRIES_KEY, (class_2520)out);
        return tag;
    }

    public double[] getPrefix(String pathKey) {
        return (double[])this.prefix.get(pathKey);
    }

    public byte[] getGroundMask(String pathKey) {
        return (byte[])this.groundMask.get(pathKey);
    }

    public byte[] getWaterInteriorMask(String pathKey) {
        return (byte[])this.waterInteriorMask.get(pathKey);
    }

    public long getChecksum(String pathKey) {
        return this.checksums.getOrDefault(pathKey, 0L);
    }

    public void ensureCapacity(String pathKey, int n) {
        double[] S = (double[])this.prefix.get(pathKey);
        if (S == null || S.length != n) {
            this.prefix.put(pathKey, new double[n]);
            this.groundMask.put(pathKey, new byte[n]);
            this.waterInteriorMask.put(pathKey, new byte[n]);
            this.method_80();
        }
    }

    public void updateChecksum(String pathKey, long sum) {
        Long prev = this.checksums.put(pathKey, sum);
        if (prev == null || prev != sum) {
            this.method_80();
        }
    }

    public void setPrefix(String pathKey, double[] S) {
        this.prefix.put(pathKey, S);
        this.method_80();
    }

    public void clearMasks(String pathKey) {
        byte[] g = (byte[])this.groundMask.get(pathKey);
        byte[] w = (byte[])this.waterInteriorMask.get(pathKey);
        if (g != null) {
            Arrays.fill(g, (byte)0);
        }
        if (w != null) {
            Arrays.fill(w, (byte)0);
        }
        this.method_80();
    }

    public void touch() {
        this.method_80();
    }
}

