/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.worldgen.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.oxcodsnet.roadarchitect.config.RAConfig;
import net.oxcodsnet.roadarchitect.config.RAConfigHolder;
import net.oxcodsnet.roadarchitect.config.RoadDecorationType;
import net.oxcodsnet.roadarchitect.config.defaults.RoadStyleDefaults;
import net.oxcodsnet.roadarchitect.config.records.RoadStyleConfigEntry;
import net.oxcodsnet.roadarchitect.handlers.compat.BopCompat;
import net.oxcodsnet.roadarchitect.util.BiomeSelectorUtil;
import net.oxcodsnet.roadarchitect.worldgen.style.BlockPalette;
import net.oxcodsnet.roadarchitect.worldgen.style.RoadStyle;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.Decoration;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.FenceDecoration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoadStyles {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RoadArchitect/RoadStyles");
    private static final AtomicInteger VERSION = new AtomicInteger();
    private static final Map<Registry<Biome>, CacheEntry> CACHE = new ConcurrentHashMap<Registry<Biome>, CacheEntry>();
    private static volatile List<ParsedStyle> STYLES = List.of();
    private static volatile RoadStyle FALLBACK = RoadStyles.buildFallbackFromDefaults();

    private RoadStyles() {
    }

    public static RoadStyle forBiome(Registry<Biome> registry, Holder<Biome> biomeEntry) {
        if (registry == null || biomeEntry == null) {
            return FALLBACK;
        }
        CacheEntry cache = CACHE.compute(registry, (reg, existing) -> {
            int current = VERSION.get();
            if (existing != null && existing.version == current) {
                return existing;
            }
            ArrayList<CompiledStyle> compiled = new ArrayList<CompiledStyle>(STYLES.size());
            for (ParsedStyle parsed : STYLES) {
                List<String> selectors = parsed.selectors();
                List<HolderSet<Biome>> compiledSelectors = selectors.isEmpty() ? List.of() : BiomeSelectorUtil.compile((Registry<Biome>)reg, selectors);
                compiled.add(new CompiledStyle(parsed.style(), compiledSelectors));
            }
            return new CacheEntry(current, List.copyOf(compiled));
        });
        RoadStyle fallback = FALLBACK;
        for (CompiledStyle compiled : cache.styles()) {
            List<HolderSet<Biome>> selectors = compiled.selectors();
            if (selectors.isEmpty()) {
                fallback = compiled.style();
                continue;
            }
            if (!BiomeSelectorUtil.matches(biomeEntry, selectors)) continue;
            return compiled.style();
        }
        return fallback;
    }

    private static void reload(RAConfig config) {
        List<RoadStyleConfigEntry> bopOverrides;
        List<RoadStyleConfigEntry> entries = config.roadStyleOverrides();
        List<RoadStyleConfigEntry> baseSource = entries == null || entries.isEmpty() ? RoadStyleDefaults.entries() : entries;
        List<Object> bopEntries = List.of();
        if (BopCompat.isPresent() && (bopOverrides = config.bopRoadStyleOverrides()) != null && !bopOverrides.isEmpty()) {
            bopEntries = bopOverrides;
        }
        ArrayList<RoadStyleConfigEntry> source = new ArrayList<RoadStyleConfigEntry>(baseSource.size() + bopEntries.size());
        source.addAll(baseSource);
        source.addAll(bopEntries);
        ArrayList<ParsedStyle> parsed = new ArrayList<ParsedStyle>(source.size());
        RoadStyle fallback = null;
        for (RoadStyleConfigEntry entry : source) {
            if (entry == null) continue;
            RoadStyle style = RoadStyles.buildStyle(entry);
            if (style == null) {
                LOGGER.warn("Skipping road style override for selectors {} due to invalid palette", entry.biomeSelectors());
                continue;
            }
            parsed.add(new ParsedStyle(entry.biomeSelectors(), style));
            if (!entry.biomeSelectors().isEmpty()) continue;
            fallback = style;
        }
        if (fallback == null) {
            fallback = RoadStyles.buildFallbackFromDefaults();
        }
        STYLES = List.copyOf(parsed);
        FALLBACK = fallback;
        VERSION.incrementAndGet();
        CACHE.clear();
    }

    private static RoadStyle buildFallbackFromDefaults() {
        RoadStyleConfigEntry defaultEntry = RoadStyleDefaults.entries().getFirst();
        RoadStyle style = RoadStyles.buildStyle(defaultEntry);
        if (style != null) {
            return style;
        }
        BlockPalette palette = BlockPalette.builder().add(Blocks.GRASS_BLOCK.defaultBlockState(), 7).add(Blocks.DIRT_PATH.defaultBlockState(), 2).add(Blocks.COBBLESTONE.defaultBlockState(), 2).add(Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 1).add(Blocks.GRAVEL.defaultBlockState(), 1).build();
        return new RoadStyle(palette, List.of());
    }

    private static RoadStyle buildStyle(RoadStyleConfigEntry entry) {
        BlockPalette palette = RoadStyles.buildPalette(entry.palette());
        if (palette == null) {
            return null;
        }
        List<Decoration> decorations = RoadStyles.buildDecorations(entry.decorations());
        return new RoadStyle(palette, decorations);
    }

    private static BlockPalette buildPalette(List<RoadStyleConfigEntry.SurfaceBlockEntry> entries) {
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        BlockPalette.Builder builder = BlockPalette.builder();
        int added = 0;
        for (RoadStyleConfigEntry.SurfaceBlockEntry entry : entries) {
            String raw;
            int weight;
            if (entry == null || (weight = entry.weight()) <= 0 || (raw = entry.block()) == null || raw.isBlank()) continue;
            if (raw.startsWith("#")) {
                String tagName = raw.substring(1);
                ResourceLocation id = ResourceLocation.tryParse((String)tagName);
                if (id == null) {
                    LOGGER.warn("Road style palette tag '{}' is invalid", (Object)raw);
                    continue;
                }
                TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id);
                Optional optional = BuiltInRegistries.BLOCK.get(tag);
                if (optional.isEmpty()) {
                    LOGGER.warn("Road style palette tag '{}' resolved to nothing", (Object)raw);
                    continue;
                }
                HolderSet list = (HolderSet)optional.get();
                int before = added;
                for (Holder blockEntry : list) {
                    Block block = (Block)blockEntry.value();
                    builder.add(block.defaultBlockState(), weight);
                    ++added;
                }
                if (added != before) continue;
                LOGGER.warn("Road style palette tag '{}' had no resolvable blocks", (Object)raw);
                continue;
            }
            ResourceLocation id = ResourceLocation.tryParse((String)raw);
            if (id == null) {
                LOGGER.warn("Road style palette block '{}' is invalid", (Object)raw);
                continue;
            }
            Optional optional = BuiltInRegistries.BLOCK.getOptional(id);
            if (optional.isEmpty()) {
                LOGGER.warn("Road style palette block '{}' is not registered", (Object)raw);
                continue;
            }
            builder.add(((Block)optional.get()).defaultBlockState(), weight);
            ++added;
        }
        if (added == 0) {
            return null;
        }
        return builder.build();
    }

    private static List<Decoration> buildDecorations(List<RoadStyleConfigEntry.DecorationEntry> entries) {
        if (entries == null || entries.isEmpty()) {
            return List.of();
        }
        ArrayList<FenceDecoration> list = new ArrayList<FenceDecoration>();
        block4: for (RoadStyleConfigEntry.DecorationEntry entry : entries) {
            RoadDecorationType type;
            if (entry == null || (type = entry.type()) == null) continue;
            switch (type) {
                case FENCE: {
                    BlockState state = RoadStyles.resolveBlockState(entry.block(), "fence decoration");
                    if (state == null) continue block4;
                    list.add(new FenceDecoration(state));
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    LOGGER.warn("Unknown road decoration type '{}'", (Object)type.id());
                }
            }
        }
        return list.isEmpty() ? List.of() : List.copyOf(list);
    }

    private static BlockState resolveBlockState(String raw, String role) {
        if (raw == null || raw.isBlank()) {
            LOGGER.warn("Road style {} is empty", (Object)role);
            return null;
        }
        if (raw.startsWith("#")) {
            String tagName = raw.substring(1);
            ResourceLocation id = ResourceLocation.tryParse((String)tagName);
            if (id == null) {
                LOGGER.warn("Road style {} tag '{}' is invalid", (Object)role, (Object)raw);
                return null;
            }
            TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id);
            Optional optional = BuiltInRegistries.BLOCK.get(tag);
            if (optional.isEmpty()) {
                LOGGER.warn("Road style {} tag '{}' resolved to nothing", (Object)role, (Object)raw);
                return null;
            }
            HolderSet list = (HolderSet)optional.get();
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                Holder blockEntry = (Holder)iterator.next();
                return ((Block)blockEntry.value()).defaultBlockState();
            }
            LOGGER.warn("Road style {} tag '{}' had no blocks", (Object)role, (Object)raw);
            return null;
        }
        ResourceLocation id = ResourceLocation.tryParse((String)raw);
        if (id == null) {
            LOGGER.warn("Road style {} '{}' is invalid", (Object)role, (Object)raw);
            return null;
        }
        Optional optional = BuiltInRegistries.BLOCK.getOptional(id);
        if (optional.isEmpty()) {
            LOGGER.warn("Road style {} '{}' is not registered", (Object)role, (Object)raw);
            return null;
        }
        return ((Block)optional.get()).defaultBlockState();
    }

    static {
        RAConfigHolder.listen(RoadStyles::reload);
    }

    private record CacheEntry(int version, List<CompiledStyle> styles) {
    }

    private record CompiledStyle(RoadStyle style, List<HolderSet<Biome>> selectors) {
    }

    private record ParsedStyle(List<String> selectors, RoadStyle style) {
    }
}

