/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.oxcodsnet.roadarchitect.util.PersistentStateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PathDecorStorage
extends SavedData {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + PathDecorStorage.class.getSimpleName()));
    private static final String KEY = "road_path_decor";
    private static final String ENTRIES_KEY = "entries";
    private static final String PATH_KEY = "path";
    private static final String CHECKSUM_KEY = "sum";
    private static final String PREFIX_KEY = "S";
    private static final String GROUND_KEY = "G";
    private static final String WATER_INNER_KEY = "W";
    public static final SavedData.Factory<PathDecorStorage> TYPE = new SavedData.Factory(PathDecorStorage::new, PathDecorStorage::fromNbt, DataFixTypes.SAVED_DATA_SCOREBOARD);
    private final ConcurrentMap<String, double[]> prefix = new ConcurrentHashMap<String, double[]>();
    private final ConcurrentMap<String, byte[]> groundMask = new ConcurrentHashMap<String, byte[]>();
    private final ConcurrentMap<String, byte[]> waterInteriorMask = new ConcurrentHashMap<String, byte[]>();
    private final ConcurrentMap<String, Long> checksums = new ConcurrentHashMap<String, Long>();

    public static PathDecorStorage get(ServerLevel world) {
        return PersistentStateUtil.get(world, TYPE, KEY);
    }

    public static PathDecorStorage fromNbt(CompoundTag tag, HolderLookup.Provider lookup) {
        PathDecorStorage storage = new PathDecorStorage();
        ListTag list = tag.getList(ENTRIES_KEY, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag e = list.getCompound(i);
            String key = e.getString(PATH_KEY);
            long sum = e.getLong(CHECKSUM_KEY);
            storage.checksums.put(key, sum);
            ListTag sList = e.getList(PREFIX_KEY, 8);
            double[] S = new double[sList.size()];
            for (int j = 0; j < sList.size(); ++j) {
                S[j] = Double.parseDouble(sList.getString(j));
            }
            storage.prefix.put(key, S);
            storage.groundMask.put(key, PathDecorStorage.getByteArray(e, GROUND_KEY));
            storage.waterInteriorMask.put(key, PathDecorStorage.getByteArray(e, WATER_INNER_KEY));
        }
        return storage;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider lookup) {
        ListTag out = new ListTag();
        for (Map.Entry e : this.prefix.entrySet()) {
            double[] S;
            String key = (String)e.getKey();
            CompoundTag obj = new CompoundTag();
            obj.putString(PATH_KEY, key);
            obj.putLong(CHECKSUM_KEY, this.checksums.getOrDefault(key, 0L).longValue());
            ListTag sList = new ListTag();
            for (double v : S = (double[])e.getValue()) {
                sList.add((Object)StringTag.valueOf((String)Double.toString(v)));
            }
            obj.put(PREFIX_KEY, (Tag)sList);
            PathDecorStorage.putByteArray(obj, GROUND_KEY, (byte[])this.groundMask.get(key));
            PathDecorStorage.putByteArray(obj, WATER_INNER_KEY, (byte[])this.waterInteriorMask.get(key));
            out.add((Object)obj);
        }
        tag.put(ENTRIES_KEY, (Tag)out);
        return tag;
    }

    public double[] getPrefix(String pathKey) {
        return (double[])this.prefix.get(pathKey);
    }

    public byte[] getGroundMask(String pathKey) {
        return (byte[])this.groundMask.get(pathKey);
    }

    public byte[] getWaterInteriorMask(String pathKey) {
        return (byte[])this.waterInteriorMask.get(pathKey);
    }

    public long getChecksum(String pathKey) {
        return this.checksums.getOrDefault(pathKey, 0L);
    }

    public void ensureCapacity(String pathKey, int n) {
        double[] S = (double[])this.prefix.get(pathKey);
        if (S == null || S.length != n) {
            this.prefix.put(pathKey, new double[n]);
            this.groundMask.put(pathKey, new byte[n]);
            this.waterInteriorMask.put(pathKey, new byte[n]);
            this.setDirty();
        }
    }

    public void updateChecksum(String pathKey, long sum) {
        Long prev = this.checksums.put(pathKey, sum);
        if (prev == null || prev != sum) {
            this.setDirty();
        }
    }

    public void setPrefix(String pathKey, double[] S) {
        this.prefix.put(pathKey, S);
        this.setDirty();
    }

    public void clearMasks(String pathKey) {
        byte[] g = (byte[])this.groundMask.get(pathKey);
        byte[] w = (byte[])this.waterInteriorMask.get(pathKey);
        if (g != null) {
            Arrays.fill(g, (byte)0);
        }
        if (w != null) {
            Arrays.fill(w, (byte)0);
        }
        this.setDirty();
    }

    public void touch() {
        this.setDirty();
    }

    private static byte[] getByteArray(CompoundTag obj, String key) {
        ListTag list = obj.getList(key, 8);
        byte[] arr = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = Byte.parseByte(list.getString(i));
        }
        return arr;
    }

    private static void putByteArray(CompoundTag obj, String key, byte[] arr) {
        ListTag list = new ListTag();
        if (arr != null) {
            for (byte b : arr) {
                list.add((Object)StringTag.valueOf((String)Byte.toString(b)));
            }
        }
        obj.put(key, (Tag)list);
    }
}

