/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_7225;
import net.oxcodsnet.roadarchitect.util.PersistentStateUtil;

public class RoadBuilderStorage
extends class_18 {
    private static final String KEY = "road_builder_tasks";
    private static final String SEGMENTS_KEY = "segments";
    private static final String CHUNK_KEY = "chunk";
    private static final String PATH_KEY = "path";
    private static final String START_KEY = "start";
    private static final String END_KEY = "end";
    public static final class_10741<RoadBuilderStorage> TYPE = new class_10741("road_builder_tasks", ctx -> new RoadBuilderStorage(), ctx -> class_2487.field_25128.xmap(tag -> RoadBuilderStorage.fromNbt(tag, (class_7225.class_7874)ctx.comp_3639().method_30349()), storage -> storage.writeNbt(new class_2487(), (class_7225.class_7874)ctx.comp_3639().method_30349())), class_4284.field_45083);
    private final Map<class_1923, List<SegmentEntry>> segments = new ConcurrentHashMap<class_1923, List<SegmentEntry>>();

    public static RoadBuilderStorage get(class_3218 world) {
        return PersistentStateUtil.get(world, TYPE);
    }

    public static RoadBuilderStorage fromNbt(class_2487 tag, class_7225.class_7874 lookup) {
        RoadBuilderStorage storage = new RoadBuilderStorage();
        class_2499 list = tag.method_68569(SEGMENTS_KEY);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 entry = list.method_68582(i);
            class_1923 chunk = new class_1923(entry.method_68080(CHUNK_KEY, 0L));
            String path = entry.method_68564(PATH_KEY, "");
            int start = entry.method_68083(START_KEY, 0);
            int end = entry.method_68083(END_KEY, 0);
            storage.segments.computeIfAbsent(chunk, c -> new CopyOnWriteArrayList()).add(new SegmentEntry(path, start, end));
        }
        return storage;
    }

    public class_2487 writeNbt(class_2487 tag, class_7225.class_7874 lookup) {
        class_2499 list = new class_2499();
        for (Map.Entry<class_1923, List<SegmentEntry>> entry : this.segments.entrySet()) {
            long pos = entry.getKey().method_8324();
            for (SegmentEntry segment : entry.getValue()) {
                class_2487 elem = new class_2487();
                elem.method_10544(CHUNK_KEY, pos);
                elem.method_10582(PATH_KEY, segment.pathKey());
                elem.method_10569(START_KEY, segment.start());
                elem.method_10569(END_KEY, segment.end());
                list.add((Object)elem);
            }
        }
        tag.method_10566(SEGMENTS_KEY, (class_2520)list);
        return tag;
    }

    public void addSegment(class_1923 chunk, String key, int start, int end) {
        this.segments.computeIfAbsent(chunk, c -> new CopyOnWriteArrayList()).add(new SegmentEntry(key, start, end));
        this.method_80();
    }

    public List<SegmentEntry> getSegments(class_1923 chunk) {
        return this.segments.getOrDefault(chunk, List.of());
    }

    public void removeSegment(class_1923 chunk, SegmentEntry entry) {
        List<SegmentEntry> list = this.segments.get(chunk);
        if (list != null && list.remove(entry)) {
            if (list.isEmpty()) {
                this.segments.remove(chunk);
            }
            this.method_80();
        }
    }

    public record SegmentEntry(String pathKey, int start, int end) {
    }
}

