/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.api.storage;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.oxcodsnet.roadarchitect.util.PersistentStateUtil;

public final class AddonPersistentStorage
extends SavedData {
    private static final String ROOT = "entries";
    private static final String KEY = "key";
    private static final String VAL = "val";
    public static final SavedData.Factory<AddonPersistentStorage> TYPE_DEF = new SavedData.Factory(AddonPersistentStorage::new, AddonPersistentStorage::fromNbt, DataFixTypes.SAVED_DATA_MAP_DATA);
    private final Map<ResourceLocation, CompoundTag> data = new ConcurrentHashMap<ResourceLocation, CompoundTag>();
    private final ResourceLocation addonId;

    private AddonPersistentStorage() {
        this.addonId = ResourceLocation.fromNamespaceAndPath((String)"roadarchitect", (String)"unknown");
    }

    private AddonPersistentStorage(ResourceLocation addonId) {
        this.addonId = addonId;
    }

    public static AddonPersistentStorage get(ServerLevel world, ResourceLocation addonId) {
        String storageKey = AddonPersistentStorage.storageKey(addonId);
        return (AddonPersistentStorage)((Object)PersistentStateUtil.get(world, new SavedData.Factory(() -> new AddonPersistentStorage(addonId), (tag, lookup) -> AddonPersistentStorage.fromNbt(tag, lookup, addonId), DataFixTypes.SAVED_DATA_MAP_DATA), storageKey));
    }

    private static String storageKey(ResourceLocation addonId) {
        String safePath = addonId.getPath().replace('/', '_');
        return "ra_addon_" + addonId.getNamespace() + "_" + safePath;
    }

    public static AddonPersistentStorage fromNbt(CompoundTag tag, HolderLookup.Provider lookup) {
        return AddonPersistentStorage.fromNbt(tag, lookup, ResourceLocation.fromNamespaceAndPath((String)"roadarchitect", (String)"unknown"));
    }

    private static AddonPersistentStorage fromNbt(CompoundTag tag, HolderLookup.Provider lookup, ResourceLocation addonId) {
        AddonPersistentStorage s = new AddonPersistentStorage(addonId);
        ListTag list = tag.getList(ROOT, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag e = list.getCompound(i);
            ResourceLocation id = ResourceLocation.tryParse((String)e.getString(KEY));
            if (id == null) continue;
            CompoundTag val = e.getCompound(VAL);
            s.data.put(id, val.copy());
        }
        return s;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider lookup) {
        ListTag list = new ListTag();
        for (Map.Entry<ResourceLocation, CompoundTag> en : this.data.entrySet()) {
            CompoundTag e = new CompoundTag();
            e.putString(KEY, en.getKey().toString());
            e.put(VAL, (Tag)en.getValue().copy());
            list.add((Object)e);
        }
        tag.put(ROOT, (Tag)list);
        return tag;
    }

    public Optional<CompoundTag> get(ResourceLocation key) {
        return Optional.ofNullable(this.data.get(key)).map(CompoundTag::copy);
    }

    public void put(ResourceLocation key, CompoundTag value) {
        this.data.put(key, value == null ? new CompoundTag() : value.copy());
    }

    public void remove(ResourceLocation key) {
        this.data.remove(key);
    }

    public Set<ResourceLocation> keys() {
        return Collections.unmodifiableSet(this.data.keySet());
    }
}

