/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.util;

import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;

public final class NbtUtils {
    private static final String K = "k";
    private static final String V = "v";

    private NbtUtils() {
    }

    public static <E extends Enum<E>> E getEnumOrDefault(CompoundTag tag, String key, Class<E> type, E def) {
        if (!tag.contains(key)) {
            return def;
        }
        String raw = tag.getString(key);
        try {
            return Enum.valueOf(type, raw);
        }
        catch (IllegalArgumentException ex) {
            return def;
        }
    }

    public static ListTag toLongIntList(Map<Long, Integer> map) {
        ListTag list = new ListTag();
        for (Map.Entry<Long, Integer> e : map.entrySet()) {
            CompoundTag elem = new CompoundTag();
            elem.putLong(K, e.getKey().longValue());
            elem.putInt(V, e.getValue().intValue());
            list.add((Object)elem);
        }
        return list;
    }

    public static void fillLongIntMap(ListTag list, Map<Long, Integer> out) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag elem = list.getCompound(i);
            out.put(elem.getLong(K), elem.getInt(V));
        }
    }

    public static ListTag toLongDoubleList(Map<Long, Double> map) {
        ListTag list = new ListTag();
        for (Map.Entry<Long, Double> e : map.entrySet()) {
            CompoundTag elem = new CompoundTag();
            elem.putLong(K, e.getKey().longValue());
            elem.putDouble(V, e.getValue().doubleValue());
            list.add((Object)elem);
        }
        return list;
    }

    public static void fillLongDoubleMap(ListTag list, Map<Long, Double> out) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag elem = list.getCompound(i);
            out.put(elem.getLong(K), elem.getDouble(V));
        }
    }

    public static ListTag toLongStringList(Map<Long, String> map) {
        ListTag list = new ListTag();
        for (Map.Entry<Long, String> e : map.entrySet()) {
            CompoundTag elem = new CompoundTag();
            elem.putLong(K, e.getKey().longValue());
            elem.putString(V, e.getValue());
            list.add((Object)elem);
        }
        return list;
    }

    public static void fillLongStringMap(ListTag list, Map<Long, String> out) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag elem = list.getCompound(i);
            out.put(elem.getLong(K), elem.getString(V));
        }
    }
}

