/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.client.gui;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.debug.DebugEntryCategory;
import net.minecraft.client.gui.components.debug.DebugScreenDisplayer;
import net.minecraft.client.gui.components.debug.DebugScreenEntries;
import net.minecraft.client.gui.components.debug.DebugScreenEntry;
import net.minecraft.client.gui.components.debug.DebugScreenEntryStatus;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.client.gui.CacheDebugOverlayRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheDebugHudEntry
implements DebugScreenEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect/CacheDebugHudEntry");
    private static final ResourceLocation ENTRY_ID = ResourceLocation.fromNamespaceAndPath((String)"roadarchitect", (String)"cache_debug_overlay");
    private static final CacheDebugHudEntry INSTANCE = new CacheDebugHudEntry();
    private static final Method REGISTER_LOCATION = CacheDebugHudEntry.findRegisterMethod(ResourceLocation.class);
    private static final Method REGISTER_STRING = CacheDebugHudEntry.findRegisterMethod(String.class);
    private static volatile boolean registered;
    private static volatile boolean boundToDebugList;

    private CacheDebugHudEntry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register() {
        if (registered) {
            return;
        }
        Class<CacheDebugHudEntry> clazz = CacheDebugHudEntry.class;
        synchronized (CacheDebugHudEntry.class) {
            if (registered) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            if (CacheDebugHudEntry.invokeRegister(REGISTER_LOCATION, ENTRY_ID) || CacheDebugHudEntry.invokeRegister(REGISTER_STRING, ENTRY_ID.toString())) {
                registered = true;
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            LOGGER.warn("Failed to register cache debug HUD entry {}; no compatible API found", (Object)ENTRY_ID);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean bindToDebugList() {
        if (boundToDebugList) {
            return true;
        }
        if (!registered) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.debugEntries == null) {
            return false;
        }
        DebugScreenEntryStatus status = mc.debugEntries.getStatus(ENTRY_ID);
        if (status != DebugScreenEntryStatus.IN_F3) {
            mc.debugEntries.setStatus(ENTRY_ID, DebugScreenEntryStatus.IN_F3);
        }
        boundToDebugList = true;
        return true;
    }

    private static Method findRegisterMethod(Class<?> identifierType) {
        try {
            Method method = DebugScreenEntries.class.getDeclaredMethod("register", identifierType, DebugScreenEntry.class);
            method.setAccessible(true);
            return method;
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    private static boolean invokeRegister(Method method, Object identifier) {
        if (method == null) {
            return false;
        }
        try {
            method.invoke(null, identifier, INSTANCE);
            return true;
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof IllegalArgumentException) {
                LOGGER.debug("Cache debug HUD entry {} already registered via {}", (Object)ENTRY_ID, (Object)method.getParameterTypes()[0].getSimpleName());
                return true;
            }
            LOGGER.warn("Cache debug HUD entry registration failed via {}", (Object)method.getParameterTypes()[0].getSimpleName(), (Object)cause);
            return false;
        }
        catch (ReflectiveOperationException error) {
            LOGGER.warn("Cache debug HUD entry registration failed via {}", (Object)method.getParameterTypes()[0].getSimpleName(), (Object)error);
            return false;
        }
    }

    public void display(DebugScreenDisplayer displayer, Level level, LevelChunk clientChunk, LevelChunk chunk) {
        Minecraft mc = Minecraft.getInstance();
        List<Component> lines = CacheDebugOverlayRenderer.collectLines(mc);
        if (lines.isEmpty()) {
            return;
        }
        boolean header = true;
        for (Component component : lines) {
            String text = component.getString();
            if (header) {
                displayer.addPriorityLine(text);
                header = false;
                continue;
            }
            displayer.addLine(text);
        }
    }

    public boolean isAllowed(boolean reducedDebugInfo) {
        return RoadArchitect.CONFIG.debugCacheOverlay();
    }

    public DebugEntryCategory category() {
        return DebugEntryCategory.SCREEN_TEXT;
    }
}

