/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.util.CacheManager;

public final class CacheDebugOverlayRenderer {
    private static final int TEXT_COLOR = -30356;

    private CacheDebugOverlayRenderer() {
    }

    public static List<Component> collectLines(Minecraft mc) {
        if (mc == null || mc.level == null) {
            return List.of();
        }
        if (!RoadArchitect.CONFIG.debugCacheOverlay()) {
            return List.of();
        }
        if (mc.getSingleplayerServer() == null) {
            return List.of(Component.literal((String)"RoadArchitect cache: remote server"));
        }
        ServerLevel serverLevel = mc.getSingleplayerServer().getLevel(mc.level.dimension());
        if (serverLevel == null) {
            return List.of(Component.literal((String)"RoadArchitect cache: world unavailable"));
        }
        CacheManager.CacheStats stats = CacheManager.stats(serverLevel);
        if (!stats.available()) {
            return List.of(Component.literal((String)"RoadArchitect cache: inactive"));
        }
        ArrayList<Component> lines = new ArrayList<Component>();
        ResourceLocation dimensionId = serverLevel.dimension().location();
        lines.add(CacheDebugOverlayRenderer.colored("RoadArchitect cache (" + String.valueOf(dimensionId) + ")"));
        lines.add(CacheDebugOverlayRenderer.colored("  runtime: " + CacheDebugOverlayRenderer.formatUsage(stats.runtimeUsedBytes(), stats.runtimeBudgetBytes())));
        lines.add(CacheDebugOverlayRenderer.colored("  snapshots: " + CacheDebugOverlayRenderer.formatUsage(stats.snapshotUsedBytes(), stats.snapshotBudgetBytes())));
        lines.add(CacheDebugOverlayRenderer.colored("  pages: " + CacheDebugOverlayRenderer.formatUsage(stats.persistedUsedBytes(), stats.persistedBudgetBytes())));
        lines.add(CacheDebugOverlayRenderer.colored("  prefill: " + (stats.prefillEnabled() ? "ON" : "OFF") + " limit=" + stats.prefillMaxChunks()));
        return lines;
    }

    private static String formatUsage(long usedBytes, long budgetBytes) {
        double used = CacheDebugOverlayRenderer.bytesToMiB(usedBytes);
        double budget = CacheDebugOverlayRenderer.bytesToMiB(budgetBytes);
        double pct = budgetBytes > 0L ? (double)usedBytes / (double)budgetBytes * 100.0 : 0.0;
        return String.format(Locale.ROOT, "%.1f / %.1f MiB (%.0f%%)", used, budget, pct);
    }

    private static double bytesToMiB(long value) {
        return (double)value / 1024.0 / 1024.0;
    }

    private static Component colored(String text) {
        return Component.literal((String)text).withStyle(style -> style.withColor(-30356));
    }
}

