/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.neoforge.client;

import java.lang.reflect.Proxy;
import java.util.function.Supplier;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.common.NeoForge;
import net.oxcodsnet.roadarchitect.client.gui.CacheDebugHudEntry;
import net.oxcodsnet.roadarchitect.neoforge.client.CacheDebugHudNeoForge;
import net.oxcodsnet.roadarchitect.neoforge.client.RAKeybinds;
import net.oxcodsnet.roadarchitect.neoforge.client.hook.DebugGraphScreenHook;
import net.oxcodsnet.roadarchitect.neoforge.client.hook.LoadingOverlaySubscriber;
import net.oxcodsnet.roadarchitect.neoforge.config.RAConfigNeoForgeBridge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RAClientBootstrap {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + RAClientBootstrap.class.getSimpleName()));

    private RAClientBootstrap() {
    }

    public static void init(IEventBus modBus, ModContainer container) {
        RAClientBootstrap.registerConfigScreen(container);
        RAClientBootstrap.registerClientEvents(modBus);
    }

    private static void registerConfigScreen(ModContainer container) {
        LOGGER.info("I'll try to register the configuration screen");
        try {
            Class<?> factoryClass = Class.forName("net.neoforged.neoforge.client.gui.IConfigScreenFactory");
            Object factory = Proxy.newProxyInstance(factoryClass.getClassLoader(), new Class[]{factoryClass}, (proxy, method, args) -> RAConfigNeoForgeBridge.createScreen(args[1]));
            Supplier<Object> supplier = () -> factory;
            ModLoadingContext.get().registerExtensionPoint(factoryClass, supplier);
            LOGGER.info("The configuration screen is successfully registered");
        }
        catch (ReflectiveOperationException e) {
            LOGGER.warn("The configuration screen is not registered due to error:", (Throwable)e);
        }
    }

    private static void registerClientEvents(IEventBus modBus) {
        CacheDebugHudEntry.register();
        CacheDebugHudNeoForge.bootstrap();
        modBus.addListener(RAKeybinds::registerKeys);
        NeoForge.EVENT_BUS.addListener(DebugGraphScreenHook::onKey);
        NeoForge.EVENT_BUS.addListener(LoadingOverlaySubscriber::onRender);
    }
}

