/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.client.gui;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.class_11605;
import net.minecraft.class_11630;
import net.minecraft.class_11631;
import net.minecraft.class_11632;
import net.minecraft.class_11635;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.client.gui.CacheDebugOverlayRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheDebugHudEntry
implements class_11632 {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect/CacheDebugHudEntry");
    private static final class_2960 ENTRY_ID = class_2960.method_60655((String)"roadarchitect", (String)"cache_debug_overlay");
    private static final CacheDebugHudEntry INSTANCE = new CacheDebugHudEntry();
    private static final Method REGISTER_LOCATION = CacheDebugHudEntry.findRegisterMethod(class_2960.class);
    private static final Method REGISTER_STRING = CacheDebugHudEntry.findRegisterMethod(String.class);
    private static volatile boolean registered;
    private static volatile boolean boundToDebugList;

    private CacheDebugHudEntry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register() {
        if (registered) {
            return;
        }
        Class<CacheDebugHudEntry> clazz = CacheDebugHudEntry.class;
        synchronized (CacheDebugHudEntry.class) {
            if (registered) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            if (CacheDebugHudEntry.invokeRegister(REGISTER_LOCATION, ENTRY_ID) || CacheDebugHudEntry.invokeRegister(REGISTER_STRING, ENTRY_ID.toString())) {
                registered = true;
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            LOGGER.warn("Failed to register cache debug HUD entry {}; no compatible API found", (Object)ENTRY_ID);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean bindToDebugList() {
        if (boundToDebugList) {
            return true;
        }
        if (!registered) {
            return false;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_61504 == null) {
            return false;
        }
        class_11635 status = mc.field_61504.method_72766(ENTRY_ID);
        if (status != class_11635.field_61594) {
            mc.field_61504.method_72767(ENTRY_ID, class_11635.field_61594);
        }
        boundToDebugList = true;
        return true;
    }

    private static Method findRegisterMethod(Class<?> identifierType) {
        try {
            Method method = class_11631.class.getDeclaredMethod("register", identifierType, class_11632.class);
            method.setAccessible(true);
            return method;
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    private static boolean invokeRegister(Method method, Object identifier) {
        if (method == null) {
            return false;
        }
        try {
            method.invoke(null, identifier, INSTANCE);
            return true;
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof IllegalArgumentException) {
                LOGGER.debug("Cache debug HUD entry {} already registered via {}", (Object)ENTRY_ID, (Object)method.getParameterTypes()[0].getSimpleName());
                return true;
            }
            LOGGER.warn("Cache debug HUD entry registration failed via {}", (Object)method.getParameterTypes()[0].getSimpleName(), (Object)cause);
            return false;
        }
        catch (ReflectiveOperationException error) {
            LOGGER.warn("Cache debug HUD entry registration failed via {}", (Object)method.getParameterTypes()[0].getSimpleName(), (Object)error);
            return false;
        }
    }

    public void method_72751(class_11630 displayer, class_1937 level, class_2818 clientChunk, class_2818 chunk) {
        class_310 mc = class_310.method_1551();
        List<class_2561> lines = CacheDebugOverlayRenderer.collectLines(mc);
        if (lines.isEmpty()) {
            return;
        }
        boolean header = true;
        for (class_2561 component : lines) {
            String text = component.getString();
            if (header) {
                displayer.method_72745(text);
                header = false;
                continue;
            }
            displayer.method_72747(text);
        }
    }

    public boolean method_72753(boolean reducedDebugInfo) {
        return RoadArchitect.CONFIG.debugCacheOverlay();
    }

    public class_11605 method_72759() {
        return class_11605.field_61538;
    }
}

