/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.util.CacheManager;

public final class CacheDebugOverlayRenderer {
    private static final int TEXT_COLOR = -30356;

    private CacheDebugOverlayRenderer() {
    }

    public static List<class_2561> collectLines(class_310 mc) {
        if (mc == null || mc.field_1687 == null) {
            return List.of();
        }
        if (!RoadArchitect.CONFIG.debugCacheOverlay()) {
            return List.of();
        }
        if (mc.method_1576() == null) {
            return List.of(class_2561.method_43470((String)"RoadArchitect cache: remote server"));
        }
        class_3218 serverLevel = mc.method_1576().method_3847(mc.field_1687.method_27983());
        if (serverLevel == null) {
            return List.of(class_2561.method_43470((String)"RoadArchitect cache: world unavailable"));
        }
        CacheManager.CacheStats stats = CacheManager.stats(serverLevel);
        if (!stats.available()) {
            return List.of(class_2561.method_43470((String)"RoadArchitect cache: inactive"));
        }
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        class_2960 dimensionId = serverLevel.method_27983().method_29177();
        lines.add(CacheDebugOverlayRenderer.colored("RoadArchitect cache (" + String.valueOf(dimensionId) + ")"));
        lines.add(CacheDebugOverlayRenderer.colored("  runtime: " + CacheDebugOverlayRenderer.formatUsage(stats.runtimeUsedBytes(), stats.runtimeBudgetBytes())));
        lines.add(CacheDebugOverlayRenderer.colored("  snapshots: " + CacheDebugOverlayRenderer.formatUsage(stats.snapshotUsedBytes(), stats.snapshotBudgetBytes())));
        lines.add(CacheDebugOverlayRenderer.colored("  pages: " + CacheDebugOverlayRenderer.formatUsage(stats.persistedUsedBytes(), stats.persistedBudgetBytes())));
        lines.add(CacheDebugOverlayRenderer.colored("  prefill: " + (stats.prefillEnabled() ? "ON" : "OFF") + " limit=" + stats.prefillMaxChunks()));
        return lines;
    }

    private static String formatUsage(long usedBytes, long budgetBytes) {
        double used = CacheDebugOverlayRenderer.bytesToMiB(usedBytes);
        double budget = CacheDebugOverlayRenderer.bytesToMiB(budgetBytes);
        double pct = budgetBytes > 0L ? (double)usedBytes / (double)budgetBytes * 100.0 : 0.0;
        return String.format(Locale.ROOT, "%.1f / %.1f MiB (%.0f%%)", used, budget, pct);
    }

    private static double bytesToMiB(long value) {
        return (double)value / 1024.0 / 1024.0;
    }

    private static class_2561 colored(String text) {
        return class_2561.method_43470((String)text).method_27694(style -> style.method_36139(-30356));
    }
}

