/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.util;

import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.server.MinecraftServer;
import net.oxcodsnet.roadarchitect.config.records.CacheSettings;
import net.oxcodsnet.roadarchitect.storage.CacheStorage;
import net.oxcodsnet.roadarchitect.util.AsyncExecutor;
import net.oxcodsnet.roadarchitect.util.DebugLog;
import net.oxcodsnet.roadarchitect.util.cache.ChunkHeightGenerator;
import net.oxcodsnet.roadarchitect.util.cache.ChunkHeightSnapshot;
import net.oxcodsnet.roadarchitect.util.cache.WorldCacheState;
import net.oxcodsnet.roadarchitect.util.profiler.PipelineProfiler;
import net.oxcodsnet.roadarchitect.worldgen.RoadFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + CacheManager.class.getSimpleName()));
    private static final Map<class_5321<class_1937>, WorldCacheState> STATES = new ConcurrentHashMap<class_5321<class_1937>, WorldCacheState>();
    private static final int CHUNK_SIDE = 16;
    private static final int COLUMNS_PER_CHUNK = 256;

    private CacheManager() {
    }

    public static void onWorldLoad(class_3218 world) {
        if (world.method_8608()) {
            return;
        }
        CacheManager.load(world);
    }

    public static void onWorldUnload(class_3218 world) {
        if (world.method_8608()) {
            return;
        }
        CacheManager.save(world);
    }

    public static void onServerStopping(MinecraftServer server) {
        for (class_3218 world : server.method_3738()) {
            CacheManager.save(world);
        }
    }

    private static WorldCacheState state(class_3218 world) {
        return STATES.computeIfAbsent((class_5321<class_1937>)world.method_27983(), k -> {
            CacheStorage storage = CacheStorage.open(world);
            return new WorldCacheState(world, storage, storage.settings());
        });
    }

    private static void load(class_3218 world) {
        CacheStorage storage = CacheStorage.open(world);
        CacheSettings settings = storage.settings();
        STATES.put((class_5321<class_1937>)world.method_27983(), new WorldCacheState(world, storage, settings));
        DebugLog.info(LOGGER, "Cache loaded for world {}", world.method_27983().method_29177());
        DebugLog.cache(LOGGER, "Cache budgets for {} -> runtime={}MiB snapshot={}MiB persisted={}MiB", world.method_27983().method_29177(), settings.runtimeBudgetMb(), settings.snapshotBudgetMb(), settings.persistedBudgetMb());
    }

    private static void save(class_3218 world) {
        WorldCacheState state = STATES.remove(world.method_27983());
        if (state != null) {
            state.flush();
            DebugLog.info(LOGGER, "Cache saved for world {}", world.method_27983().method_29177());
            DebugLog.cache(LOGGER, "Cache flushed for world {}", world.method_27983().method_29177());
        }
    }

    public static void prefill(class_3218 world, int minX, int minZ, int maxX, int maxZ) {
        WorldCacheState state = CacheManager.state(world);
        CacheStorage storage = state.storage();
        CacheSettings cacheSettings = storage.settings();
        if (!cacheSettings.enablePrefill()) {
            DebugLog.info(LOGGER, "Skipping prefill for {} because it is disabled via config", world.method_27983().method_29177());
            DebugLog.cache(LOGGER, "Prefill skipped for {}: disabled", world.method_27983().method_29177());
            return;
        }
        long runtimeBudget = cacheSettings.runtimeBudgetBytes();
        long current = storage.runtimeWeightBytes();
        if ((double)current >= (double)runtimeBudget * 0.9) {
            DebugLog.info(LOGGER, "Skipping prefill for {} because runtime cache is at {} of {}", world.method_27983().method_29177(), current, runtimeBudget);
            DebugLog.cache(LOGGER, "Prefill skipped for {}: runtime usage {} of {}", world.method_27983().method_29177(), current, runtimeBudget);
            return;
        }
        int minChunkX = Math.floorDiv(minX, 16);
        int maxChunkX = Math.floorDiv(maxX, 16);
        int minChunkZ = Math.floorDiv(minZ, 16);
        int maxChunkZ = Math.floorDiv(maxZ, 16);
        if (minChunkX > maxChunkX || minChunkZ > maxChunkZ) {
            return;
        }
        int totalChunks = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
        int limit = cacheSettings.clampedPrefillMaxChunks();
        if (limit <= 0 || totalChunks <= 0) {
            DebugLog.info(LOGGER, "Prefill skipped: no chunks selected or limit is zero", new Object[0]);
            DebugLog.cache(LOGGER, "Prefill skipped for {}: no eligible chunks (limit={})", world.method_27983().method_29177(), limit);
            return;
        }
        int target = Math.min(totalChunks, limit);
        class_2794 generator = world.method_14178().method_12129();
        class_7138 randomState = world.method_14178().method_41248();
        class_6544.class_6552 sampler = randomState.method_42371();
        class_1966 biomeSource = generator.method_12098();
        int stride = Math.max(1, 4);
        int scheduled = 0;
        for (int chunkX = minChunkX; chunkX <= maxChunkX && scheduled < target; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ && scheduled < target; ++scheduled, ++chunkZ) {
                class_1923 pos = new class_1923(chunkX, chunkZ);
                AsyncExecutor.execute(() -> {
                    CacheManager.warmChunk(world, state, storage, pos);
                    CacheManager.prefillBiomes(world, storage, biomeSource, sampler, pos, stride);
                });
            }
        }
        DebugLog.info(LOGGER, "Scheduled {} chunk prefill tasks within [{}..{}]\u00d7[{}..{}]", scheduled, minX, maxX, minZ, maxZ);
        DebugLog.cache(LOGGER, "Prefill scheduled {} chunks for {} (limit={}, runtime={}MiB)", scheduled, world.method_27983().method_29177(), limit, cacheSettings.runtimeBudgetMb());
    }

    private static void warmChunk(class_3218 world, WorldCacheState state, CacheStorage storage, class_1923 pos) {
        long key = CacheManager.hash(pos.method_8326(), pos.method_8328());
        CacheManager.ensureChunkSnapshot(world, state, storage, key);
    }

    private static void prefillBiomes(class_3218 world, CacheStorage storage, class_1966 biomeSource, class_6544.class_6552 sampler, class_1923 pos, int stride) {
        int baseX = pos.method_8326();
        int baseZ = pos.method_8328();
        for (int localX = 0; localX < 16; localX += stride) {
            for (int localZ = 0; localZ < 16; localZ += stride) {
                int worldX = baseX + localX;
                int worldZ = baseZ + localZ;
                long key = CacheManager.hash(worldX, worldZ);
                if (storage.getBiome(key) != null) continue;
                class_6880 biome = biomeSource.method_38109(class_5742.method_33100((int)worldX), 316, class_5742.method_33100((int)worldZ), sampler);
                storage.putBiome(key, (class_6880<class_1959>)biome);
            }
        }
    }

    public static int getHeight(class_3218 world, long key, IntSupplier loader) {
        PipelineProfiler.increment("cache.height.requests");
        WorldCacheState state = CacheManager.state(world);
        CacheStorage storage = state.storage();
        Integer cached = storage.getHeight(key);
        if (cached != null) {
            PipelineProfiler.increment("cache.height.hits");
            return cached;
        }
        Integer chunkCached = state.lookupHeight(key, 16);
        if (chunkCached != null) {
            storage.putHeightIfAbsent(key, chunkCached);
            PipelineProfiler.increment("cache.height.hits");
            return chunkCached;
        }
        ChunkHeightSnapshot snapshot = CacheManager.ensureChunkSnapshot(world, state, storage, key);
        if (snapshot != null) {
            int x = (int)(key >> 32);
            int z = (int)key;
            int localX = x & 0xF;
            int localZ = z & 0xF;
            int value = snapshot.get(localX, localZ);
            storage.putHeightIfAbsent(key, value);
            PipelineProfiler.increment("cache.height.hits");
            return value;
        }
        return storage.computeHeightIfAbsent(key, () -> {
            PipelineProfiler.increment("cache.height.loads");
            try (PipelineProfiler.Section section = PipelineProfiler.openSection("cache.height.load_time");){
                int value = loader.getAsInt();
                PipelineProfiler.recordValue("cache.height.loaded_value", value);
                int n = value;
                return n;
            }
        });
    }

    public static int getHeight(class_3218 world, int x, int z) {
        long key = CacheManager.hash(x, z);
        OptionalInt prepared = RoadFeature.lookupPreparedSurface(x, z);
        if (prepared.isPresent()) {
            int value = prepared.getAsInt();
            WorldCacheState state = CacheManager.state(world);
            state.storage().putHeightIfAbsent(key, value);
            return value;
        }
        return CacheManager.getHeight(world, key, () -> {
            class_2794 gen = world.method_14178().method_12129();
            class_7138 cfg = world.method_14178().method_41248();
            return gen.method_16397(x, z, class_2902.class_2903.field_13194, (class_5539)world, cfg);
        });
    }

    public static double getStability(class_3218 world, long key, DoubleSupplier loader) {
        PipelineProfiler.increment("cache.stability.requests");
        WorldCacheState state = CacheManager.state(world);
        CacheStorage storage = state.storage();
        Double cached = storage.getStability(key);
        if (cached != null) {
            PipelineProfiler.increment("cache.stability.hits");
            return cached;
        }
        return storage.computeStabilityIfAbsent(key, () -> {
            PipelineProfiler.increment("cache.stability.loads");
            try (PipelineProfiler.Section section = PipelineProfiler.openSection("cache.stability.load_time");){
                double value = loader.getAsDouble();
                PipelineProfiler.recordValue("cache.stability.loaded_value", value);
                double d = value;
                return d;
            }
        });
    }

    public static class_6880<class_1959> getBiome(class_3218 world, long key, Supplier<class_6880<class_1959>> loader) {
        PipelineProfiler.increment("cache.biome.requests");
        WorldCacheState state = CacheManager.state(world);
        CacheStorage storage = state.storage();
        class_6880<class_1959> cached = storage.getBiome(key);
        if (cached != null) {
            PipelineProfiler.increment("cache.biome.hits");
            return cached;
        }
        return storage.computeBiomeIfAbsent(key, () -> {
            PipelineProfiler.increment("cache.biome.loads");
            try (PipelineProfiler.Section section = PipelineProfiler.openSection("cache.biome.load_time");){
                class_6880 value;
                class_6880 class_68802 = value = (class_6880)loader.get();
                return class_68802;
            }
        });
    }

    public static long hash(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    public static class_2338 keyToPos(long k) {
        return new class_2338((int)(k >> 32), 0, (int)k);
    }

    public static void onChunkLoad(class_3218 world, class_2791 chunk) {
        if (world.method_8608()) {
            return;
        }
        WorldCacheState state = STATES.get(world.method_27983());
        if (state == null) {
            return;
        }
        class_1923 pos = chunk.method_12004();
        int startX = pos.method_8326();
        int startZ = pos.method_8328();
        int minY = state.minWorldY();
        class_2902 wg = chunk.method_12032(class_2902.class_2903.field_13194);
        class_2902 surface = chunk.method_12032(class_2902.class_2903.field_13202);
        if (wg == null && surface == null) {
            return;
        }
        if (wg == null) {
            wg = surface;
        }
        if (surface == null) {
            surface = wg;
        }
        int[] snapshot = new int[256];
        CacheStorage storage = state.storage();
        for (int localZ = 0; localZ < 16; ++localZ) {
            for (int localX = 0; localX < 16; ++localX) {
                int idx = localZ * 16 + localX;
                int height = wg.method_12603(localX, localZ);
                if (height <= minY) {
                    height = surface.method_12603(localX, localZ);
                }
                snapshot[idx] = height;
                long key = CacheManager.hash(startX + localX, startZ + localZ);
                storage.putHeight(key, height);
            }
        }
        state.putChunkSnapshot(pos.method_8324(), new ChunkHeightSnapshot(snapshot, 16));
        DebugLog.cache(LOGGER, "Chunk snapshot refreshed for {} ({})", pos, world.method_27983().method_29177());
    }

    public static void onChunkUnload(class_3218 world, class_1923 pos) {
        if (world.method_8608()) {
            return;
        }
        WorldCacheState state = STATES.get(world.method_27983());
        if (state != null) {
            state.removeChunkSnapshot(pos.method_8324());
            DebugLog.cache(LOGGER, "Chunk snapshot released for {} ({})", pos, world.method_27983().method_29177());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ChunkHeightSnapshot ensureChunkSnapshot(class_3218 world, WorldCacheState state, CacheStorage storage, long key) {
        int x = (int)(key >> 32);
        int z = (int)key;
        class_1923 chunkPos = new class_1923(x >> 4, z >> 4);
        long chunkKey = chunkPos.method_8324();
        ChunkHeightSnapshot cached = state.getChunkSnapshot(chunkKey);
        if (cached != null) {
            return cached;
        }
        CompletableFuture<ChunkHeightSnapshot> future = new CompletableFuture<ChunkHeightSnapshot>();
        CompletableFuture existing = state.chunkComputations().putIfAbsent(chunkKey, future);
        if (existing != null) {
            try {
                return (ChunkHeightSnapshot)existing.join();
            }
            catch (RuntimeException e) {
                DebugLog.info(LOGGER, "Height snapshot future failed for chunk {}", chunkPos, e);
                return null;
            }
        }
        try {
            ChunkHeightSnapshot generated = ChunkHeightGenerator.generate(world, state, storage, chunkPos, 16, 256);
            if (generated != null) {
                state.putChunkSnapshot(chunkKey, generated);
                DebugLog.cache(LOGGER, "Snapshot computed for chunk {} ({} columns)", chunkPos, generated.columns());
            }
            future.complete(generated);
            ChunkHeightSnapshot chunkHeightSnapshot = generated;
            return chunkHeightSnapshot;
        }
        catch (RuntimeException e) {
            future.completeExceptionally(e);
            LOGGER.error("Failed to compute height snapshot for chunk {}", (Object)chunkPos, (Object)e);
            ChunkHeightSnapshot chunkHeightSnapshot = null;
            return chunkHeightSnapshot;
        }
        finally {
            state.chunkComputations().remove(chunkKey);
        }
    }

    public static CacheStats stats(class_3218 world) {
        WorldCacheState state = STATES.get(world.method_27983());
        if (state == null) {
            return CacheStats.UNAVAILABLE;
        }
        CacheStorage storage = state.storage();
        CacheSettings settings = storage.settings();
        return new CacheStats(true, storage.runtimeWeightBytes(), settings.runtimeBudgetBytes(), state.snapshotWeightBytes(), settings.snapshotBudgetBytes(), storage.regionWeightBytes(), settings.persistedBudgetBytes(), settings.enablePrefill(), settings.clampedPrefillMaxChunks());
    }

    public record CacheStats(boolean available, long runtimeUsedBytes, long runtimeBudgetBytes, long snapshotUsedBytes, long snapshotBudgetBytes, long persistedUsedBytes, long persistedBudgetBytes, boolean prefillEnabled, int prefillMaxChunks) {
        public static final CacheStats UNAVAILABLE = new CacheStats(false, 0L, 0L, 0L, 0L, 0L, 0L, false, 0);
    }
}

