/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.config.records;

public record CacheSettings(int runtimeBudgetMb, int snapshotBudgetMb, int persistedBudgetMb, int regionSizeChunks, boolean enablePrefill, int prefillMaxChunks, boolean persistHeights, boolean persistStabilities, boolean persistBiomes) {
    private static final double HEAP_FRACTION = 0.65;
    private static final int MIN_CACHE_MB = 16;
    public static final CacheSettings DEFAULT = new CacheSettings(256, 128, 256, 128, true, 2048, true, true, true);

    public long runtimeBudgetBytes() {
        return CacheSettings.megabytesToBytes(this.runtimeBudgetMb);
    }

    public long snapshotBudgetBytes() {
        return CacheSettings.megabytesToBytes(this.snapshotBudgetMb);
    }

    public long persistedBudgetBytes() {
        return CacheSettings.megabytesToBytes(this.persistedBudgetMb);
    }

    public int clampedRegionSize() {
        return Math.max(4, this.regionSizeChunks);
    }

    public int clampedPrefillMaxChunks() {
        return Math.max(0, this.prefillMaxChunks);
    }

    public CacheSettings clampToRuntime() {
        long heapBytes = Runtime.getRuntime().maxMemory();
        long heapMb = Math.max(128L, heapBytes / 0x100000L);
        long capMb = Math.max(64L, (long)Math.floor((double)heapMb * 0.65));
        return new CacheSettings(CacheSettings.clampBudget(this.runtimeBudgetMb, capMb), CacheSettings.clampBudget(this.snapshotBudgetMb, capMb), CacheSettings.clampBudget(this.persistedBudgetMb, capMb), this.clampedRegionSize(), this.enablePrefill, this.clampedPrefillMaxChunks(), this.persistHeights, this.persistStabilities, this.persistBiomes);
    }

    private static int clampBudget(int configuredMb, long capMb) {
        int sanitized = Math.max(16, configuredMb);
        long clamped = Math.min((long)sanitized, capMb);
        if (clamped > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)clamped;
    }

    private static long megabytesToBytes(int value) {
        long safe = Math.max(1, value);
        return safe * 1024L * 1024L;
    }
}

