/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.util;

import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7138;
import net.oxcodsnet.roadarchitect.storage.NodeStorage;
import net.oxcodsnet.roadarchitect.storage.components.Node;
import net.oxcodsnet.roadarchitect.util.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathFinder {
    public static final int GRID_STEP = 4;
    public static final double HEURISTIC_WEIGHT = 1.8;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect/PathFinder");
    private static final int[][] OFFSETS = PathFinder.generateOffsets();
    private static final Map<class_6862<class_1959>, Double> BIOME_COSTS = Map.of(class_6908.field_36511, 400.0, class_6908.field_36509, 999.0, class_6908.field_36508, 999.0, class_6908.field_36512, 160.0, class_6908.field_36510, 160.0);
    private final NodeStorage nodes;
    private final class_3218 world;
    private final int maxSteps;
    private final double heuristicWeight;
    private final class_2794 generator;
    private final class_7138 noiseConfig;
    private final class_6544.class_6552 noiseSampler;
    private final class_1966 biomeSource;

    public PathFinder(NodeStorage nodes, class_3218 world, int maxSteps) {
        this(nodes, world, maxSteps, 1.8);
    }

    public PathFinder(NodeStorage nodes, class_3218 world, int maxSteps, double heuristicWeight) {
        this.nodes = nodes;
        this.world = world;
        this.maxSteps = maxSteps;
        this.heuristicWeight = heuristicWeight;
        this.generator = world.method_14178().method_12129();
        this.noiseConfig = world.method_14178().method_41248();
        this.noiseSampler = this.noiseConfig.method_42371();
        this.biomeSource = this.generator.method_12098();
    }

    private static double stepCost(int[] off) {
        return Math.abs(off[0]) == 4 && Math.abs(off[1]) == 4 ? 1.5 : 1.0;
    }

    private static double elevationCost(int y1, int y2) {
        return (double)Math.abs(y1 - y2) * 40.0;
    }

    private static double biomeCost(class_6880<class_1959> biome) {
        for (Map.Entry<class_6862<class_1959>, Double> entry : BIOME_COSTS.entrySet()) {
            if (!biome.method_40220(entry.getKey())) continue;
            return entry.getValue();
        }
        return 0.0;
    }

    private static double yLevelCost(int y) {
        return y <= 63 ? 240.0 : 0.0;
    }

    private static boolean isSteep(int y1, int y2) {
        return Math.abs(y1 - y2) > 3;
    }

    private static double heuristic(int x, int z, class_2338 goal) {
        int dx = Math.abs(x - goal.method_10263());
        int dz = Math.abs(z - goal.method_10260());
        double a = (double)(dx + dz) - 0.6 * (double)Math.min(dx, dz);
        return a * 40.0;
    }

    private static double heuristic(class_2338 a, class_2338 b) {
        return PathFinder.heuristic(a.method_10263(), a.method_10260(), b);
    }

    private static class_2338 snap(class_2338 p) {
        int x = Math.floorDiv(p.method_10263(), 4) * 4;
        int z = Math.floorDiv(p.method_10260(), 4) * 4;
        return new class_2338(x, p.method_10264(), z);
    }

    private static int[][] generateOffsets() {
        int d = 4;
        return new int[][]{{d, 0}, {-d, 0}, {0, d}, {0, -d}, {d, d}, {d, -d}, {-d, d}, {-d, -d}};
    }

    public List<class_2338> findPath(String fromId, String toId) {
        Node startNode = this.nodes.all().get(fromId);
        Node endNode = this.nodes.all().get(toId);
        if (startNode == null || endNode == null) {
            LOGGER.debug("Missing node(s) {} or {}", (Object)fromId, (Object)toId);
            return List.of();
        }
        return this.aStarPositions(PathFinder.snap(startNode.pos()), PathFinder.snap(endNode.pos()));
    }

    public List<class_2338> findPath(class_2338 from, class_2338 to) {
        return this.aStarPositions(PathFinder.snap(from), PathFinder.snap(to));
    }

    private List<class_2338> aStarPositions(class_2338 startPos, class_2338 endPos) {
        long startKey = CacheManager.hash(startPos.method_10263(), startPos.method_10260());
        long endKey = CacheManager.hash(endPos.method_10263(), endPos.method_10260());
        PriorityQueue<Rec> open = new PriorityQueue<Rec>(Comparator.comparingDouble(r -> r.f));
        Long2DoubleOpenHashMap gScore = new Long2DoubleOpenHashMap();
        gScore.defaultReturnValue(Double.MAX_VALUE);
        Long2LongOpenHashMap parent = new Long2LongOpenHashMap();
        gScore.put(startKey, 0.0);
        record Rec(long key, double g, double f) {
        }
        open.add(new Rec(startKey, 0.0, PathFinder.heuristic(startPos, endPos) * this.heuristicWeight));
        int iterations = 0;
        while (!open.isEmpty() && iterations++ < this.maxSteps) {
            Rec current = open.poll();
            int curX = (int)(current.key >> 32);
            int curZ = (int)current.key;
            int curY = this.sampleHeight(curX, curZ);
            if (current.key == endKey) {
                return this.reconstructVertices(current.key, startKey, (Long2LongMap)parent);
            }
            for (int[] off : OFFSETS) {
                double tentativeG;
                double bCost;
                double stab;
                int nx = curX + off[0];
                int nz = curZ + off[1];
                long neighKey = CacheManager.hash(nx, nz);
                int ny = this.sampleHeight(nx, nz);
                if (PathFinder.isSteep(curY, ny) || (stab = this.sampleStability(nx, nz, ny)) == Double.MAX_VALUE || (bCost = PathFinder.biomeCost(this.sampleBiome(nx, nz, ny))) >= 999.0 || !((tentativeG = gScore.get(current.key) + PathFinder.stepCost(off) + PathFinder.elevationCost(curY, ny) + bCost + PathFinder.yLevelCost(ny) + stab) < gScore.get(neighKey))) continue;
                parent.put(neighKey, current.key);
                gScore.put(neighKey, tentativeG);
                double f = tentativeG + PathFinder.heuristic(nx, nz, endPos) * this.heuristicWeight;
                open.add(new Rec(neighKey, tentativeG, f));
            }
        }
        LOGGER.debug("Path not found between {} and {} after {} iterations", new Object[]{startPos, endPos, iterations});
        return List.of();
    }

    private int sampleHeight(int x, int z) {
        long key = CacheManager.hash(x, z);
        return CacheManager.getHeight(this.world, key, () -> this.generator.method_16397(x, z, class_2902.class_2903.field_13194, (class_5539)this.world, this.noiseConfig));
    }

    private double sampleStability(int x, int z, int y) {
        long key = CacheManager.hash(x, z);
        return CacheManager.getStability(this.world, key, () -> this.terrainStabilityCost(x, z, y));
    }

    private class_6880<class_1959> sampleBiome(int x, int z, int y) {
        long key = CacheManager.hash(x, z);
        return CacheManager.getBiome(this.world, key, () -> this.biomeSource.method_38109(class_5742.method_33100((int)x), 316, class_5742.method_33100((int)z), this.noiseSampler));
    }

    private double terrainStabilityCost(int x, int z, int y) {
        int cost = 0;
        for (class_2350 d : class_2350.class_2353.field_11062) {
            int ny = this.sampleHeight(x + d.method_10148(), z + d.method_10165());
            if ((cost += Math.abs(y - ny)) <= 2) continue;
            return Double.MAX_VALUE;
        }
        return (double)cost * 16.0;
    }

    private List<class_2338> reconstructVertices(long goal, long start, Long2LongMap parent) {
        ArrayList<class_2338> vertices = new ArrayList<class_2338>();
        long k = goal;
        while (true) {
            class_2338 p = CacheManager.keyToPos(k);
            int y = this.sampleHeight(p.method_10263(), p.method_10260());
            vertices.add(new class_2338(p.method_10263(), y, p.method_10260()));
            if (k == start) break;
            k = parent.get(k);
        }
        Collections.reverse(vertices);
        return vertices;
    }
}

