package dev.mariany.genesisframework.advancement.criterion;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import net.minecraft.class_175;
import net.minecraft.class_2048;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;

public class CompleteTrialSpawnerCriteria extends class_4558<CompleteTrialSpawnerCriteria.Conditions> {
    @Override
    public Codec<Conditions> method_54937() {
        return Conditions.CODEC;
    }

    public void trigger(class_3222 player, boolean ominous) {
        this.method_22510(player, conditions -> conditions.matches(ominous));
    }

    public record Conditions(Optional<class_5258> player, boolean expectOminous)
            implements class_4558.class_8788 {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(
                instance -> instance.group(
                                class_2048.field_47250
                                        .optionalFieldOf("player")
                                        .forGetter(Conditions::comp_2029),
                                Codec.BOOL.fieldOf("ominous")
                                        .forGetter(Conditions::expectOminous)
                        )
                        .apply(instance, Conditions::new)
        );

        public static class_175<Conditions> create(boolean ominous) {
            return create(null, ominous);
        }

        public static class_175<Conditions> create(
                @Nullable class_5258 playerPredicate,
                boolean ominous
        ) {
            return GFCriteria.COMPLETE_TRIAL_SPAWNER_ADVANCEMENT.method_53699(
                    new Conditions(Optional.ofNullable(playerPredicate), ominous)
            );
        }

        public boolean matches(boolean ominous) {
            return ominous == expectOminous;
        }
    }
}
