package dev.mariany.genesisframework.advancement.criterion;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import net.minecraft.class_175;
import net.minecraft.class_2048;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import net.minecraft.class_8779;

public class ObtainAdvancementCriterion extends class_4558<ObtainAdvancementCriterion.Conditions> {
    @Override
    public Codec<Conditions> method_54937() {
        return Conditions.CODEC;
    }

    public void trigger(class_3222 player, class_8779 advancementEntry) {
        this.method_22510(player, conditions -> conditions.matches(advancementEntry));
    }

    public record Conditions(Optional<class_5258> player, class_2960 advancementId)
            implements class_4558.class_8788 {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(
                instance -> instance.group(
                                class_2048.field_47250.optionalFieldOf("player").forGetter(Conditions::comp_2029),
                                class_2960.field_25139.fieldOf("advancement").forGetter(Conditions::advancementId)
                        )
                        .apply(instance, Conditions::new)
        );

        public static class_175<Conditions> create(class_2960 advancementId) {
            return create(null, advancementId);
        }

        public static class_175<Conditions> create(@Nullable class_5258 playerPredicate, class_2960 advancementId) {
            return GFCriteria.OBTAIN_ADVANCEMENT.method_53699(new Conditions(Optional.ofNullable(playerPredicate), advancementId));
        }

        public boolean matches(class_8779 advancementEntry) {
            return this.advancementId.equals(advancementEntry.comp_1919());
        }
    }
}
